/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutStoredQueryResponse extends ConfigResponse implements
        ToCopyableBuilder<PutStoredQueryResponse.Builder, PutStoredQueryResponse> {
    private static final SdkField<String> QUERY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryArn").getter(getter(PutStoredQueryResponse::queryArn)).setter(setter(Builder::queryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ARN_FIELD));

    private final String queryArn;

    private PutStoredQueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryArn = builder.queryArn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the query. For example,
     * arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the query. For example,
     *         arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
     */
    public final String queryArn() {
        return queryArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStoredQueryResponse)) {
            return false;
        }
        PutStoredQueryResponse other = (PutStoredQueryResponse) obj;
        return Objects.equals(queryArn(), other.queryArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutStoredQueryResponse").add("QueryArn", queryArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryArn":
            return Optional.ofNullable(clazz.cast(queryArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutStoredQueryResponse, T> g) {
        return obj -> g.apply((PutStoredQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutStoredQueryResponse> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the query. For example,
         * arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
         * </p>
         * 
         * @param queryArn
         *        Amazon Resource Name (ARN) of the query. For example,
         *        arn:partition:service:region:account-id:resource-type/resource-name/resource-id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryArn(String queryArn);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String queryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutStoredQueryResponse model) {
            super(model);
            queryArn(model.queryArn);
        }

        public final String getQueryArn() {
            return queryArn;
        }

        public final void setQueryArn(String queryArn) {
            this.queryArn = queryArn;
        }

        @Override
        @Transient
        public final Builder queryArn(String queryArn) {
            this.queryArn = queryArn;
            return this;
        }

        @Override
        public PutStoredQueryResponse build() {
            return new PutStoredQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
