/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Name of the step from the SSM document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemediationExecutionStep implements SdkPojo, Serializable,
        ToCopyableBuilder<RemediationExecutionStep.Builder, RemediationExecutionStep> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RemediationExecutionStep::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(RemediationExecutionStep::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(RemediationExecutionStep::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(RemediationExecutionStep::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StopTime").getter(getter(RemediationExecutionStep::stopTime)).setter(setter(Builder::stopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATE_FIELD,
            ERROR_MESSAGE_FIELD, START_TIME_FIELD, STOP_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String state;

    private final String errorMessage;

    private final Instant startTime;

    private final Instant stopTime;

    private RemediationExecutionStep(BuilderImpl builder) {
        this.name = builder.name;
        this.state = builder.state;
        this.errorMessage = builder.errorMessage;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
    }

    /**
     * <p>
     * The details of the step.
     * </p>
     * 
     * @return The details of the step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The valid status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RemediationExecutionStepState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The valid status of the step.
     * @see RemediationExecutionStepState
     */
    public final RemediationExecutionStepState state() {
        return RemediationExecutionStepState.fromValue(state);
    }

    /**
     * <p>
     * The valid status of the step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RemediationExecutionStepState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The valid status of the step.
     * @see RemediationExecutionStepState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * An error message if the step was interrupted during execution.
     * </p>
     * 
     * @return An error message if the step was interrupted during execution.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The time when the step started.
     * </p>
     * 
     * @return The time when the step started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time when the step stopped.
     * </p>
     * 
     * @return The time when the step stopped.
     */
    public final Instant stopTime() {
        return stopTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stopTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemediationExecutionStep)) {
            return false;
        }
        RemediationExecutionStep other = (RemediationExecutionStep) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(stopTime(), other.stopTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemediationExecutionStep").add("Name", name()).add("State", stateAsString())
                .add("ErrorMessage", errorMessage()).add("StartTime", startTime()).add("StopTime", stopTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "StopTime":
            return Optional.ofNullable(clazz.cast(stopTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemediationExecutionStep, T> g) {
        return obj -> g.apply((RemediationExecutionStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemediationExecutionStep> {
        /**
         * <p>
         * The details of the step.
         * </p>
         * 
         * @param name
         *        The details of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The valid status of the step.
         * </p>
         * 
         * @param state
         *        The valid status of the step.
         * @see RemediationExecutionStepState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemediationExecutionStepState
         */
        Builder state(String state);

        /**
         * <p>
         * The valid status of the step.
         * </p>
         * 
         * @param state
         *        The valid status of the step.
         * @see RemediationExecutionStepState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemediationExecutionStepState
         */
        Builder state(RemediationExecutionStepState state);

        /**
         * <p>
         * An error message if the step was interrupted during execution.
         * </p>
         * 
         * @param errorMessage
         *        An error message if the step was interrupted during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The time when the step started.
         * </p>
         * 
         * @param startTime
         *        The time when the step started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time when the step stopped.
         * </p>
         * 
         * @param stopTime
         *        The time when the step stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTime(Instant stopTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String state;

        private String errorMessage;

        private Instant startTime;

        private Instant stopTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RemediationExecutionStep model) {
            name(model.name);
            state(model.state);
            errorMessage(model.errorMessage);
            startTime(model.startTime);
            stopTime(model.stopTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(RemediationExecutionStepState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        @Transient
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        @Override
        public RemediationExecutionStep build() {
            return new RemediationExecutionStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
