/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides status of the delivery of the snapshot or the configuration history to the specified Amazon S3 bucket. Also
 * provides the status of notifications about the Amazon S3 delivery to the specified Amazon SNS topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigExportDeliveryInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigExportDeliveryInfo.Builder, ConfigExportDeliveryInfo> {
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastStatus").getter(getter(ConfigExportDeliveryInfo::lastStatusAsString))
            .setter(setter(Builder::lastStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()).build();

    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastErrorCode").getter(getter(ConfigExportDeliveryInfo::lastErrorCode))
            .setter(setter(Builder::lastErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorCode").build()).build();

    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastErrorMessage").getter(getter(ConfigExportDeliveryInfo::lastErrorMessage))
            .setter(setter(Builder::lastErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorMessage").build()).build();

    private static final SdkField<Instant> LAST_ATTEMPT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastAttemptTime").getter(getter(ConfigExportDeliveryInfo::lastAttemptTime))
            .setter(setter(Builder::lastAttemptTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAttemptTime").build()).build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastSuccessfulTime").getter(getter(ConfigExportDeliveryInfo::lastSuccessfulTime))
            .setter(setter(Builder::lastSuccessfulTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulTime").build())
            .build();

    private static final SdkField<Instant> NEXT_DELIVERY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("nextDeliveryTime").getter(getter(ConfigExportDeliveryInfo::nextDeliveryTime))
            .setter(setter(Builder::nextDeliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextDeliveryTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_STATUS_FIELD,
            LAST_ERROR_CODE_FIELD, LAST_ERROR_MESSAGE_FIELD, LAST_ATTEMPT_TIME_FIELD, LAST_SUCCESSFUL_TIME_FIELD,
            NEXT_DELIVERY_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lastStatus;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private final Instant lastAttemptTime;

    private final Instant lastSuccessfulTime;

    private final Instant nextDeliveryTime;

    private ConfigExportDeliveryInfo(BuilderImpl builder) {
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastAttemptTime = builder.lastAttemptTime;
        this.lastSuccessfulTime = builder.lastSuccessfulTime;
        this.nextDeliveryTime = builder.nextDeliveryTime;
    }

    /**
     * <p>
     * Status of the last attempted delivery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link DeliveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusAsString}.
     * </p>
     * 
     * @return Status of the last attempted delivery.
     * @see DeliveryStatus
     */
    public final DeliveryStatus lastStatus() {
        return DeliveryStatus.fromValue(lastStatus);
    }

    /**
     * <p>
     * Status of the last attempted delivery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastStatus} will
     * return {@link DeliveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lastStatusAsString}.
     * </p>
     * 
     * @return Status of the last attempted delivery.
     * @see DeliveryStatus
     */
    public final String lastStatusAsString() {
        return lastStatus;
    }

    /**
     * <p>
     * The error code from the last attempted delivery.
     * </p>
     * 
     * @return The error code from the last attempted delivery.
     */
    public final String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The error message from the last attempted delivery.
     * </p>
     * 
     * @return The error message from the last attempted delivery.
     */
    public final String lastErrorMessage() {
        return lastErrorMessage;
    }

    /**
     * <p>
     * The time of the last attempted delivery.
     * </p>
     * 
     * @return The time of the last attempted delivery.
     */
    public final Instant lastAttemptTime() {
        return lastAttemptTime;
    }

    /**
     * <p>
     * The time of the last successful delivery.
     * </p>
     * 
     * @return The time of the last successful delivery.
     */
    public final Instant lastSuccessfulTime() {
        return lastSuccessfulTime;
    }

    /**
     * <p>
     * The time that the next delivery occurs.
     * </p>
     * 
     * @return The time that the next delivery occurs.
     */
    public final Instant nextDeliveryTime() {
        return nextDeliveryTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastAttemptTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextDeliveryTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigExportDeliveryInfo)) {
            return false;
        }
        ConfigExportDeliveryInfo other = (ConfigExportDeliveryInfo) obj;
        return Objects.equals(lastStatusAsString(), other.lastStatusAsString())
                && Objects.equals(lastErrorCode(), other.lastErrorCode())
                && Objects.equals(lastErrorMessage(), other.lastErrorMessage())
                && Objects.equals(lastAttemptTime(), other.lastAttemptTime())
                && Objects.equals(lastSuccessfulTime(), other.lastSuccessfulTime())
                && Objects.equals(nextDeliveryTime(), other.nextDeliveryTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigExportDeliveryInfo").add("LastStatus", lastStatusAsString())
                .add("LastErrorCode", lastErrorCode()).add("LastErrorMessage", lastErrorMessage())
                .add("LastAttemptTime", lastAttemptTime()).add("LastSuccessfulTime", lastSuccessfulTime())
                .add("NextDeliveryTime", nextDeliveryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastStatus":
            return Optional.ofNullable(clazz.cast(lastStatusAsString()));
        case "lastErrorCode":
            return Optional.ofNullable(clazz.cast(lastErrorCode()));
        case "lastErrorMessage":
            return Optional.ofNullable(clazz.cast(lastErrorMessage()));
        case "lastAttemptTime":
            return Optional.ofNullable(clazz.cast(lastAttemptTime()));
        case "lastSuccessfulTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulTime()));
        case "nextDeliveryTime":
            return Optional.ofNullable(clazz.cast(nextDeliveryTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigExportDeliveryInfo, T> g) {
        return obj -> g.apply((ConfigExportDeliveryInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigExportDeliveryInfo> {
        /**
         * <p>
         * Status of the last attempted delivery.
         * </p>
         * 
         * @param lastStatus
         *        Status of the last attempted delivery.
         * @see DeliveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStatus
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * Status of the last attempted delivery.
         * </p>
         * 
         * @param lastStatus
         *        Status of the last attempted delivery.
         * @see DeliveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStatus
         */
        Builder lastStatus(DeliveryStatus lastStatus);

        /**
         * <p>
         * The error code from the last attempted delivery.
         * </p>
         * 
         * @param lastErrorCode
         *        The error code from the last attempted delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The error message from the last attempted delivery.
         * </p>
         * 
         * @param lastErrorMessage
         *        The error message from the last attempted delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);

        /**
         * <p>
         * The time of the last attempted delivery.
         * </p>
         * 
         * @param lastAttemptTime
         *        The time of the last attempted delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptTime(Instant lastAttemptTime);

        /**
         * <p>
         * The time of the last successful delivery.
         * </p>
         * 
         * @param lastSuccessfulTime
         *        The time of the last successful delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulTime(Instant lastSuccessfulTime);

        /**
         * <p>
         * The time that the next delivery occurs.
         * </p>
         * 
         * @param nextDeliveryTime
         *        The time that the next delivery occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextDeliveryTime(Instant nextDeliveryTime);
    }

    static final class BuilderImpl implements Builder {
        private String lastStatus;

        private String lastErrorCode;

        private String lastErrorMessage;

        private Instant lastAttemptTime;

        private Instant lastSuccessfulTime;

        private Instant nextDeliveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigExportDeliveryInfo model) {
            lastStatus(model.lastStatus);
            lastErrorCode(model.lastErrorCode);
            lastErrorMessage(model.lastErrorMessage);
            lastAttemptTime(model.lastAttemptTime);
            lastSuccessfulTime(model.lastSuccessfulTime);
            nextDeliveryTime(model.nextDeliveryTime);
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        @Override
        @Transient
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder lastStatus(DeliveryStatus lastStatus) {
            this.lastStatus(lastStatus == null ? null : lastStatus.toString());
            return this;
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        @Override
        @Transient
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        @Override
        @Transient
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final Instant getLastAttemptTime() {
            return lastAttemptTime;
        }

        public final void setLastAttemptTime(Instant lastAttemptTime) {
            this.lastAttemptTime = lastAttemptTime;
        }

        @Override
        @Transient
        public final Builder lastAttemptTime(Instant lastAttemptTime) {
            this.lastAttemptTime = lastAttemptTime;
            return this;
        }

        public final Instant getLastSuccessfulTime() {
            return lastSuccessfulTime;
        }

        public final void setLastSuccessfulTime(Instant lastSuccessfulTime) {
            this.lastSuccessfulTime = lastSuccessfulTime;
        }

        @Override
        @Transient
        public final Builder lastSuccessfulTime(Instant lastSuccessfulTime) {
            this.lastSuccessfulTime = lastSuccessfulTime;
            return this;
        }

        public final Instant getNextDeliveryTime() {
            return nextDeliveryTime;
        }

        public final void setNextDeliveryTime(Instant nextDeliveryTime) {
            this.nextDeliveryTime = nextDeliveryTime;
        }

        @Override
        @Transient
        public final Builder nextDeliveryTime(Instant nextDeliveryTime) {
            this.nextDeliveryTime = nextDeliveryTime;
            return this;
        }

        @Override
        public ConfigExportDeliveryInfo build() {
            return new ConfigExportDeliveryInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
