/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStoredQueriesResponse extends ConfigResponse implements
        ToCopyableBuilder<ListStoredQueriesResponse.Builder, ListStoredQueriesResponse> {
    private static final SdkField<List<StoredQueryMetadata>> STORED_QUERY_METADATA_FIELD = SdkField
            .<List<StoredQueryMetadata>> builder(MarshallingType.LIST)
            .memberName("StoredQueryMetadata")
            .getter(getter(ListStoredQueriesResponse::storedQueryMetadata))
            .setter(setter(Builder::storedQueryMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoredQueryMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StoredQueryMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(StoredQueryMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStoredQueriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORED_QUERY_METADATA_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StoredQueryMetadata> storedQueryMetadata;

    private final String nextToken;

    private ListStoredQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.storedQueryMetadata = builder.storedQueryMetadata;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StoredQueryMetadata property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStoredQueryMetadata() {
        return storedQueryMetadata != null && !(storedQueryMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>StoredQueryMetadata</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStoredQueryMetadata} method.
     * </p>
     * 
     * @return A list of <code>StoredQueryMetadata</code> objects.
     */
    public final List<StoredQueryMetadata> storedQueryMetadata() {
        return storedQueryMetadata;
    }

    /**
     * <p>
     * If the previous paginated request didn't return all of the remaining results, the response object's
     * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action
     * again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining
     * results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.
     * </p>
     * 
     * @return If the previous paginated request didn't return all of the remaining results, the response object's
     *         <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this
     *         action again and assign that token to the request object's <code>NextToken</code> parameter. If there are
     *         no remaining results, the previous response object's <code>NextToken</code> parameter is set to
     *         <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStoredQueryMetadata() ? storedQueryMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStoredQueriesResponse)) {
            return false;
        }
        ListStoredQueriesResponse other = (ListStoredQueriesResponse) obj;
        return hasStoredQueryMetadata() == other.hasStoredQueryMetadata()
                && Objects.equals(storedQueryMetadata(), other.storedQueryMetadata())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStoredQueriesResponse")
                .add("StoredQueryMetadata", hasStoredQueryMetadata() ? storedQueryMetadata() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StoredQueryMetadata":
            return Optional.ofNullable(clazz.cast(storedQueryMetadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStoredQueriesResponse, T> g) {
        return obj -> g.apply((ListStoredQueriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStoredQueriesResponse> {
        /**
         * <p>
         * A list of <code>StoredQueryMetadata</code> objects.
         * </p>
         * 
         * @param storedQueryMetadata
         *        A list of <code>StoredQueryMetadata</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storedQueryMetadata(Collection<StoredQueryMetadata> storedQueryMetadata);

        /**
         * <p>
         * A list of <code>StoredQueryMetadata</code> objects.
         * </p>
         * 
         * @param storedQueryMetadata
         *        A list of <code>StoredQueryMetadata</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storedQueryMetadata(StoredQueryMetadata... storedQueryMetadata);

        /**
         * <p>
         * A list of <code>StoredQueryMetadata</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StoredQueryMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<StoredQueryMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StoredQueryMetadata>.Builder#build()} is called immediately
         * and its result is passed to {@link #storedQueryMetadata(List<StoredQueryMetadata>)}.
         * 
         * @param storedQueryMetadata
         *        a consumer that will call methods on {@link List<StoredQueryMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storedQueryMetadata(List<StoredQueryMetadata>)
         */
        Builder storedQueryMetadata(Consumer<StoredQueryMetadata.Builder>... storedQueryMetadata);

        /**
         * <p>
         * If the previous paginated request didn't return all of the remaining results, the response object's
         * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this
         * action again and assign that token to the request object's <code>NextToken</code> parameter. If there are no
         * remaining results, the previous response object's <code>NextToken</code> parameter is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request didn't return all of the remaining results, the response object's
         *        <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        this action again and assign that token to the request object's <code>NextToken</code> parameter. If
         *        there are no remaining results, the previous response object's <code>NextToken</code> parameter is set
         *        to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<StoredQueryMetadata> storedQueryMetadata = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStoredQueriesResponse model) {
            super(model);
            storedQueryMetadata(model.storedQueryMetadata);
            nextToken(model.nextToken);
        }

        public final List<StoredQueryMetadata.Builder> getStoredQueryMetadata() {
            List<StoredQueryMetadata.Builder> result = StoredQueryMetadataListCopier.copyToBuilder(this.storedQueryMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStoredQueryMetadata(Collection<StoredQueryMetadata.BuilderImpl> storedQueryMetadata) {
            this.storedQueryMetadata = StoredQueryMetadataListCopier.copyFromBuilder(storedQueryMetadata);
        }

        @Override
        @Transient
        public final Builder storedQueryMetadata(Collection<StoredQueryMetadata> storedQueryMetadata) {
            this.storedQueryMetadata = StoredQueryMetadataListCopier.copy(storedQueryMetadata);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder storedQueryMetadata(StoredQueryMetadata... storedQueryMetadata) {
            storedQueryMetadata(Arrays.asList(storedQueryMetadata));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder storedQueryMetadata(Consumer<StoredQueryMetadata.Builder>... storedQueryMetadata) {
            storedQueryMetadata(Stream.of(storedQueryMetadata).map(c -> StoredQueryMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStoredQueriesResponse build() {
            return new ListStoredQueriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
