/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters the conformance packs based on an account ID, region, compliance type, and the name of the conformance pack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateConformancePackComplianceFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateConformancePackComplianceFilters.Builder, AggregateConformancePackComplianceFilters> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackName").getter(getter(AggregateConformancePackComplianceFilters::conformancePackName))
            .setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(AggregateConformancePackComplianceFilters::complianceTypeAsString))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AggregateConformancePackComplianceFilters::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion").getter(getter(AggregateConformancePackComplianceFilters::awsRegion))
            .setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD,
            COMPLIANCE_TYPE_FIELD, ACCOUNT_ID_FIELD, AWS_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String conformancePackName;

    private final String complianceType;

    private final String accountId;

    private final String awsRegion;

    private AggregateConformancePackComplianceFilters(BuilderImpl builder) {
        this.conformancePackName = builder.conformancePackName;
        this.complianceType = builder.complianceType;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    /**
     * <p>
     * The name of the conformance pack.
     * </p>
     * 
     * @return The name of the conformance pack.
     */
    public final String conformancePackName() {
        return conformancePackName;
    }

    /**
     * <p>
     * The compliance status of the conformance pack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The compliance status of the conformance pack.
     * @see ConformancePackComplianceType
     */
    public final ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * The compliance status of the conformance pack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ConformancePackComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return The compliance status of the conformance pack.
     * @see ConformancePackComplianceType
     */
    public final String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * <p>
     * The 12-digit Amazon Web Services account ID of the source account.
     * </p>
     * 
     * @return The 12-digit Amazon Web Services account ID of the source account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The source Amazon Web Services Region from where the data is aggregated.
     * </p>
     * 
     * @return The source Amazon Web Services Region from where the data is aggregated.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateConformancePackComplianceFilters)) {
            return false;
        }
        AggregateConformancePackComplianceFilters other = (AggregateConformancePackComplianceFilters) obj;
        return Objects.equals(conformancePackName(), other.conformancePackName())
                && Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(awsRegion(), other.awsRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateConformancePackComplianceFilters").add("ConformancePackName", conformancePackName())
                .add("ComplianceType", complianceTypeAsString()).add("AccountId", accountId()).add("AwsRegion", awsRegion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateConformancePackComplianceFilters, T> g) {
        return obj -> g.apply((AggregateConformancePackComplianceFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateConformancePackComplianceFilters> {
        /**
         * <p>
         * The name of the conformance pack.
         * </p>
         * 
         * @param conformancePackName
         *        The name of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * The compliance status of the conformance pack.
         * </p>
         * 
         * @param complianceType
         *        The compliance status of the conformance pack.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * The compliance status of the conformance pack.
         * </p>
         * 
         * @param complianceType
         *        The compliance status of the conformance pack.
         * @see ConformancePackComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConformancePackComplianceType
         */
        Builder complianceType(ConformancePackComplianceType complianceType);

        /**
         * <p>
         * The 12-digit Amazon Web Services account ID of the source account.
         * </p>
         * 
         * @param accountId
         *        The 12-digit Amazon Web Services account ID of the source account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The source Amazon Web Services Region from where the data is aggregated.
         * </p>
         * 
         * @param awsRegion
         *        The source Amazon Web Services Region from where the data is aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);
    }

    static final class BuilderImpl implements Builder {
        private String conformancePackName;

        private String complianceType;

        private String accountId;

        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateConformancePackComplianceFilters model) {
            conformancePackName(model.conformancePackName);
            complianceType(model.complianceType);
            accountId(model.accountId);
            awsRegion(model.awsRegion);
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        @Override
        @Transient
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        @Transient
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        @Transient
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        @Transient
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        @Override
        public AggregateConformancePackComplianceFilters build() {
            return new AggregateConformancePackComplianceFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
