/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the account ID and region of an aggregator account that is requesting authorization but is
 * not yet authorized.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingAggregationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingAggregationRequest.Builder, PendingAggregationRequest> {
    private static final SdkField<String> REQUESTER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterAccountId").getter(getter(PendingAggregationRequest::requesterAccountId))
            .setter(setter(Builder::requesterAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAccountId").build())
            .build();

    private static final SdkField<String> REQUESTER_AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterAwsRegion").getter(getter(PendingAggregationRequest::requesterAwsRegion))
            .setter(setter(Builder::requesterAwsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAwsRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUESTER_ACCOUNT_ID_FIELD,
            REQUESTER_AWS_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String requesterAccountId;

    private final String requesterAwsRegion;

    private PendingAggregationRequest(BuilderImpl builder) {
        this.requesterAccountId = builder.requesterAccountId;
        this.requesterAwsRegion = builder.requesterAwsRegion;
    }

    /**
     * <p>
     * The 12-digit account ID of the account requesting to aggregate data.
     * </p>
     * 
     * @return The 12-digit account ID of the account requesting to aggregate data.
     */
    public final String requesterAccountId() {
        return requesterAccountId;
    }

    /**
     * <p>
     * The region requesting to aggregate data.
     * </p>
     * 
     * @return The region requesting to aggregate data.
     */
    public final String requesterAwsRegion() {
        return requesterAwsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterAwsRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingAggregationRequest)) {
            return false;
        }
        PendingAggregationRequest other = (PendingAggregationRequest) obj;
        return Objects.equals(requesterAccountId(), other.requesterAccountId())
                && Objects.equals(requesterAwsRegion(), other.requesterAwsRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingAggregationRequest").add("RequesterAccountId", requesterAccountId())
                .add("RequesterAwsRegion", requesterAwsRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequesterAccountId":
            return Optional.ofNullable(clazz.cast(requesterAccountId()));
        case "RequesterAwsRegion":
            return Optional.ofNullable(clazz.cast(requesterAwsRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingAggregationRequest, T> g) {
        return obj -> g.apply((PendingAggregationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingAggregationRequest> {
        /**
         * <p>
         * The 12-digit account ID of the account requesting to aggregate data.
         * </p>
         * 
         * @param requesterAccountId
         *        The 12-digit account ID of the account requesting to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterAccountId(String requesterAccountId);

        /**
         * <p>
         * The region requesting to aggregate data.
         * </p>
         * 
         * @param requesterAwsRegion
         *        The region requesting to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterAwsRegion(String requesterAwsRegion);
    }

    static final class BuilderImpl implements Builder {
        private String requesterAccountId;

        private String requesterAwsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingAggregationRequest model) {
            requesterAccountId(model.requesterAccountId);
            requesterAwsRegion(model.requesterAwsRegion);
        }

        public final String getRequesterAccountId() {
            return requesterAccountId;
        }

        public final void setRequesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
        }

        @Override
        @Transient
        public final Builder requesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
            return this;
        }

        public final String getRequesterAwsRegion() {
            return requesterAwsRegion;
        }

        public final void setRequesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
        }

        @Override
        @Transient
        public final Builder requesterAwsRegion(String requesterAwsRegion) {
            this.requesterAwsRegion = requesterAwsRegion;
            return this;
        }

        @Override
        public PendingAggregationRequest build() {
            return new PendingAggregationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
