/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.EvaluationResult;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;

public class GetComplianceDetailsByConfigRuleIterable
implements SdkIterable<GetComplianceDetailsByConfigRuleResponse> {
    private final ConfigClient client;
    private final GetComplianceDetailsByConfigRuleRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetComplianceDetailsByConfigRuleIterable(ConfigClient client, GetComplianceDetailsByConfigRuleRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetComplianceDetailsByConfigRuleResponseFetcher();
    }

    public Iterator<GetComplianceDetailsByConfigRuleResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EvaluationResult> evaluationResults() {
        Function<GetComplianceDetailsByConfigRuleResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationResults() != null) {
                return response.evaluationResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetComplianceDetailsByConfigRuleResponseFetcher
    implements SyncPageFetcher<GetComplianceDetailsByConfigRuleResponse> {
        private GetComplianceDetailsByConfigRuleResponseFetcher() {
        }

        public boolean hasNextPage(GetComplianceDetailsByConfigRuleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetComplianceDetailsByConfigRuleResponse nextPage(GetComplianceDetailsByConfigRuleResponse previousPage) {
            if (previousPage == null) {
                return GetComplianceDetailsByConfigRuleIterable.this.client.getComplianceDetailsByConfigRule(GetComplianceDetailsByConfigRuleIterable.this.firstRequest);
            }
            return GetComplianceDetailsByConfigRuleIterable.this.client.getComplianceDetailsByConfigRule((GetComplianceDetailsByConfigRuleRequest)((Object)GetComplianceDetailsByConfigRuleIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

