/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRemediationConfigurationsResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeRemediationConfigurationsResponse.Builder, DescribeRemediationConfigurationsResponse> {
    private static final SdkField<List<RemediationConfiguration>> REMEDIATION_CONFIGURATIONS_FIELD = SdkField
            .<List<RemediationConfiguration>> builder(MarshallingType.LIST)
            .memberName("RemediationConfigurations")
            .getter(getter(DescribeRemediationConfigurationsResponse::remediationConfigurations))
            .setter(setter(Builder::remediationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemediationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REMEDIATION_CONFIGURATIONS_FIELD));

    private final List<RemediationConfiguration> remediationConfigurations;

    private DescribeRemediationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.remediationConfigurations = builder.remediationConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemediationConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemediationConfigurations() {
        return remediationConfigurations != null && !(remediationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a remediation configuration object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemediationConfigurations} method.
     * </p>
     * 
     * @return Returns a remediation configuration object.
     */
    public final List<RemediationConfiguration> remediationConfigurations() {
        return remediationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRemediationConfigurations() ? remediationConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRemediationConfigurationsResponse)) {
            return false;
        }
        DescribeRemediationConfigurationsResponse other = (DescribeRemediationConfigurationsResponse) obj;
        return hasRemediationConfigurations() == other.hasRemediationConfigurations()
                && Objects.equals(remediationConfigurations(), other.remediationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRemediationConfigurationsResponse")
                .add("RemediationConfigurations", hasRemediationConfigurations() ? remediationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RemediationConfigurations":
            return Optional.ofNullable(clazz.cast(remediationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRemediationConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeRemediationConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRemediationConfigurationsResponse> {
        /**
         * <p>
         * Returns a remediation configuration object.
         * </p>
         * 
         * @param remediationConfigurations
         *        Returns a remediation configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationConfigurations(Collection<RemediationConfiguration> remediationConfigurations);

        /**
         * <p>
         * Returns a remediation configuration object.
         * </p>
         * 
         * @param remediationConfigurations
         *        Returns a remediation configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationConfigurations(RemediationConfiguration... remediationConfigurations);

        /**
         * <p>
         * Returns a remediation configuration object.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RemediationConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<RemediationConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemediationConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #remediationConfigurations(List<RemediationConfiguration>)}.
         * 
         * @param remediationConfigurations
         *        a consumer that will call methods on {@link List<RemediationConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediationConfigurations(List<RemediationConfiguration>)
         */
        Builder remediationConfigurations(Consumer<RemediationConfiguration.Builder>... remediationConfigurations);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<RemediationConfiguration> remediationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRemediationConfigurationsResponse model) {
            super(model);
            remediationConfigurations(model.remediationConfigurations);
        }

        public final List<RemediationConfiguration.Builder> getRemediationConfigurations() {
            List<RemediationConfiguration.Builder> result = RemediationConfigurationsCopier
                    .copyToBuilder(this.remediationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemediationConfigurations(Collection<RemediationConfiguration.BuilderImpl> remediationConfigurations) {
            this.remediationConfigurations = RemediationConfigurationsCopier.copyFromBuilder(remediationConfigurations);
        }

        @Override
        @Transient
        public final Builder remediationConfigurations(Collection<RemediationConfiguration> remediationConfigurations) {
            this.remediationConfigurations = RemediationConfigurationsCopier.copy(remediationConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder remediationConfigurations(RemediationConfiguration... remediationConfigurations) {
            remediationConfigurations(Arrays.asList(remediationConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder remediationConfigurations(Consumer<RemediationConfiguration.Builder>... remediationConfigurations) {
            remediationConfigurations(Stream.of(remediationConfigurations)
                    .map(c -> RemediationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeRemediationConfigurationsResponse build() {
            return new DescribeRemediationConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
