/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ResourceType {
    AWS_EC2_CUSTOMER_GATEWAY("AWS::EC2::CustomerGateway"),

    AWS_EC2_EIP("AWS::EC2::EIP"),

    AWS_EC2_HOST("AWS::EC2::Host"),

    AWS_EC2_INSTANCE("AWS::EC2::Instance"),

    AWS_EC2_INTERNET_GATEWAY("AWS::EC2::InternetGateway"),

    AWS_EC2_NETWORK_ACL("AWS::EC2::NetworkAcl"),

    AWS_EC2_NETWORK_INTERFACE("AWS::EC2::NetworkInterface"),

    AWS_EC2_ROUTE_TABLE("AWS::EC2::RouteTable"),

    AWS_EC2_SECURITY_GROUP("AWS::EC2::SecurityGroup"),

    AWS_EC2_SUBNET("AWS::EC2::Subnet"),

    AWS_CLOUD_TRAIL_TRAIL("AWS::CloudTrail::Trail"),

    AWS_EC2_VOLUME("AWS::EC2::Volume"),

    AWS_EC2_VPC("AWS::EC2::VPC"),

    AWS_EC2_VPN_CONNECTION("AWS::EC2::VPNConnection"),

    AWS_EC2_VPN_GATEWAY("AWS::EC2::VPNGateway"),

    AWS_EC2_REGISTERED_HA_INSTANCE("AWS::EC2::RegisteredHAInstance"),

    AWS_EC2_NAT_GATEWAY("AWS::EC2::NatGateway"),

    AWS_EC2_EGRESS_ONLY_INTERNET_GATEWAY("AWS::EC2::EgressOnlyInternetGateway"),

    AWS_EC2_VPC_ENDPOINT("AWS::EC2::VPCEndpoint"),

    AWS_EC2_VPC_ENDPOINT_SERVICE("AWS::EC2::VPCEndpointService"),

    AWS_EC2_FLOW_LOG("AWS::EC2::FlowLog"),

    AWS_EC2_VPC_PEERING_CONNECTION("AWS::EC2::VPCPeeringConnection"),

    AWS_ELASTICSEARCH_DOMAIN("AWS::Elasticsearch::Domain"),

    AWS_IAM_GROUP("AWS::IAM::Group"),

    AWS_IAM_POLICY("AWS::IAM::Policy"),

    AWS_IAM_ROLE("AWS::IAM::Role"),

    AWS_IAM_USER("AWS::IAM::User"),

    AWS_ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER("AWS::ElasticLoadBalancingV2::LoadBalancer"),

    AWS_ACM_CERTIFICATE("AWS::ACM::Certificate"),

    AWS_RDS_DB_INSTANCE("AWS::RDS::DBInstance"),

    AWS_RDS_DB_SUBNET_GROUP("AWS::RDS::DBSubnetGroup"),

    AWS_RDS_DB_SECURITY_GROUP("AWS::RDS::DBSecurityGroup"),

    AWS_RDS_DB_SNAPSHOT("AWS::RDS::DBSnapshot"),

    AWS_RDS_DB_CLUSTER("AWS::RDS::DBCluster"),

    AWS_RDS_DB_CLUSTER_SNAPSHOT("AWS::RDS::DBClusterSnapshot"),

    AWS_RDS_EVENT_SUBSCRIPTION("AWS::RDS::EventSubscription"),

    AWS_S3_BUCKET("AWS::S3::Bucket"),

    AWS_S3_ACCOUNT_PUBLIC_ACCESS_BLOCK("AWS::S3::AccountPublicAccessBlock"),

    AWS_REDSHIFT_CLUSTER("AWS::Redshift::Cluster"),

    AWS_REDSHIFT_CLUSTER_SNAPSHOT("AWS::Redshift::ClusterSnapshot"),

    AWS_REDSHIFT_CLUSTER_PARAMETER_GROUP("AWS::Redshift::ClusterParameterGroup"),

    AWS_REDSHIFT_CLUSTER_SECURITY_GROUP("AWS::Redshift::ClusterSecurityGroup"),

    AWS_REDSHIFT_CLUSTER_SUBNET_GROUP("AWS::Redshift::ClusterSubnetGroup"),

    AWS_REDSHIFT_EVENT_SUBSCRIPTION("AWS::Redshift::EventSubscription"),

    AWS_SSM_MANAGED_INSTANCE_INVENTORY("AWS::SSM::ManagedInstanceInventory"),

    AWS_CLOUD_WATCH_ALARM("AWS::CloudWatch::Alarm"),

    AWS_CLOUD_FORMATION_STACK("AWS::CloudFormation::Stack"),

    AWS_ELASTIC_LOAD_BALANCING_LOAD_BALANCER("AWS::ElasticLoadBalancing::LoadBalancer"),

    AWS_AUTO_SCALING_AUTO_SCALING_GROUP("AWS::AutoScaling::AutoScalingGroup"),

    AWS_AUTO_SCALING_LAUNCH_CONFIGURATION("AWS::AutoScaling::LaunchConfiguration"),

    AWS_AUTO_SCALING_SCALING_POLICY("AWS::AutoScaling::ScalingPolicy"),

    AWS_AUTO_SCALING_SCHEDULED_ACTION("AWS::AutoScaling::ScheduledAction"),

    AWS_DYNAMO_DB_TABLE("AWS::DynamoDB::Table"),

    AWS_CODE_BUILD_PROJECT("AWS::CodeBuild::Project"),

    AWS_WAF_RATE_BASED_RULE("AWS::WAF::RateBasedRule"),

    AWS_WAF_RULE("AWS::WAF::Rule"),

    AWS_WAF_RULE_GROUP("AWS::WAF::RuleGroup"),

    AWS_WAF_WEB_ACL("AWS::WAF::WebACL"),

    AWS_WAF_REGIONAL_RATE_BASED_RULE("AWS::WAFRegional::RateBasedRule"),

    AWS_WAF_REGIONAL_RULE("AWS::WAFRegional::Rule"),

    AWS_WAF_REGIONAL_RULE_GROUP("AWS::WAFRegional::RuleGroup"),

    AWS_WAF_REGIONAL_WEB_ACL("AWS::WAFRegional::WebACL"),

    AWS_CLOUD_FRONT_DISTRIBUTION("AWS::CloudFront::Distribution"),

    AWS_CLOUD_FRONT_STREAMING_DISTRIBUTION("AWS::CloudFront::StreamingDistribution"),

    AWS_LAMBDA_FUNCTION("AWS::Lambda::Function"),

    AWS_NETWORK_FIREWALL_FIREWALL("AWS::NetworkFirewall::Firewall"),

    AWS_NETWORK_FIREWALL_FIREWALL_POLICY("AWS::NetworkFirewall::FirewallPolicy"),

    AWS_NETWORK_FIREWALL_RULE_GROUP("AWS::NetworkFirewall::RuleGroup"),

    AWS_ELASTIC_BEANSTALK_APPLICATION("AWS::ElasticBeanstalk::Application"),

    AWS_ELASTIC_BEANSTALK_APPLICATION_VERSION("AWS::ElasticBeanstalk::ApplicationVersion"),

    AWS_ELASTIC_BEANSTALK_ENVIRONMENT("AWS::ElasticBeanstalk::Environment"),

    AWS_WAF_V2_WEB_ACL("AWS::WAFv2::WebACL"),

    AWS_WAF_V2_RULE_GROUP("AWS::WAFv2::RuleGroup"),

    AWS_WAF_V2_IP_SET("AWS::WAFv2::IPSet"),

    AWS_WAF_V2_REGEX_PATTERN_SET("AWS::WAFv2::RegexPatternSet"),

    AWS_WAF_V2_MANAGED_RULE_SET("AWS::WAFv2::ManagedRuleSet"),

    AWS_X_RAY_ENCRYPTION_CONFIG("AWS::XRay::EncryptionConfig"),

    AWS_SSM_ASSOCIATION_COMPLIANCE("AWS::SSM::AssociationCompliance"),

    AWS_SSM_PATCH_COMPLIANCE("AWS::SSM::PatchCompliance"),

    AWS_SHIELD_PROTECTION("AWS::Shield::Protection"),

    AWS_SHIELD_REGIONAL_PROTECTION("AWS::ShieldRegional::Protection"),

    AWS_CONFIG_CONFORMANCE_PACK_COMPLIANCE("AWS::Config::ConformancePackCompliance"),

    AWS_CONFIG_RESOURCE_COMPLIANCE("AWS::Config::ResourceCompliance"),

    AWS_API_GATEWAY_STAGE("AWS::ApiGateway::Stage"),

    AWS_API_GATEWAY_REST_API("AWS::ApiGateway::RestApi"),

    AWS_API_GATEWAY_V2_STAGE("AWS::ApiGatewayV2::Stage"),

    AWS_API_GATEWAY_V2_API("AWS::ApiGatewayV2::Api"),

    AWS_CODE_PIPELINE_PIPELINE("AWS::CodePipeline::Pipeline"),

    AWS_SERVICE_CATALOG_CLOUD_FORMATION_PROVISIONED_PRODUCT("AWS::ServiceCatalog::CloudFormationProvisionedProduct"),

    AWS_SERVICE_CATALOG_CLOUD_FORMATION_PRODUCT("AWS::ServiceCatalog::CloudFormationProduct"),

    AWS_SERVICE_CATALOG_PORTFOLIO("AWS::ServiceCatalog::Portfolio"),

    AWS_SQS_QUEUE("AWS::SQS::Queue"),

    AWS_KMS_KEY("AWS::KMS::Key"),

    AWS_QLDB_LEDGER("AWS::QLDB::Ledger"),

    AWS_SECRETS_MANAGER_SECRET("AWS::SecretsManager::Secret"),

    AWS_SNS_TOPIC("AWS::SNS::Topic"),

    AWS_SSM_FILE_DATA("AWS::SSM::FileData"),

    AWS_BACKUP_BACKUP_PLAN("AWS::Backup::BackupPlan"),

    AWS_BACKUP_BACKUP_SELECTION("AWS::Backup::BackupSelection"),

    AWS_BACKUP_BACKUP_VAULT("AWS::Backup::BackupVault"),

    AWS_BACKUP_RECOVERY_POINT("AWS::Backup::RecoveryPoint"),

    AWS_ECR_REPOSITORY("AWS::ECR::Repository"),

    AWS_ECS_CLUSTER("AWS::ECS::Cluster"),

    AWS_ECS_SERVICE("AWS::ECS::Service"),

    AWS_ECS_TASK_DEFINITION("AWS::ECS::TaskDefinition"),

    AWS_EFS_ACCESS_POINT("AWS::EFS::AccessPoint"),

    AWS_EFS_FILE_SYSTEM("AWS::EFS::FileSystem"),

    AWS_EKS_CLUSTER("AWS::EKS::Cluster"),

    AWS_OPEN_SEARCH_DOMAIN("AWS::OpenSearch::Domain"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceType> VALUE_MAP = EnumUtils.uniqueIndex(ResourceType.class, ResourceType::toString);

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ResourceType corresponding to the value
     */
    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ResourceType}s
     */
    public static Set<ResourceType> knownValues() {
        Set<ResourceType> knownValues = EnumSet.allOf(ResourceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
