/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.MaximumExecutionFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigSnapshotDeliveryProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigSnapshotDeliveryProperties> {
    private static final SdkField<String> DELIVERY_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliveryFrequency").getter(ConfigSnapshotDeliveryProperties.getter(ConfigSnapshotDeliveryProperties::deliveryFrequencyAsString)).setter(ConfigSnapshotDeliveryProperties.setter(Builder::deliveryFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryFrequency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_FREQUENCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deliveryFrequency;

    private ConfigSnapshotDeliveryProperties(BuilderImpl builder) {
        this.deliveryFrequency = builder.deliveryFrequency;
    }

    public final MaximumExecutionFrequency deliveryFrequency() {
        return MaximumExecutionFrequency.fromValue(this.deliveryFrequency);
    }

    public final String deliveryFrequencyAsString() {
        return this.deliveryFrequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryFrequencyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigSnapshotDeliveryProperties)) {
            return false;
        }
        ConfigSnapshotDeliveryProperties other = (ConfigSnapshotDeliveryProperties)obj;
        return Objects.equals(this.deliveryFrequencyAsString(), other.deliveryFrequencyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigSnapshotDeliveryProperties").add("DeliveryFrequency", (Object)this.deliveryFrequencyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliveryFrequency": {
                return Optional.ofNullable(clazz.cast(this.deliveryFrequencyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigSnapshotDeliveryProperties, T> g) {
        return obj -> g.apply((ConfigSnapshotDeliveryProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigSnapshotDeliveryProperties model) {
            this.deliveryFrequency(model.deliveryFrequency);
        }

        public final String getDeliveryFrequency() {
            return this.deliveryFrequency;
        }

        public final void setDeliveryFrequency(String deliveryFrequency) {
            this.deliveryFrequency = deliveryFrequency;
        }

        @Override
        @Transient
        public final Builder deliveryFrequency(String deliveryFrequency) {
            this.deliveryFrequency = deliveryFrequency;
            return this;
        }

        @Override
        @Transient
        public final Builder deliveryFrequency(MaximumExecutionFrequency deliveryFrequency) {
            this.deliveryFrequency(deliveryFrequency == null ? null : deliveryFrequency.toString());
            return this;
        }

        public ConfigSnapshotDeliveryProperties build() {
            return new ConfigSnapshotDeliveryProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigSnapshotDeliveryProperties> {
        public Builder deliveryFrequency(String var1);

        public Builder deliveryFrequency(MaximumExecutionFrequency var1);
    }
}

