/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutExternalEvaluationRequest extends ConfigRequest implements
        ToCopyableBuilder<PutExternalEvaluationRequest.Builder, PutExternalEvaluationRequest> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleName").getter(getter(PutExternalEvaluationRequest::configRuleName))
            .setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<ExternalEvaluation> EXTERNAL_EVALUATION_FIELD = SdkField
            .<ExternalEvaluation> builder(MarshallingType.SDK_POJO).memberName("ExternalEvaluation")
            .getter(getter(PutExternalEvaluationRequest::externalEvaluation)).setter(setter(Builder::externalEvaluation))
            .constructor(ExternalEvaluation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalEvaluation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            EXTERNAL_EVALUATION_FIELD));

    private final String configRuleName;

    private final ExternalEvaluation externalEvaluation;

    private PutExternalEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.configRuleName = builder.configRuleName;
        this.externalEvaluation = builder.externalEvaluation;
    }

    /**
     * <p>
     * The name of the Config rule.
     * </p>
     * 
     * @return The name of the Config rule.
     */
    public final String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * An <code>ExternalEvaluation</code> object that provides details about compliance.
     * </p>
     * 
     * @return An <code>ExternalEvaluation</code> object that provides details about compliance.
     */
    public final ExternalEvaluation externalEvaluation() {
        return externalEvaluation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(externalEvaluation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutExternalEvaluationRequest)) {
            return false;
        }
        PutExternalEvaluationRequest other = (PutExternalEvaluationRequest) obj;
        return Objects.equals(configRuleName(), other.configRuleName())
                && Objects.equals(externalEvaluation(), other.externalEvaluation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutExternalEvaluationRequest").add("ConfigRuleName", configRuleName())
                .add("ExternalEvaluation", externalEvaluation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ExternalEvaluation":
            return Optional.ofNullable(clazz.cast(externalEvaluation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutExternalEvaluationRequest, T> g) {
        return obj -> g.apply((PutExternalEvaluationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutExternalEvaluationRequest> {
        /**
         * <p>
         * The name of the Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * An <code>ExternalEvaluation</code> object that provides details about compliance.
         * </p>
         * 
         * @param externalEvaluation
         *        An <code>ExternalEvaluation</code> object that provides details about compliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalEvaluation(ExternalEvaluation externalEvaluation);

        /**
         * <p>
         * An <code>ExternalEvaluation</code> object that provides details about compliance.
         * </p>
         * This is a convenience that creates an instance of the {@link ExternalEvaluation.Builder} avoiding the need to
         * create one manually via {@link ExternalEvaluation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExternalEvaluation.Builder#build()} is called immediately and its
         * result is passed to {@link #externalEvaluation(ExternalEvaluation)}.
         * 
         * @param externalEvaluation
         *        a consumer that will call methods on {@link ExternalEvaluation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalEvaluation(ExternalEvaluation)
         */
        default Builder externalEvaluation(Consumer<ExternalEvaluation.Builder> externalEvaluation) {
            return externalEvaluation(ExternalEvaluation.builder().applyMutation(externalEvaluation).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configRuleName;

        private ExternalEvaluation externalEvaluation;

        private BuilderImpl() {
        }

        private BuilderImpl(PutExternalEvaluationRequest model) {
            super(model);
            configRuleName(model.configRuleName);
            externalEvaluation(model.externalEvaluation);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        @Transient
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final ExternalEvaluation.Builder getExternalEvaluation() {
            return externalEvaluation != null ? externalEvaluation.toBuilder() : null;
        }

        public final void setExternalEvaluation(ExternalEvaluation.BuilderImpl externalEvaluation) {
            this.externalEvaluation = externalEvaluation != null ? externalEvaluation.build() : null;
        }

        @Override
        @Transient
        public final Builder externalEvaluation(ExternalEvaluation externalEvaluation) {
            this.externalEvaluation = externalEvaluation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutExternalEvaluationRequest build() {
            return new PutExternalEvaluationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
