/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceValueType {
    RESOURCE_ID("RESOURCE_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceValueType> VALUE_MAP;
    private final String value;

    private ResourceValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceValueType> knownValues() {
        EnumSet<ResourceValueType> knownValues = EnumSet.allOf(ResourceValueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceValueType.class, ResourceValueType::toString);
    }
}

