/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartResourceEvaluationRequest extends ConfigRequest implements
        ToCopyableBuilder<StartResourceEvaluationRequest.Builder, StartResourceEvaluationRequest> {
    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField
            .<ResourceDetails> builder(MarshallingType.SDK_POJO).memberName("ResourceDetails")
            .getter(getter(StartResourceEvaluationRequest::resourceDetails)).setter(setter(Builder::resourceDetails))
            .constructor(ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()).build();

    private static final SdkField<EvaluationContext> EVALUATION_CONTEXT_FIELD = SdkField
            .<EvaluationContext> builder(MarshallingType.SDK_POJO).memberName("EvaluationContext")
            .getter(getter(StartResourceEvaluationRequest::evaluationContext)).setter(setter(Builder::evaluationContext))
            .constructor(EvaluationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContext").build()).build();

    private static final SdkField<String> EVALUATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationMode").getter(getter(StartResourceEvaluationRequest::evaluationModeAsString))
            .setter(setter(Builder::evaluationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMode").build()).build();

    private static final SdkField<Integer> EVALUATION_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationTimeout").getter(getter(StartResourceEvaluationRequest::evaluationTimeout))
            .setter(setter(Builder::evaluationTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationTimeout").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(StartResourceEvaluationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_DETAILS_FIELD,
            EVALUATION_CONTEXT_FIELD, EVALUATION_MODE_FIELD, EVALUATION_TIMEOUT_FIELD, CLIENT_TOKEN_FIELD));

    private final ResourceDetails resourceDetails;

    private final EvaluationContext evaluationContext;

    private final String evaluationMode;

    private final Integer evaluationTimeout;

    private final String clientToken;

    private StartResourceEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceDetails = builder.resourceDetails;
        this.evaluationContext = builder.evaluationContext;
        this.evaluationMode = builder.evaluationMode;
        this.evaluationTimeout = builder.evaluationTimeout;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Returns a <code>ResourceDetails</code> object.
     * </p>
     * 
     * @return Returns a <code>ResourceDetails</code> object.
     */
    public final ResourceDetails resourceDetails() {
        return resourceDetails;
    }

    /**
     * <p>
     * Returns an <code>EvaluationContext</code> object.
     * </p>
     * 
     * @return Returns an <code>EvaluationContext</code> object.
     */
    public final EvaluationContext evaluationContext() {
        return evaluationContext;
    }

    /**
     * <p>
     * The mode of an evaluation. The valid value for this API is <code>Proactive</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMode}
     * will return {@link EvaluationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationModeAsString}.
     * </p>
     * 
     * @return The mode of an evaluation. The valid value for this API is <code>Proactive</code>.
     * @see EvaluationMode
     */
    public final EvaluationMode evaluationMode() {
        return EvaluationMode.fromValue(evaluationMode);
    }

    /**
     * <p>
     * The mode of an evaluation. The valid value for this API is <code>Proactive</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMode}
     * will return {@link EvaluationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationModeAsString}.
     * </p>
     * 
     * @return The mode of an evaluation. The valid value for this API is <code>Proactive</code>.
     * @see EvaluationMode
     */
    public final String evaluationModeAsString() {
        return evaluationMode;
    }

    /**
     * <p>
     * The timeout for an evaluation. The default is 900 seconds. You cannot specify a number greater than 3600. If you
     * specify 0, Config uses the default.
     * </p>
     * 
     * @return The timeout for an evaluation. The default is 900 seconds. You cannot specify a number greater than 3600.
     *         If you specify 0, Config uses the default.
     */
    public final Integer evaluationTimeout() {
        return evaluationTimeout;
    }

    /**
     * <p>
     * A client token is a unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request
     * using one of these actions, specify a client token in the request.
     * </p>
     * <note>
     * <p>
     * Avoid reusing the same client token for other API requests. If you retry a request that completed successfully
     * using the same client token and the same parameters, the retry succeeds without performing any further actions.
     * If you retry a successful request using the same client token, but one or more of the parameters are different,
     * other than the Region or Availability Zone, the retry fails with an IdempotentParameterMismatch error.
     * </p>
     * </note>
     * 
     * @return A client token is a unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API
     *         request using one of these actions, specify a client token in the request.</p> <note>
     *         <p>
     *         Avoid reusing the same client token for other API requests. If you retry a request that completed
     *         successfully using the same client token and the same parameters, the retry succeeds without performing
     *         any further actions. If you retry a successful request using the same client token, but one or more of
     *         the parameters are different, other than the Region or Availability Zone, the retry fails with an
     *         IdempotentParameterMismatch error.
     *         </p>
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartResourceEvaluationRequest)) {
            return false;
        }
        StartResourceEvaluationRequest other = (StartResourceEvaluationRequest) obj;
        return Objects.equals(resourceDetails(), other.resourceDetails())
                && Objects.equals(evaluationContext(), other.evaluationContext())
                && Objects.equals(evaluationModeAsString(), other.evaluationModeAsString())
                && Objects.equals(evaluationTimeout(), other.evaluationTimeout())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartResourceEvaluationRequest").add("ResourceDetails", resourceDetails())
                .add("EvaluationContext", evaluationContext()).add("EvaluationMode", evaluationModeAsString())
                .add("EvaluationTimeout", evaluationTimeout()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceDetails":
            return Optional.ofNullable(clazz.cast(resourceDetails()));
        case "EvaluationContext":
            return Optional.ofNullable(clazz.cast(evaluationContext()));
        case "EvaluationMode":
            return Optional.ofNullable(clazz.cast(evaluationModeAsString()));
        case "EvaluationTimeout":
            return Optional.ofNullable(clazz.cast(evaluationTimeout()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartResourceEvaluationRequest, T> g) {
        return obj -> g.apply((StartResourceEvaluationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartResourceEvaluationRequest> {
        /**
         * <p>
         * Returns a <code>ResourceDetails</code> object.
         * </p>
         * 
         * @param resourceDetails
         *        Returns a <code>ResourceDetails</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetails(ResourceDetails resourceDetails);

        /**
         * <p>
         * Returns a <code>ResourceDetails</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceDetails.Builder} avoiding the
         * need to create one manually via {@link ResourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceDetails(ResourceDetails)}.
         * 
         * @param resourceDetails
         *        a consumer that will call methods on {@link ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDetails(ResourceDetails)
         */
        default Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return resourceDetails(ResourceDetails.builder().applyMutation(resourceDetails).build());
        }

        /**
         * <p>
         * Returns an <code>EvaluationContext</code> object.
         * </p>
         * 
         * @param evaluationContext
         *        Returns an <code>EvaluationContext</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationContext(EvaluationContext evaluationContext);

        /**
         * <p>
         * Returns an <code>EvaluationContext</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationContext.Builder} avoiding the
         * need to create one manually via {@link EvaluationContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationContext.Builder#build()} is called immediately and its
         * result is passed to {@link #evaluationContext(EvaluationContext)}.
         * 
         * @param evaluationContext
         *        a consumer that will call methods on {@link EvaluationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationContext(EvaluationContext)
         */
        default Builder evaluationContext(Consumer<EvaluationContext.Builder> evaluationContext) {
            return evaluationContext(EvaluationContext.builder().applyMutation(evaluationContext).build());
        }

        /**
         * <p>
         * The mode of an evaluation. The valid value for this API is <code>Proactive</code>.
         * </p>
         * 
         * @param evaluationMode
         *        The mode of an evaluation. The valid value for this API is <code>Proactive</code>.
         * @see EvaluationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMode
         */
        Builder evaluationMode(String evaluationMode);

        /**
         * <p>
         * The mode of an evaluation. The valid value for this API is <code>Proactive</code>.
         * </p>
         * 
         * @param evaluationMode
         *        The mode of an evaluation. The valid value for this API is <code>Proactive</code>.
         * @see EvaluationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMode
         */
        Builder evaluationMode(EvaluationMode evaluationMode);

        /**
         * <p>
         * The timeout for an evaluation. The default is 900 seconds. You cannot specify a number greater than 3600. If
         * you specify 0, Config uses the default.
         * </p>
         * 
         * @param evaluationTimeout
         *        The timeout for an evaluation. The default is 900 seconds. You cannot specify a number greater than
         *        3600. If you specify 0, Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationTimeout(Integer evaluationTimeout);

        /**
         * <p>
         * A client token is a unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API
         * request using one of these actions, specify a client token in the request.
         * </p>
         * <note>
         * <p>
         * Avoid reusing the same client token for other API requests. If you retry a request that completed
         * successfully using the same client token and the same parameters, the retry succeeds without performing any
         * further actions. If you retry a successful request using the same client token, but one or more of the
         * parameters are different, other than the Region or Availability Zone, the retry fails with an
         * IdempotentParameterMismatch error.
         * </p>
         * </note>
         * 
         * @param clientToken
         *        A client token is a unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent
         *        API request using one of these actions, specify a client token in the request.</p> <note>
         *        <p>
         *        Avoid reusing the same client token for other API requests. If you retry a request that completed
         *        successfully using the same client token and the same parameters, the retry succeeds without
         *        performing any further actions. If you retry a successful request using the same client token, but one
         *        or more of the parameters are different, other than the Region or Availability Zone, the retry fails
         *        with an IdempotentParameterMismatch error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private ResourceDetails resourceDetails;

        private EvaluationContext evaluationContext;

        private String evaluationMode;

        private Integer evaluationTimeout;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartResourceEvaluationRequest model) {
            super(model);
            resourceDetails(model.resourceDetails);
            evaluationContext(model.evaluationContext);
            evaluationMode(model.evaluationMode);
            evaluationTimeout(model.evaluationTimeout);
            clientToken(model.clientToken);
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return resourceDetails != null ? resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final EvaluationContext.Builder getEvaluationContext() {
            return evaluationContext != null ? evaluationContext.toBuilder() : null;
        }

        public final void setEvaluationContext(EvaluationContext.BuilderImpl evaluationContext) {
            this.evaluationContext = evaluationContext != null ? evaluationContext.build() : null;
        }

        @Override
        public final Builder evaluationContext(EvaluationContext evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final String getEvaluationMode() {
            return evaluationMode;
        }

        public final void setEvaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
        }

        @Override
        public final Builder evaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
            return this;
        }

        @Override
        public final Builder evaluationMode(EvaluationMode evaluationMode) {
            this.evaluationMode(evaluationMode == null ? null : evaluationMode.toString());
            return this;
        }

        public final Integer getEvaluationTimeout() {
            return evaluationTimeout;
        }

        public final void setEvaluationTimeout(Integer evaluationTimeout) {
            this.evaluationTimeout = evaluationTimeout;
        }

        @Override
        public final Builder evaluationTimeout(Integer evaluationTimeout) {
            this.evaluationTimeout = evaluationTimeout;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartResourceEvaluationRequest build() {
            return new StartResourceEvaluationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
