/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of filters to apply to the conformance pack compliance score result set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConformancePackComplianceScoresFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConformancePackComplianceScoresFilters.Builder, ConformancePackComplianceScoresFilters> {
    private static final SdkField<List<String>> CONFORMANCE_PACK_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConformancePackNames")
            .getter(getter(ConformancePackComplianceScoresFilters::conformancePackNames))
            .setter(setter(Builder::conformancePackNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> conformancePackNames;

    private ConformancePackComplianceScoresFilters(BuilderImpl builder) {
        this.conformancePackNames = builder.conformancePackNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConformancePackNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConformancePackNames() {
        return conformancePackNames != null && !(conformancePackNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the conformance packs whose compliance scores you want to include in the conformance pack compliance
     * score result set. You can include up to 25 conformance packs in the <code>ConformancePackNames</code> array of
     * strings, each with a character limit of 256 characters for the conformance pack name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConformancePackNames} method.
     * </p>
     * 
     * @return The names of the conformance packs whose compliance scores you want to include in the conformance pack
     *         compliance score result set. You can include up to 25 conformance packs in the
     *         <code>ConformancePackNames</code> array of strings, each with a character limit of 256 characters for the
     *         conformance pack name.
     */
    public final List<String> conformancePackNames() {
        return conformancePackNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasConformancePackNames() ? conformancePackNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackComplianceScoresFilters)) {
            return false;
        }
        ConformancePackComplianceScoresFilters other = (ConformancePackComplianceScoresFilters) obj;
        return hasConformancePackNames() == other.hasConformancePackNames()
                && Objects.equals(conformancePackNames(), other.conformancePackNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConformancePackComplianceScoresFilters")
                .add("ConformancePackNames", hasConformancePackNames() ? conformancePackNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackNames":
            return Optional.ofNullable(clazz.cast(conformancePackNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackComplianceScoresFilters, T> g) {
        return obj -> g.apply((ConformancePackComplianceScoresFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConformancePackComplianceScoresFilters> {
        /**
         * <p>
         * The names of the conformance packs whose compliance scores you want to include in the conformance pack
         * compliance score result set. You can include up to 25 conformance packs in the
         * <code>ConformancePackNames</code> array of strings, each with a character limit of 256 characters for the
         * conformance pack name.
         * </p>
         * 
         * @param conformancePackNames
         *        The names of the conformance packs whose compliance scores you want to include in the conformance pack
         *        compliance score result set. You can include up to 25 conformance packs in the
         *        <code>ConformancePackNames</code> array of strings, each with a character limit of 256 characters for
         *        the conformance pack name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackNames(Collection<String> conformancePackNames);

        /**
         * <p>
         * The names of the conformance packs whose compliance scores you want to include in the conformance pack
         * compliance score result set. You can include up to 25 conformance packs in the
         * <code>ConformancePackNames</code> array of strings, each with a character limit of 256 characters for the
         * conformance pack name.
         * </p>
         * 
         * @param conformancePackNames
         *        The names of the conformance packs whose compliance scores you want to include in the conformance pack
         *        compliance score result set. You can include up to 25 conformance packs in the
         *        <code>ConformancePackNames</code> array of strings, each with a character limit of 256 characters for
         *        the conformance pack name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackNames(String... conformancePackNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> conformancePackNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackComplianceScoresFilters model) {
            conformancePackNames(model.conformancePackNames);
        }

        public final Collection<String> getConformancePackNames() {
            if (conformancePackNames instanceof SdkAutoConstructList) {
                return null;
            }
            return conformancePackNames;
        }

        public final void setConformancePackNames(Collection<String> conformancePackNames) {
            this.conformancePackNames = ConformancePackNameFilterCopier.copy(conformancePackNames);
        }

        @Override
        public final Builder conformancePackNames(Collection<String> conformancePackNames) {
            this.conformancePackNames = ConformancePackNameFilterCopier.copy(conformancePackNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackNames(String... conformancePackNames) {
            conformancePackNames(Arrays.asList(conformancePackNames));
            return this;
        }

        @Override
        public ConformancePackComplianceScoresFilters build() {
            return new ConformancePackComplianceScoresFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
