/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAggregateResourceConfigResponse extends ConfigResponse implements
        ToCopyableBuilder<BatchGetAggregateResourceConfigResponse.Builder, BatchGetAggregateResourceConfigResponse> {
    private static final SdkField<List<BaseConfigurationItem>> BASE_CONFIGURATION_ITEMS_FIELD = SdkField
            .<List<BaseConfigurationItem>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetAggregateResourceConfigResponse::baseConfigurationItems))
            .setter(setter(Builder::baseConfigurationItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseConfigurationItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BaseConfigurationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BaseConfigurationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AggregateResourceIdentifier>> UNPROCESSED_RESOURCE_IDENTIFIERS_FIELD = SdkField
            .<List<AggregateResourceIdentifier>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetAggregateResourceConfigResponse::unprocessedResourceIdentifiers))
            .setter(setter(Builder::unprocessedResourceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedResourceIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregateResourceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregateResourceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BASE_CONFIGURATION_ITEMS_FIELD, UNPROCESSED_RESOURCE_IDENTIFIERS_FIELD));

    private final List<BaseConfigurationItem> baseConfigurationItems;

    private final List<AggregateResourceIdentifier> unprocessedResourceIdentifiers;

    private BatchGetAggregateResourceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.baseConfigurationItems = builder.baseConfigurationItems;
        this.unprocessedResourceIdentifiers = builder.unprocessedResourceIdentifiers;
    }

    /**
     * <p>
     * A list that contains the current configuration of one or more resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains the current configuration of one or more resources.
     */
    public List<BaseConfigurationItem> baseConfigurationItems() {
        return baseConfigurationItems;
    }

    /**
     * <p>
     * A list of resource identifiers that were not processed with current scope. The list is empty if all the resources
     * are processed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of resource identifiers that were not processed with current scope. The list is empty if all the
     *         resources are processed.
     */
    public List<AggregateResourceIdentifier> unprocessedResourceIdentifiers() {
        return unprocessedResourceIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseConfigurationItems());
        hashCode = 31 * hashCode + Objects.hashCode(unprocessedResourceIdentifiers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAggregateResourceConfigResponse)) {
            return false;
        }
        BatchGetAggregateResourceConfigResponse other = (BatchGetAggregateResourceConfigResponse) obj;
        return Objects.equals(baseConfigurationItems(), other.baseConfigurationItems())
                && Objects.equals(unprocessedResourceIdentifiers(), other.unprocessedResourceIdentifiers());
    }

    @Override
    public String toString() {
        return ToString.builder("BatchGetAggregateResourceConfigResponse")
                .add("BaseConfigurationItems", baseConfigurationItems())
                .add("UnprocessedResourceIdentifiers", unprocessedResourceIdentifiers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseConfigurationItems":
            return Optional.ofNullable(clazz.cast(baseConfigurationItems()));
        case "UnprocessedResourceIdentifiers":
            return Optional.ofNullable(clazz.cast(unprocessedResourceIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAggregateResourceConfigResponse, T> g) {
        return obj -> g.apply((BatchGetAggregateResourceConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetAggregateResourceConfigResponse> {
        /**
         * <p>
         * A list that contains the current configuration of one or more resources.
         * </p>
         * 
         * @param baseConfigurationItems
         *        A list that contains the current configuration of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems);

        /**
         * <p>
         * A list that contains the current configuration of one or more resources.
         * </p>
         * 
         * @param baseConfigurationItems
         *        A list that contains the current configuration of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseConfigurationItems(BaseConfigurationItem... baseConfigurationItems);

        /**
         * <p>
         * A list that contains the current configuration of one or more resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BaseConfigurationItem>.Builder} avoiding
         * the need to create one manually via {@link List<BaseConfigurationItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BaseConfigurationItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #baseConfigurationItems(List<BaseConfigurationItem>)}.
         * 
         * @param baseConfigurationItems
         *        a consumer that will call methods on {@link List<BaseConfigurationItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baseConfigurationItems(List<BaseConfigurationItem>)
         */
        Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder>... baseConfigurationItems);

        /**
         * <p>
         * A list of resource identifiers that were not processed with current scope. The list is empty if all the
         * resources are processed.
         * </p>
         * 
         * @param unprocessedResourceIdentifiers
         *        A list of resource identifiers that were not processed with current scope. The list is empty if all
         *        the resources are processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedResourceIdentifiers(Collection<AggregateResourceIdentifier> unprocessedResourceIdentifiers);

        /**
         * <p>
         * A list of resource identifiers that were not processed with current scope. The list is empty if all the
         * resources are processed.
         * </p>
         * 
         * @param unprocessedResourceIdentifiers
         *        A list of resource identifiers that were not processed with current scope. The list is empty if all
         *        the resources are processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedResourceIdentifiers(AggregateResourceIdentifier... unprocessedResourceIdentifiers);

        /**
         * <p>
         * A list of resource identifiers that were not processed with current scope. The list is empty if all the
         * resources are processed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AggregateResourceIdentifier>.Builder}
         * avoiding the need to create one manually via {@link List<AggregateResourceIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregateResourceIdentifier>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #unprocessedResourceIdentifiers(List<AggregateResourceIdentifier>)}.
         * 
         * @param unprocessedResourceIdentifiers
         *        a consumer that will call methods on {@link List<AggregateResourceIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedResourceIdentifiers(List<AggregateResourceIdentifier>)
         */
        Builder unprocessedResourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder>... unprocessedResourceIdentifiers);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<BaseConfigurationItem> baseConfigurationItems = DefaultSdkAutoConstructList.getInstance();

        private List<AggregateResourceIdentifier> unprocessedResourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAggregateResourceConfigResponse model) {
            super(model);
            baseConfigurationItems(model.baseConfigurationItems);
            unprocessedResourceIdentifiers(model.unprocessedResourceIdentifiers);
        }

        public final Collection<BaseConfigurationItem.Builder> getBaseConfigurationItems() {
            return baseConfigurationItems != null ? baseConfigurationItems.stream().map(BaseConfigurationItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder baseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copy(baseConfigurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(BaseConfigurationItem... baseConfigurationItems) {
            baseConfigurationItems(Arrays.asList(baseConfigurationItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder>... baseConfigurationItems) {
            baseConfigurationItems(Stream.of(baseConfigurationItems)
                    .map(c -> BaseConfigurationItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBaseConfigurationItems(Collection<BaseConfigurationItem.BuilderImpl> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copyFromBuilder(baseConfigurationItems);
        }

        public final Collection<AggregateResourceIdentifier.Builder> getUnprocessedResourceIdentifiers() {
            return unprocessedResourceIdentifiers != null ? unprocessedResourceIdentifiers.stream()
                    .map(AggregateResourceIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedResourceIdentifiers(Collection<AggregateResourceIdentifier> unprocessedResourceIdentifiers) {
            this.unprocessedResourceIdentifiers = UnprocessedResourceIdentifierListCopier.copy(unprocessedResourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceIdentifiers(AggregateResourceIdentifier... unprocessedResourceIdentifiers) {
            unprocessedResourceIdentifiers(Arrays.asList(unprocessedResourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceIdentifiers(
                Consumer<AggregateResourceIdentifier.Builder>... unprocessedResourceIdentifiers) {
            unprocessedResourceIdentifiers(Stream.of(unprocessedResourceIdentifiers)
                    .map(c -> AggregateResourceIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedResourceIdentifiers(
                Collection<AggregateResourceIdentifier.BuilderImpl> unprocessedResourceIdentifiers) {
            this.unprocessedResourceIdentifiers = UnprocessedResourceIdentifierListCopier
                    .copyFromBuilder(unprocessedResourceIdentifiers);
        }

        @Override
        public BatchGetAggregateResourceConfigResponse build() {
            return new BatchGetAggregateResourceConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
