/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether an Config rule is compliant. A rule is compliant if all of the resources that the rule evaluated
 * comply with it. A rule is noncompliant if any of these resources do not comply.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComplianceByConfigRule implements SdkPojo, Serializable,
        ToCopyableBuilder<ComplianceByConfigRule.Builder, ComplianceByConfigRule> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleName").getter(getter(ComplianceByConfigRule::configRuleName))
            .setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<Compliance> COMPLIANCE_FIELD = SdkField.<Compliance> builder(MarshallingType.SDK_POJO)
            .memberName("Compliance").getter(getter(ComplianceByConfigRule::compliance)).setter(setter(Builder::compliance))
            .constructor(Compliance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compliance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            COMPLIANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final Compliance compliance;

    private ComplianceByConfigRule(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.compliance = builder.compliance;
    }

    /**
     * <p>
     * The name of the Config rule.
     * </p>
     * 
     * @return The name of the Config rule.
     */
    public final String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * Indicates whether the Config rule is compliant.
     * </p>
     * 
     * @return Indicates whether the Config rule is compliant.
     */
    public final Compliance compliance() {
        return compliance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(compliance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceByConfigRule)) {
            return false;
        }
        ComplianceByConfigRule other = (ComplianceByConfigRule) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(compliance(), other.compliance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComplianceByConfigRule").add("ConfigRuleName", configRuleName()).add("Compliance", compliance())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "Compliance":
            return Optional.ofNullable(clazz.cast(compliance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceByConfigRule, T> g) {
        return obj -> g.apply((ComplianceByConfigRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComplianceByConfigRule> {
        /**
         * <p>
         * The name of the Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * Indicates whether the Config rule is compliant.
         * </p>
         * 
         * @param compliance
         *        Indicates whether the Config rule is compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(Compliance compliance);

        /**
         * <p>
         * Indicates whether the Config rule is compliant.
         * </p>
         * This is a convenience method that creates an instance of the {@link Compliance.Builder} avoiding the need to
         * create one manually via {@link Compliance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Compliance.Builder#build()} is called immediately and its result
         * is passed to {@link #compliance(Compliance)}.
         * 
         * @param compliance
         *        a consumer that will call methods on {@link Compliance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compliance(Compliance)
         */
        default Builder compliance(Consumer<Compliance.Builder> compliance) {
            return compliance(Compliance.builder().applyMutation(compliance).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private Compliance compliance;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceByConfigRule model) {
            configRuleName(model.configRuleName);
            compliance(model.compliance);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final Compliance.Builder getCompliance() {
            return compliance != null ? compliance.toBuilder() : null;
        }

        public final void setCompliance(Compliance.BuilderImpl compliance) {
            this.compliance = compliance != null ? compliance.build() : null;
        }

        @Override
        public final Builder compliance(Compliance compliance) {
            this.compliance = compliance;
            return this;
        }

        @Override
        public ComplianceByConfigRule build() {
            return new ComplianceByConfigRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
