/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigException;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigResponse;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse;
import software.amazon.awssdk.services.config.model.GetStoredQueryRequest;
import software.amazon.awssdk.services.config.model.GetStoredQueryResponse;
import software.amazon.awssdk.services.config.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.config.model.InsufficientDeliveryPolicyException;
import software.amazon.awssdk.services.config.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.config.model.InvalidConfigurationRecorderNameException;
import software.amazon.awssdk.services.config.model.InvalidDeliveryChannelNameException;
import software.amazon.awssdk.services.config.model.InvalidExpressionException;
import software.amazon.awssdk.services.config.model.InvalidLimitException;
import software.amazon.awssdk.services.config.model.InvalidNextTokenException;
import software.amazon.awssdk.services.config.model.InvalidParameterValueException;
import software.amazon.awssdk.services.config.model.InvalidRecordingGroupException;
import software.amazon.awssdk.services.config.model.InvalidResultTokenException;
import software.amazon.awssdk.services.config.model.InvalidRoleException;
import software.amazon.awssdk.services.config.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.config.model.InvalidS3KmsKeyArnException;
import software.amazon.awssdk.services.config.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.config.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.config.model.LastDeliveryChannelDeleteFailedException;
import software.amazon.awssdk.services.config.model.LimitExceededException;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse;
import software.amazon.awssdk.services.config.model.ListStoredQueriesRequest;
import software.amazon.awssdk.services.config.model.ListStoredQueriesResponse;
import software.amazon.awssdk.services.config.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.config.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.config.model.MaxActiveResourcesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigurationRecordersExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfDeliveryChannelsExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfRetentionConfigurationsExceededException;
import software.amazon.awssdk.services.config.model.NoAvailableConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoAvailableDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.config.model.NoRunningConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchBucketException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleInConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationAggregatorException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationConfigurationException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationExceptionException;
import software.amazon.awssdk.services.config.model.NoSuchRetentionConfigurationException;
import software.amazon.awssdk.services.config.model.OrganizationAccessDeniedException;
import software.amazon.awssdk.services.config.model.OrganizationAllFeaturesNotEnabledException;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.OversizedConfigurationItemException;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.PutResourceConfigRequest;
import software.amazon.awssdk.services.config.model.PutResourceConfigResponse;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.PutStoredQueryRequest;
import software.amazon.awssdk.services.config.model.PutStoredQueryResponse;
import software.amazon.awssdk.services.config.model.RemediationInProgressException;
import software.amazon.awssdk.services.config.model.ResourceConcurrentModificationException;
import software.amazon.awssdk.services.config.model.ResourceInUseException;
import software.amazon.awssdk.services.config.model.ResourceNotDiscoveredException;
import software.amazon.awssdk.services.config.model.ResourceNotFoundException;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.SelectResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectResourceConfigResponse;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.TagResourceRequest;
import software.amazon.awssdk.services.config.model.TagResourceResponse;
import software.amazon.awssdk.services.config.model.TooManyTagsException;
import software.amazon.awssdk.services.config.model.UntagResourceRequest;
import software.amazon.awssdk.services.config.model.UntagResourceResponse;
import software.amazon.awssdk.services.config.model.ValidationException;
import software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRulePublisher;
import software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourcePublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConfigRulesPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConformancePackCompliancePublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeConformancePacksPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksPublisher;
import software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher;
import software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsPublisher;
import software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRulePublisher;
import software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryPublisher;
import software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryPublisher;
import software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsPublisher;
import software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRulePublisher;
import software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourcePublisher;
import software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsPublisher;
import software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryPublisher;
import software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsPublisher;
import software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusPublisher;
import software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusPublisher;
import software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryPublisher;
import software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesPublisher;
import software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresPublisher;
import software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesPublisher;
import software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsPublisher;
import software.amazon.awssdk.services.config.paginators.ListStoredQueriesPublisher;
import software.amazon.awssdk.services.config.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigPublisher;
import software.amazon.awssdk.services.config.paginators.SelectResourceConfigPublisher;
import software.amazon.awssdk.services.config.transform.BatchGetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.BatchGetResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteEvaluationResultsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteOrganizationConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteOrganizationConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeletePendingAggregationRequestRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRemediationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRuleEvaluationStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorSourcesStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecorderStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePackComplianceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePackStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConfigRuleStatusesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConformancePackStatusesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribePendingAggregationRequestsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRetentionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConfigRuleComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConformancePackComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByResourceTypeRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetConformancePackComplianceDetailsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetConformancePackComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetCustomRulePolicyRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationConfigRuleDetailedStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationConformancePackDetailedStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationCustomRulePolicyRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceConfigHistoryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceEvaluationSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListAggregateDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListConformancePackComplianceScoresRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListResourceEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListStoredQueriesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutExternalEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutOrganizationConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutOrganizationConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRemediationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.SelectAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.SelectResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigRulesEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartRemediationExecutionRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartResourceEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StopConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ConfigAsyncClient}.
 *
 * @see ConfigAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultConfigAsyncClient implements ConfigAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConfigAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Returns the current configuration items for resources that are present in your Config aggregator. The operation
     * also returns a list of resources that are not processed in the current request. If there are no unprocessed
     * resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return tags and relationships.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetAggregateResourceConfigRequest
     * @return A Java Future containing the result of the BatchGetAggregateResourceConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetAggregateResourceConfigResponse> batchGetAggregateResourceConfig(
            BatchGetAggregateResourceConfigRequest batchGetAggregateResourceConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetAggregateResourceConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAggregateResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetAggregateResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetAggregateResourceConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetAggregateResourceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetAggregateResourceConfigRequest, BatchGetAggregateResourceConfigResponse>()
                            .withOperationName("BatchGetAggregateResourceConfig")
                            .withMarshaller(new BatchGetAggregateResourceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchGetAggregateResourceConfigRequest));
            CompletableFuture<BatchGetAggregateResourceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the <code>BaseConfigurationItem</code> for one or more requested resources. The operation also returns a
     * list of resources that are not processed in the current request. If there are no unprocessed resources, the
     * operation returns an empty unprocessedResourceKeys list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return any tags for the requested resources. This information is filtered out of the
     * supplementaryConfiguration section of the API response.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetResourceConfigRequest
     * @return A Java Future containing the result of the BatchGetResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetResourceConfigResponse> batchGetResourceConfig(
            BatchGetResourceConfigRequest batchGetResourceConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetResourceConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetResourceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetResourceConfigRequest, BatchGetResourceConfigResponse>()
                            .withOperationName("BatchGetResourceConfig")
                            .withMarshaller(new BatchGetResourceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchGetResourceConfigRequest));
            CompletableFuture<BatchGetResourceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the authorization granted to the specified configuration aggregator account in a specified region.
     * </p>
     *
     * @param deleteAggregationAuthorizationRequest
     * @return A Java Future containing the result of the DeleteAggregationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAggregationAuthorizationResponse> deleteAggregationAuthorization(
            DeleteAggregationAuthorizationRequest deleteAggregationAuthorizationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAggregationAuthorizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAggregationAuthorization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAggregationAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAggregationAuthorizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAggregationAuthorizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAggregationAuthorizationRequest, DeleteAggregationAuthorizationResponse>()
                            .withOperationName("DeleteAggregationAuthorization")
                            .withMarshaller(new DeleteAggregationAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAggregationAuthorizationRequest));
            CompletableFuture<DeleteAggregationAuthorizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Config rule and all of its evaluation results.
     * </p>
     * <p>
     * Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a rule
     * while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request for
     * the rule, you will receive a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * You can check the state of a rule by using the <code>DescribeConfigRules</code> request.
     * </p>
     *
     * @param deleteConfigRuleRequest
     * @return A Java Future containing the result of the DeleteConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfigRuleResponse> deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConfigRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfigRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigRuleRequest, DeleteConfigRuleResponse>()
                            .withOperationName("DeleteConfigRule")
                            .withMarshaller(new DeleteConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteConfigRuleRequest));
            CompletableFuture<DeleteConfigRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.
     * </p>
     *
     * @param deleteConfigurationAggregatorRequest
     * @return A Java Future containing the result of the DeleteConfigurationAggregator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfigurationAggregatorResponse> deleteConfigurationAggregator(
            DeleteConfigurationAggregatorRequest deleteConfigurationAggregatorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfigurationAggregatorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigurationAggregator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfigurationAggregatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfigurationAggregatorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfigurationAggregatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigurationAggregatorRequest, DeleteConfigurationAggregatorResponse>()
                            .withOperationName("DeleteConfigurationAggregator")
                            .withMarshaller(new DeleteConfigurationAggregatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteConfigurationAggregatorRequest));
            CompletableFuture<DeleteConfigurationAggregatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the configuration recorder.
     * </p>
     * <p>
     * After the configuration recorder is deleted, Config will not record resource configuration changes until you
     * create a new configuration recorder.
     * </p>
     * <p>
     * This action does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <code>GetResourceConfigHistory</code> action, but you
     * will not be able to access this information in the Config console until you create a new configuration recorder.
     * </p>
     *
     * @param deleteConfigurationRecorderRequest
     *        The request object for the <code>DeleteConfigurationRecorder</code> action.
     * @return A Java Future containing the result of the DeleteConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfigurationRecorderResponse> deleteConfigurationRecorder(
            DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConfigurationRecorderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigurationRecorder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfigurationRecorderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConfigurationRecorderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigurationRecorderRequest, DeleteConfigurationRecorderResponse>()
                            .withOperationName("DeleteConfigurationRecorder")
                            .withMarshaller(new DeleteConfigurationRecorderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteConfigurationRecorderRequest));
            CompletableFuture<DeleteConfigurationRecorderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified conformance pack and all the Config rules, remediation actions, and all evaluation results
     * within that conformance pack.
     * </p>
     * <p>
     * Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     *
     * @param deleteConformancePackRequest
     * @return A Java Future containing the result of the DeleteConformancePack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConformancePackResponse> deleteConformancePack(
            DeleteConformancePackRequest deleteConformancePackRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConformancePackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConformancePack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConformancePackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConformancePackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConformancePackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConformancePackRequest, DeleteConformancePackResponse>()
                            .withOperationName("DeleteConformancePack")
                            .withMarshaller(new DeleteConformancePackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteConformancePackRequest));
            CompletableFuture<DeleteConformancePackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the delivery channel.
     * </p>
     * <p>
     * Before you can delete the delivery channel, you must stop the configuration recorder by using the
     * <a>StopConfigurationRecorder</a> action.
     * </p>
     *
     * @param deleteDeliveryChannelRequest
     *        The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data, in JSON
     *        format.
     * @return A Java Future containing the result of the DeleteDeliveryChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>LastDeliveryChannelDeleteFailedException You cannot delete the delivery channel you specified because
     *         the configuration recorder is running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeliveryChannelResponse> deleteDeliveryChannel(
            DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeliveryChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeliveryChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeliveryChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeliveryChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeliveryChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeliveryChannelRequest, DeleteDeliveryChannelResponse>()
                            .withOperationName("DeleteDeliveryChannel")
                            .withMarshaller(new DeleteDeliveryChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDeliveryChannelRequest));
            CompletableFuture<DeleteDeliveryChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After
     * you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start evaluating
     * your Amazon Web Services resources against the rule.
     * </p>
     *
     * @param deleteEvaluationResultsRequest
     * @return A Java Future containing the result of the DeleteEvaluationResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteEvaluationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEvaluationResultsResponse> deleteEvaluationResults(
            DeleteEvaluationResultsRequest deleteEvaluationResultsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEvaluationResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEvaluationResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEvaluationResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEvaluationResultsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEvaluationResultsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEvaluationResultsRequest, DeleteEvaluationResultsResponse>()
                            .withOperationName("DeleteEvaluationResults")
                            .withMarshaller(new DeleteEvaluationResultsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEvaluationResultsRequest));
            CompletableFuture<DeleteEvaluationResultsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified organization Config rule and all of its evaluation results from all member accounts in that
     * organization.
     * </p>
     * <p>
     * Only a management account and a delegated administrator account can delete an organization Config rule. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a rule
     * while it is in this state.
     * </p>
     *
     * @param deleteOrganizationConfigRuleRequest
     * @return A Java Future containing the result of the DeleteOrganizationConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOrganizationConfigRuleResponse> deleteOrganizationConfigRule(
            DeleteOrganizationConfigRuleRequest deleteOrganizationConfigRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOrganizationConfigRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOrganizationConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOrganizationConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOrganizationConfigRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOrganizationConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOrganizationConfigRuleRequest, DeleteOrganizationConfigRuleResponse>()
                            .withOperationName("DeleteOrganizationConfigRule")
                            .withMarshaller(new DeleteOrganizationConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteOrganizationConfigRuleRequest));
            CompletableFuture<DeleteOrganizationConfigRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified organization conformance pack and all of the Config rules and remediation actions from all
     * member accounts in that organization.
     * </p>
     * <p>
     * Only a management account or a delegated administrator account can delete an organization conformance pack. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     *
     * @param deleteOrganizationConformancePackRequest
     * @return A Java Future containing the result of the DeleteOrganizationConformancePack operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOrganizationConformancePackResponse> deleteOrganizationConformancePack(
            DeleteOrganizationConformancePackRequest deleteOrganizationConformancePackRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteOrganizationConformancePackRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOrganizationConformancePack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOrganizationConformancePackResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteOrganizationConformancePackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOrganizationConformancePackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOrganizationConformancePackRequest, DeleteOrganizationConformancePackResponse>()
                            .withOperationName("DeleteOrganizationConformancePack")
                            .withMarshaller(new DeleteOrganizationConformancePackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteOrganizationConformancePackRequest));
            CompletableFuture<DeleteOrganizationConformancePackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes pending authorization requests for a specified aggregator account in a specified region.
     * </p>
     *
     * @param deletePendingAggregationRequestRequest
     * @return A Java Future containing the result of the DeletePendingAggregationRequest operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeletePendingAggregationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePendingAggregationRequestResponse> deletePendingAggregationRequest(
            DeletePendingAggregationRequestRequest deletePendingAggregationRequestRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deletePendingAggregationRequestRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePendingAggregationRequest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePendingAggregationRequestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePendingAggregationRequestResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePendingAggregationRequestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePendingAggregationRequestRequest, DeletePendingAggregationRequestResponse>()
                            .withOperationName("DeletePendingAggregationRequest")
                            .withMarshaller(new DeletePendingAggregationRequestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePendingAggregationRequestRequest));
            CompletableFuture<DeletePendingAggregationRequestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the remediation configuration.
     * </p>
     *
     * @param deleteRemediationConfigurationRequest
     * @return A Java Future containing the result of the DeleteRemediationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>RemediationInProgressException Remediation action is in progress. You can either cancel execution in
     *         Amazon Web Services Systems Manager or wait and try again later.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRemediationConfigurationResponse> deleteRemediationConfiguration(
            DeleteRemediationConfigurationRequest deleteRemediationConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRemediationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRemediationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRemediationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRemediationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRemediationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRemediationConfigurationRequest, DeleteRemediationConfigurationResponse>()
                            .withOperationName("DeleteRemediationConfiguration")
                            .withMarshaller(new DeleteRemediationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteRemediationConfigurationRequest));
            CompletableFuture<DeleteRemediationConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more remediation exceptions mentioned in the resource keys.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note>
     *
     * @param deleteRemediationExceptionsRequest
     * @return A Java Future containing the result of the DeleteRemediationExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationExceptionException You tried to delete a remediation exception that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRemediationExceptionsResponse> deleteRemediationExceptions(
            DeleteRemediationExceptionsRequest deleteRemediationExceptionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRemediationExceptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRemediationExceptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRemediationExceptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRemediationExceptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRemediationExceptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRemediationExceptionsRequest, DeleteRemediationExceptionsResponse>()
                            .withOperationName("DeleteRemediationExceptions")
                            .withMarshaller(new DeleteRemediationExceptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteRemediationExceptionsRequest));
            CompletableFuture<DeleteRemediationExceptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Records the configuration state for a custom resource that has been deleted. This API records a new
     * ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this
     * resource in your Config History.
     * </p>
     *
     * @param deleteResourceConfigRequest
     * @return A Java Future containing the result of the DeleteResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceConfigResponse> deleteResourceConfig(
            DeleteResourceConfigRequest deleteResourceConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceConfigRequest, DeleteResourceConfigResponse>()
                            .withOperationName("DeleteResourceConfig")
                            .withMarshaller(new DeleteResourceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteResourceConfigRequest));
            CompletableFuture<DeleteResourceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the retention configuration.
     * </p>
     *
     * @param deleteRetentionConfigurationRequest
     * @return A Java Future containing the result of the DeleteRetentionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRetentionConfigurationResponse> deleteRetentionConfiguration(
            DeleteRetentionConfigurationRequest deleteRetentionConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRetentionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRetentionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRetentionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRetentionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRetentionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRetentionConfigurationRequest, DeleteRetentionConfigurationResponse>()
                            .withOperationName("DeleteRetentionConfiguration")
                            .withMarshaller(new DeleteRetentionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteRetentionConfigurationRequest));
            CompletableFuture<DeleteRetentionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the stored query for a single Amazon Web Services account and a single Amazon Web Services Region.
     * </p>
     *
     * @param deleteStoredQueryRequest
     * @return A Java Future containing the result of the DeleteStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStoredQueryResponse> deleteStoredQuery(DeleteStoredQueryRequest deleteStoredQueryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStoredQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStoredQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStoredQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteStoredQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStoredQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStoredQueryRequest, DeleteStoredQueryResponse>()
                            .withOperationName("DeleteStoredQuery")
                            .withMarshaller(new DeleteStoredQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStoredQueryRequest));
            CompletableFuture<DeleteStoredQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After
     * the delivery has started, Config sends the following notifications using an Amazon SNS topic that you have
     * specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Notification of the start of the delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of the completion of the delivery, if the delivery was successfully completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery failure, if the delivery failed.
     * </p>
     * </li>
     * </ul>
     *
     * @param deliverConfigSnapshotRequest
     *        The input for the <a>DeliverConfigSnapshot</a> action.
     * @return A Java Future containing the result of the DeliverConfigSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeliverConfigSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeliverConfigSnapshotResponse> deliverConfigSnapshot(
            DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deliverConfigSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeliverConfigSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeliverConfigSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeliverConfigSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeliverConfigSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeliverConfigSnapshotRequest, DeliverConfigSnapshotResponse>()
                            .withOperationName("DeliverConfigSnapshot")
                            .withMarshaller(new DeliverConfigSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deliverConfigSnapshotRequest));
            CompletableFuture<DeliverConfigSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules. Does not display rules that do not have compliance results.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConfigRules operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> describeAggregateComplianceByConfigRules(
            DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAggregateComplianceByConfigRulesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAggregateComplianceByConfigRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAggregateComplianceByConfigRulesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAggregateComplianceByConfigRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAggregateComplianceByConfigRulesRequest, DescribeAggregateComplianceByConfigRulesResponse>()
                            .withOperationName("DescribeAggregateComplianceByConfigRules")
                            .withMarshaller(new DescribeAggregateComplianceByConfigRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAggregateComplianceByConfigRulesRequest));
            CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules. Does not display rules that do not have compliance results.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeAggregateComplianceByConfigRules(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesPublisher publisher = client.describeAggregateComplianceByConfigRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesPublisher publisher = client.describeAggregateComplianceByConfigRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregateComplianceByConfigRules(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeAggregateComplianceByConfigRulesPublisher describeAggregateComplianceByConfigRulesPaginator(
            DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest) {
        return new DescribeAggregateComplianceByConfigRulesPublisher(this,
                applyPaginatorUserAgent(describeAggregateComplianceByConfigRulesRequest));
    }

    /**
     * <p>
     * Returns a list of the conformance packs and their associated compliance status with the count of compliant and
     * noncompliant Config rules within each conformance pack. Also returns the total rule count which includes
     * compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConformancePacks operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> describeAggregateComplianceByConformancePacks(
            DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAggregateComplianceByConformancePacksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAggregateComplianceByConformancePacks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAggregateComplianceByConformancePacksResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAggregateComplianceByConformancePacksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAggregateComplianceByConformancePacksRequest, DescribeAggregateComplianceByConformancePacksResponse>()
                            .withOperationName("DescribeAggregateComplianceByConformancePacks")
                            .withMarshaller(new DescribeAggregateComplianceByConformancePacksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAggregateComplianceByConformancePacksRequest));
            CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the conformance packs and their associated compliance status with the count of compliant and
     * noncompliant Config rules within each conformance pack. Also returns the total rule count which includes
     * compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeAggregateComplianceByConformancePacks(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksPublisher publisher = client.describeAggregateComplianceByConformancePacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksPublisher publisher = client.describeAggregateComplianceByConformancePacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregateComplianceByConformancePacks(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeAggregateComplianceByConformancePacksPublisher describeAggregateComplianceByConformancePacksPaginator(
            DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest) {
        return new DescribeAggregateComplianceByConformancePacksPublisher(this,
                applyPaginatorUserAgent(describeAggregateComplianceByConformancePacksRequest));
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     * @return A Java Future containing the result of the DescribeAggregationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAggregationAuthorizationsResponse> describeAggregationAuthorizations(
            DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAggregationAuthorizationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAggregationAuthorizations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAggregationAuthorizationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAggregationAuthorizationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAggregationAuthorizationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAggregationAuthorizationsRequest, DescribeAggregationAuthorizationsResponse>()
                            .withOperationName("DescribeAggregationAuthorizations")
                            .withMarshaller(new DescribeAggregationAuthorizationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAggregationAuthorizationsRequest));
            CompletableFuture<DescribeAggregationAuthorizationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsPublisher publisher = client.describeAggregationAuthorizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsPublisher publisher = client.describeAggregationAuthorizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeAggregationAuthorizationsPublisher describeAggregationAuthorizationsPaginator(
            DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest) {
        return new DescribeAggregationAuthorizationsPublisher(this,
                applyPaginatorUserAgent(describeAggregationAuthorizationsRequest));
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByConfigRuleRequest
     * @return A Java Future containing the result of the DescribeComplianceByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeComplianceByConfigRuleResponse> describeComplianceByConfigRule(
            DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeComplianceByConfigRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeComplianceByConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeComplianceByConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeComplianceByConfigRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeComplianceByConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeComplianceByConfigRuleRequest, DescribeComplianceByConfigRuleResponse>()
                            .withOperationName("DescribeComplianceByConfigRule")
                            .withMarshaller(new DescribeComplianceByConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeComplianceByConfigRuleRequest));
            CompletableFuture<DescribeComplianceByConfigRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRulePublisher publisher = client.describeComplianceByConfigRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRulePublisher publisher = client.describeComplianceByConfigRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeComplianceByConfigRuleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeComplianceByConfigRulePublisher describeComplianceByConfigRulePaginator(
            DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        return new DescribeComplianceByConfigRulePublisher(this, applyPaginatorUserAgent(describeComplianceByConfigRuleRequest));
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * action returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByResourceRequest
     * @return A Java Future containing the result of the DescribeComplianceByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeComplianceByResourceResponse> describeComplianceByResource(
            DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeComplianceByResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeComplianceByResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeComplianceByResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeComplianceByResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeComplianceByResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeComplianceByResourceRequest, DescribeComplianceByResourceResponse>()
                            .withOperationName("DescribeComplianceByResource")
                            .withMarshaller(new DescribeComplianceByResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeComplianceByResourceRequest));
            CompletableFuture<DescribeComplianceByResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * action returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourcePublisher publisher = client.describeComplianceByResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourcePublisher publisher = client.describeComplianceByResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeComplianceByResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeComplianceByResourcePublisher describeComplianceByResourcePaginator(
            DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        return new DescribeComplianceByResourcePublisher(this, applyPaginatorUserAgent(describeComplianceByResourceRequest));
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     * @return A Java Future containing the result of the DescribeConfigRuleEvaluationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> describeConfigRuleEvaluationStatus(
            DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigRuleEvaluationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigRuleEvaluationStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigRuleEvaluationStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeConfigRuleEvaluationStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigRuleEvaluationStatusRequest, DescribeConfigRuleEvaluationStatusResponse>()
                            .withOperationName("DescribeConfigRuleEvaluationStatus")
                            .withMarshaller(new DescribeConfigRuleEvaluationStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeConfigRuleEvaluationStatusRequest));
            CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusPublisher publisher = client.describeConfigRuleEvaluationStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusPublisher publisher = client.describeConfigRuleEvaluationStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeConfigRuleEvaluationStatusPublisher describeConfigRuleEvaluationStatusPaginator(
            DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        return new DescribeConfigRuleEvaluationStatusPublisher(this,
                applyPaginatorUserAgent(describeConfigRuleEvaluationStatusRequest));
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     *
     * @param describeConfigRulesRequest
     * @return A Java Future containing the result of the DescribeConfigRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigRulesResponse> describeConfigRules(
            DescribeConfigRulesRequest describeConfigRulesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConfigRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConfigRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConfigRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigRulesRequest, DescribeConfigRulesResponse>()
                            .withOperationName("DescribeConfigRules")
                            .withMarshaller(new DescribeConfigRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeConfigRulesRequest));
            CompletableFuture<DescribeConfigRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesPublisher publisher = client.describeConfigRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesPublisher publisher = client.describeConfigRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeConfigRulesPublisher describeConfigRulesPaginator(DescribeConfigRulesRequest describeConfigRulesRequest) {
        return new DescribeConfigRulesPublisher(this, applyPaginatorUserAgent(describeConfigRulesRequest));
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     * @return A Java Future containing the result of the DescribeConfigurationAggregatorSourcesStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> describeConfigurationAggregatorSourcesStatus(
            DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationAggregatorSourcesStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationAggregatorSourcesStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigurationAggregatorSourcesStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeConfigurationAggregatorSourcesStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationAggregatorSourcesStatusRequest, DescribeConfigurationAggregatorSourcesStatusResponse>()
                            .withOperationName("DescribeConfigurationAggregatorSourcesStatus")
                            .withMarshaller(new DescribeConfigurationAggregatorSourcesStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConfigurationAggregatorSourcesStatusRequest));
            CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregatorSourcesStatus(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusPublisher publisher = client.describeConfigurationAggregatorSourcesStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusPublisher publisher = client.describeConfigurationAggregatorSourcesStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregatorSourcesStatus(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeConfigurationAggregatorSourcesStatusPublisher describeConfigurationAggregatorSourcesStatusPaginator(
            DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest) {
        return new DescribeConfigurationAggregatorSourcesStatusPublisher(this,
                applyPaginatorUserAgent(describeConfigurationAggregatorSourcesStatusRequest));
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     * @return A Java Future containing the result of the DescribeConfigurationAggregators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigurationAggregatorsResponse> describeConfigurationAggregators(
            DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationAggregatorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationAggregators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigurationAggregatorsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeConfigurationAggregatorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConfigurationAggregatorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationAggregatorsRequest, DescribeConfigurationAggregatorsResponse>()
                            .withOperationName("DescribeConfigurationAggregators")
                            .withMarshaller(new DescribeConfigurationAggregatorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeConfigurationAggregatorsRequest));
            CompletableFuture<DescribeConfigurationAggregatorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsPublisher publisher = client.describeConfigurationAggregatorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsPublisher publisher = client.describeConfigurationAggregatorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeConfigurationAggregatorsPublisher describeConfigurationAggregatorsPaginator(
            DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest) {
        return new DescribeConfigurationAggregatorsPublisher(this,
                applyPaginatorUserAgent(describeConfigurationAggregatorsRequest));
    }

    /**
     * <p>
     * Returns the current status of the specified configuration recorder as well as the status of the last recording
     * event for the recorder. If a configuration recorder is not specified, this action returns the status of all
     * configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account. For a detailed status of
     * recording events over time, add your Config events to Amazon CloudWatch metrics and use CloudWatch metrics.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecorderStatusRequest
     *        The input for the <a>DescribeConfigurationRecorderStatus</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorderStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigurationRecorderStatusResponse> describeConfigurationRecorderStatus(
            DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationRecorderStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationRecorderStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigurationRecorderStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeConfigurationRecorderStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConfigurationRecorderStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationRecorderStatusRequest, DescribeConfigurationRecorderStatusResponse>()
                            .withOperationName("DescribeConfigurationRecorderStatus")
                            .withMarshaller(new DescribeConfigurationRecorderStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeConfigurationRecorderStatusRequest));
            CompletableFuture<DescribeConfigurationRecorderStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details for the specified configuration recorders. If the configuration recorder is not specified,
     * this action returns the details for all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecordersRequest
     *        The input for the <a>DescribeConfigurationRecorders</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigurationRecordersResponse> describeConfigurationRecorders(
            DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationRecordersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationRecorders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigurationRecordersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConfigurationRecordersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConfigurationRecordersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationRecordersRequest, DescribeConfigurationRecordersResponse>()
                            .withOperationName("DescribeConfigurationRecorders")
                            .withMarshaller(new DescribeConfigurationRecordersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeConfigurationRecordersRequest));
            CompletableFuture<DescribeConfigurationRecordersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note>
     *
     * @param describeConformancePackComplianceRequest
     * @return A Java Future containing the result of the DescribeConformancePackCompliance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConformancePackComplianceResponse> describeConformancePackCompliance(
            DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConformancePackComplianceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConformancePackCompliance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConformancePackComplianceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeConformancePackComplianceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConformancePackComplianceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConformancePackComplianceRequest, DescribeConformancePackComplianceResponse>()
                            .withOperationName("DescribeConformancePackCompliance")
                            .withMarshaller(new DescribeConformancePackComplianceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeConformancePackComplianceRequest));
            CompletableFuture<DescribeConformancePackComplianceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeConformancePackCompliance(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackCompliancePublisher publisher = client.describeConformancePackCompliancePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackCompliancePublisher publisher = client.describeConformancePackCompliancePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePackCompliance(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConformancePackComplianceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeConformancePackCompliancePublisher describeConformancePackCompliancePaginator(
            DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) {
        return new DescribeConformancePackCompliancePublisher(this,
                applyPaginatorUserAgent(describeConformancePackComplianceRequest));
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note>
     *
     * @param describeConformancePackStatusRequest
     * @return A Java Future containing the result of the DescribeConformancePackStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConformancePackStatusResponse> describeConformancePackStatus(
            DescribeConformancePackStatusRequest describeConformancePackStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConformancePackStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConformancePackStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConformancePackStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConformancePackStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConformancePackStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConformancePackStatusRequest, DescribeConformancePackStatusResponse>()
                            .withOperationName("DescribeConformancePackStatus")
                            .withMarshaller(new DescribeConformancePackStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeConformancePackStatusRequest));
            CompletableFuture<DescribeConformancePackStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeConformancePackStatus(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusPublisher publisher = client.describeConformancePackStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusPublisher publisher = client.describeConformancePackStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePackStatus(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConformancePackStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeConformancePackStatusPublisher describeConformancePackStatusPaginator(
            DescribeConformancePackStatusRequest describeConformancePackStatusRequest) {
        return new DescribeConformancePackStatusPublisher(this, applyPaginatorUserAgent(describeConformancePackStatusRequest));
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     *
     * @param describeConformancePacksRequest
     * @return A Java Future containing the result of the DescribeConformancePacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConformancePacksResponse> describeConformancePacks(
            DescribeConformancePacksRequest describeConformancePacksRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConformancePacksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConformancePacks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConformancePacksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConformancePacksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConformancePacksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConformancePacksRequest, DescribeConformancePacksResponse>()
                            .withOperationName("DescribeConformancePacks")
                            .withMarshaller(new DescribeConformancePacksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeConformancePacksRequest));
            CompletableFuture<DescribeConformancePacksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConformancePacks(software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePacksPublisher publisher = client.describeConformancePacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePacksPublisher publisher = client.describeConformancePacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePacks(software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConformancePacksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeConformancePacksPublisher describeConformancePacksPaginator(
            DescribeConformancePacksRequest describeConformancePacksRequest) {
        return new DescribeConformancePacksPublisher(this, applyPaginatorUserAgent(describeConformancePacksRequest));
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action
     * returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelStatusRequest
     *        The input for the <a>DeliveryChannelStatus</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannelStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDeliveryChannelStatusResponse> describeDeliveryChannelStatus(
            DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDeliveryChannelStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeliveryChannelStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDeliveryChannelStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDeliveryChannelStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDeliveryChannelStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDeliveryChannelStatusRequest, DescribeDeliveryChannelStatusResponse>()
                            .withOperationName("DescribeDeliveryChannelStatus")
                            .withMarshaller(new DescribeDeliveryChannelStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDeliveryChannelStatusRequest));
            CompletableFuture<DescribeDeliveryChannelStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns
     * the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelsRequest
     *        The input for the <a>DescribeDeliveryChannels</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDeliveryChannelsResponse> describeDeliveryChannels(
            DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeliveryChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeliveryChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDeliveryChannelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDeliveryChannelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDeliveryChannelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDeliveryChannelsRequest, DescribeDeliveryChannelsResponse>()
                            .withOperationName("DescribeDeliveryChannels")
                            .withMarshaller(new DescribeDeliveryChannelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDeliveryChannelsRequest));
            CompletableFuture<DescribeDeliveryChannelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides organization Config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization Config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization Config rule names. It is only applicable, when you request all the
     * organization Config rules.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfigRuleStatuses operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> describeOrganizationConfigRuleStatuses(
            DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConfigRuleStatusesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConfigRuleStatuses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConfigRuleStatusesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrganizationConfigRuleStatusesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConfigRuleStatusesRequest, DescribeOrganizationConfigRuleStatusesResponse>()
                            .withOperationName("DescribeOrganizationConfigRuleStatuses")
                            .withMarshaller(new DescribeOrganizationConfigRuleStatusesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeOrganizationConfigRuleStatusesRequest));
            CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides organization Config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization Config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization Config rule names. It is only applicable, when you request all the
     * organization Config rules.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfigRuleStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesPublisher publisher = client.describeOrganizationConfigRuleStatusesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesPublisher publisher = client.describeOrganizationConfigRuleStatusesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfigRuleStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeOrganizationConfigRuleStatusesPublisher describeOrganizationConfigRuleStatusesPaginator(
            DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest) {
        return new DescribeOrganizationConfigRuleStatusesPublisher(this,
                applyPaginatorUserAgent(describeOrganizationConfigRuleStatusesRequest));
    }

    /**
     * <p>
     * Returns a list of organization Config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization Config rule names. It is only applicable,
     * when you request all the organization Config rules.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRulesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfigRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConfigRulesResponse> describeOrganizationConfigRules(
            DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConfigRulesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConfigRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConfigRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOrganizationConfigRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOrganizationConfigRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConfigRulesRequest, DescribeOrganizationConfigRulesResponse>()
                            .withOperationName("DescribeOrganizationConfigRules")
                            .withMarshaller(new DescribeOrganizationConfigRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeOrganizationConfigRulesRequest));
            CompletableFuture<DescribeOrganizationConfigRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of organization Config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization Config rule names. It is only applicable,
     * when you request all the organization Config rules.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfigRules(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesPublisher publisher = client.describeOrganizationConfigRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesPublisher publisher = client.describeOrganizationConfigRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfigRules(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConfigRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeOrganizationConfigRulesPublisher describeOrganizationConfigRulesPaginator(
            DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest) {
        return new DescribeOrganizationConfigRulesPublisher(this, applyPaginatorUserAgent(describeOrganizationConfigRulesRequest));
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConformancePackStatuses operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> describeOrganizationConformancePackStatuses(
            DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConformancePackStatusesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConformancePackStatuses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConformancePackStatusesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrganizationConformancePackStatusesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConformancePackStatusesRequest, DescribeOrganizationConformancePackStatusesResponse>()
                            .withOperationName("DescribeOrganizationConformancePackStatuses")
                            .withMarshaller(new DescribeOrganizationConformancePackStatusesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOrganizationConformancePackStatusesRequest));
            CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConformancePackStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesPublisher publisher = client.describeOrganizationConformancePackStatusesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesPublisher publisher = client.describeOrganizationConformancePackStatusesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConformancePackStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeOrganizationConformancePackStatusesPublisher describeOrganizationConformancePackStatusesPaginator(
            DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest) {
        return new DescribeOrganizationConformancePackStatusesPublisher(this,
                applyPaginatorUserAgent(describeOrganizationConformancePackStatusesRequest));
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePacksRequest
     * @return A Java Future containing the result of the DescribeOrganizationConformancePacks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConformancePacksResponse> describeOrganizationConformancePacks(
            DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConformancePacksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConformancePacks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConformancePacksResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrganizationConformancePacksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOrganizationConformancePacksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConformancePacksRequest, DescribeOrganizationConformancePacksResponse>()
                            .withOperationName("DescribeOrganizationConformancePacks")
                            .withMarshaller(new DescribeOrganizationConformancePacksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeOrganizationConformancePacksRequest));
            CompletableFuture<DescribeOrganizationConformancePacksResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConformancePacks(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksPublisher publisher = client.describeOrganizationConformancePacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksPublisher publisher = client.describeOrganizationConformancePacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConformancePacks(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConformancePacksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeOrganizationConformancePacksPublisher describeOrganizationConformancePacksPaginator(
            DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest) {
        return new DescribeOrganizationConformancePacksPublisher(this,
                applyPaginatorUserAgent(describeOrganizationConformancePacksRequest));
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     * @return A Java Future containing the result of the DescribePendingAggregationRequests operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePendingAggregationRequestsResponse> describePendingAggregationRequests(
            DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePendingAggregationRequestsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePendingAggregationRequests");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePendingAggregationRequestsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribePendingAggregationRequestsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePendingAggregationRequestsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePendingAggregationRequestsRequest, DescribePendingAggregationRequestsResponse>()
                            .withOperationName("DescribePendingAggregationRequests")
                            .withMarshaller(new DescribePendingAggregationRequestsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePendingAggregationRequestsRequest));
            CompletableFuture<DescribePendingAggregationRequestsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsPublisher publisher = client.describePendingAggregationRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsPublisher publisher = client.describePendingAggregationRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribePendingAggregationRequestsPublisher describePendingAggregationRequestsPaginator(
            DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest) {
        return new DescribePendingAggregationRequestsPublisher(this,
                applyPaginatorUserAgent(describePendingAggregationRequestsRequest));
    }

    /**
     * <p>
     * Returns the details of one or more remediation configurations.
     * </p>
     *
     * @param describeRemediationConfigurationsRequest
     * @return A Java Future containing the result of the DescribeRemediationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRemediationConfigurationsResponse> describeRemediationConfigurations(
            DescribeRemediationConfigurationsRequest describeRemediationConfigurationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRemediationConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRemediationConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRemediationConfigurationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeRemediationConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRemediationConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRemediationConfigurationsRequest, DescribeRemediationConfigurationsResponse>()
                            .withOperationName("DescribeRemediationConfigurations")
                            .withMarshaller(new DescribeRemediationConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeRemediationConfigurationsRequest));
            CompletableFuture<DescribeRemediationConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note>
     *
     * @param describeRemediationExceptionsRequest
     * @return A Java Future containing the result of the DescribeRemediationExceptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRemediationExceptionsResponse> describeRemediationExceptions(
            DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRemediationExceptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRemediationExceptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRemediationExceptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRemediationExceptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRemediationExceptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRemediationExceptionsRequest, DescribeRemediationExceptionsResponse>()
                            .withOperationName("DescribeRemediationExceptions")
                            .withMarshaller(new DescribeRemediationExceptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeRemediationExceptionsRequest));
            CompletableFuture<DescribeRemediationExceptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher publisher = client.describeRemediationExceptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsPublisher publisher = client.describeRemediationExceptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeRemediationExceptionsPublisher describeRemediationExceptionsPaginator(
            DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) {
        return new DescribeRemediationExceptionsPublisher(this, applyPaginatorUserAgent(describeRemediationExceptionsRequest));
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     * @return A Java Future containing the result of the DescribeRemediationExecutionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRemediationExecutionStatusResponse> describeRemediationExecutionStatus(
            DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRemediationExecutionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRemediationExecutionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRemediationExecutionStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeRemediationExecutionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRemediationExecutionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRemediationExecutionStatusRequest, DescribeRemediationExecutionStatusResponse>()
                            .withOperationName("DescribeRemediationExecutionStatus")
                            .withMarshaller(new DescribeRemediationExecutionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeRemediationExecutionStatusRequest));
            CompletableFuture<DescribeRemediationExecutionStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher publisher = client.describeRemediationExecutionStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusPublisher publisher = client.describeRemediationExecutionStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeRemediationExecutionStatusPublisher describeRemediationExecutionStatusPaginator(
            DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest) {
        return new DescribeRemediationExecutionStatusPublisher(this,
                applyPaginatorUserAgent(describeRemediationExecutionStatusRequest));
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @param describeRetentionConfigurationsRequest
     * @return A Java Future containing the result of the DescribeRetentionConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRetentionConfigurationsResponse> describeRetentionConfigurations(
            DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRetentionConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRetentionConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRetentionConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRetentionConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRetentionConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRetentionConfigurationsRequest, DescribeRetentionConfigurationsResponse>()
                            .withOperationName("DescribeRetentionConfigurations")
                            .withMarshaller(new DescribeRetentionConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeRetentionConfigurationsRequest));
            CompletableFuture<DescribeRetentionConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsPublisher publisher = client.describeRetentionConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsPublisher publisher = client.describeRetentionConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRetentionConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeRetentionConfigurationsPublisher describeRetentionConfigurationsPaginator(
            DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) {
        return new DescribeRetentionConfigurationsPublisher(this, applyPaginatorUserAgent(describeRetentionConfigurationsRequest));
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results
     * indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated,
     * and whether each resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     * @return A Java Future containing the result of the GetAggregateComplianceDetailsByConfigRule operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAggregateComplianceDetailsByConfigRuleResponse> getAggregateComplianceDetailsByConfigRule(
            GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAggregateComplianceDetailsByConfigRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAggregateComplianceDetailsByConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAggregateComplianceDetailsByConfigRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetAggregateComplianceDetailsByConfigRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAggregateComplianceDetailsByConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAggregateComplianceDetailsByConfigRuleRequest, GetAggregateComplianceDetailsByConfigRuleResponse>()
                            .withOperationName("GetAggregateComplianceDetailsByConfigRule")
                            .withMarshaller(new GetAggregateComplianceDetailsByConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getAggregateComplianceDetailsByConfigRuleRequest));
            CompletableFuture<GetAggregateComplianceDetailsByConfigRuleResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results
     * indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated,
     * and whether each resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRulePublisher publisher = client.getAggregateComplianceDetailsByConfigRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRulePublisher publisher = client.getAggregateComplianceDetailsByConfigRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    public GetAggregateComplianceDetailsByConfigRulePublisher getAggregateComplianceDetailsByConfigRulePaginator(
            GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest) {
        return new GetAggregateComplianceDetailsByConfigRulePublisher(this,
                applyPaginatorUserAgent(getAggregateComplianceDetailsByConfigRuleRequest));
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     * @return A Java Future containing the result of the GetAggregateConfigRuleComplianceSummary operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAggregateConfigRuleComplianceSummaryResponse> getAggregateConfigRuleComplianceSummary(
            GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAggregateConfigRuleComplianceSummaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAggregateConfigRuleComplianceSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAggregateConfigRuleComplianceSummaryResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetAggregateConfigRuleComplianceSummaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAggregateConfigRuleComplianceSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAggregateConfigRuleComplianceSummaryRequest, GetAggregateConfigRuleComplianceSummaryResponse>()
                            .withOperationName("GetAggregateConfigRuleComplianceSummary")
                            .withMarshaller(new GetAggregateConfigRuleComplianceSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getAggregateConfigRuleComplianceSummaryRequest));
            CompletableFuture<GetAggregateConfigRuleComplianceSummaryResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateConfigRuleComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryPublisher publisher = client.getAggregateConfigRuleComplianceSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryPublisher publisher = client.getAggregateConfigRuleComplianceSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateConfigRuleComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    public GetAggregateConfigRuleComplianceSummaryPublisher getAggregateConfigRuleComplianceSummaryPaginator(
            GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest) {
        return new GetAggregateConfigRuleComplianceSummaryPublisher(this,
                applyPaginatorUserAgent(getAggregateConfigRuleComplianceSummaryRequest));
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and
     * Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon
     * Web Services Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     * @return A Java Future containing the result of the GetAggregateConformancePackComplianceSummary operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAggregateConformancePackComplianceSummaryResponse> getAggregateConformancePackComplianceSummary(
            GetAggregateConformancePackComplianceSummaryRequest getAggregateConformancePackComplianceSummaryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAggregateConformancePackComplianceSummaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAggregateConformancePackComplianceSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAggregateConformancePackComplianceSummaryResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetAggregateConformancePackComplianceSummaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAggregateConformancePackComplianceSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAggregateConformancePackComplianceSummaryRequest, GetAggregateConformancePackComplianceSummaryResponse>()
                            .withOperationName("GetAggregateConformancePackComplianceSummary")
                            .withMarshaller(new GetAggregateConformancePackComplianceSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getAggregateConformancePackComplianceSummaryRequest));
            CompletableFuture<GetAggregateConformancePackComplianceSummaryResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and
     * Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon
     * Web Services Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryPublisher publisher = client.getAggregateConformancePackComplianceSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryPublisher publisher = client.getAggregateConformancePackComplianceSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    public GetAggregateConformancePackComplianceSummaryPublisher getAggregateConformancePackComplianceSummaryPaginator(
            GetAggregateConformancePackComplianceSummaryRequest getAggregateConformancePackComplianceSummaryRequest) {
        return new GetAggregateConformancePackComplianceSummaryPublisher(this,
                applyPaginatorUserAgent(getAggregateConformancePackComplianceSummaryRequest));
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     * @return A Java Future containing the result of the GetAggregateDiscoveredResourceCounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAggregateDiscoveredResourceCountsResponse> getAggregateDiscoveredResourceCounts(
            GetAggregateDiscoveredResourceCountsRequest getAggregateDiscoveredResourceCountsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAggregateDiscoveredResourceCountsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAggregateDiscoveredResourceCounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAggregateDiscoveredResourceCountsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetAggregateDiscoveredResourceCountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAggregateDiscoveredResourceCountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAggregateDiscoveredResourceCountsRequest, GetAggregateDiscoveredResourceCountsResponse>()
                            .withOperationName("GetAggregateDiscoveredResourceCounts")
                            .withMarshaller(new GetAggregateDiscoveredResourceCountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAggregateDiscoveredResourceCountsRequest));
            CompletableFuture<GetAggregateDiscoveredResourceCountsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsPublisher publisher = client.getAggregateDiscoveredResourceCountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsPublisher publisher = client.getAggregateDiscoveredResourceCountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    public GetAggregateDiscoveredResourceCountsPublisher getAggregateDiscoveredResourceCountsPaginator(
            GetAggregateDiscoveredResourceCountsRequest getAggregateDiscoveredResourceCountsRequest) {
        return new GetAggregateDiscoveredResourceCountsPublisher(this,
                applyPaginatorUserAgent(getAggregateDiscoveredResourceCountsRequest));
    }

    /**
     * <p>
     * Returns configuration item that is aggregated for your specific resource in a specific source account and region.
     * </p>
     *
     * @param getAggregateResourceConfigRequest
     * @return A Java Future containing the result of the GetAggregateResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>OversizedConfigurationItemException The configuration item size is outside the allowable range.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAggregateResourceConfigResponse> getAggregateResourceConfig(
            GetAggregateResourceConfigRequest getAggregateResourceConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAggregateResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAggregateResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAggregateResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAggregateResourceConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAggregateResourceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAggregateResourceConfigRequest, GetAggregateResourceConfigResponse>()
                            .withOperationName("GetAggregateResourceConfig")
                            .withMarshaller(new GetAggregateResourceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAggregateResourceConfigRequest));
            CompletableFuture<GetAggregateResourceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services
     * resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies
     * with the rule.
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     * @return A Java Future containing the result of the GetComplianceDetailsByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetComplianceDetailsByConfigRuleResponse> getComplianceDetailsByConfigRule(
            GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getComplianceDetailsByConfigRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComplianceDetailsByConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComplianceDetailsByConfigRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetComplianceDetailsByConfigRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetComplianceDetailsByConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComplianceDetailsByConfigRuleRequest, GetComplianceDetailsByConfigRuleResponse>()
                            .withOperationName("GetComplianceDetailsByConfigRule")
                            .withMarshaller(new GetComplianceDetailsByConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getComplianceDetailsByConfigRuleRequest));
            CompletableFuture<GetComplianceDetailsByConfigRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services
     * resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies
     * with the rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRulePublisher publisher = client.getComplianceDetailsByConfigRulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRulePublisher publisher = client.getComplianceDetailsByConfigRulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    public GetComplianceDetailsByConfigRulePublisher getComplianceDetailsByConfigRulePaginator(
            GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) {
        return new GetComplianceDetailsByConfigRulePublisher(this,
                applyPaginatorUserAgent(getComplianceDetailsByConfigRuleRequest));
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config
     * rules were used to evaluate the resource, when each rule was last invoked, and whether the resource complies with
     * each rule.
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     * @return A Java Future containing the result of the GetComplianceDetailsByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetComplianceDetailsByResourceResponse> getComplianceDetailsByResource(
            GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getComplianceDetailsByResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComplianceDetailsByResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComplianceDetailsByResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetComplianceDetailsByResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetComplianceDetailsByResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComplianceDetailsByResourceRequest, GetComplianceDetailsByResourceResponse>()
                            .withOperationName("GetComplianceDetailsByResource")
                            .withMarshaller(new GetComplianceDetailsByResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getComplianceDetailsByResourceRequest));
            CompletableFuture<GetComplianceDetailsByResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config
     * rules were used to evaluate the resource, when each rule was last invoked, and whether the resource complies with
     * each rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getComplianceDetailsByResource(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourcePublisher publisher = client.getComplianceDetailsByResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourcePublisher publisher = client.getComplianceDetailsByResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getComplianceDetailsByResource(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    public GetComplianceDetailsByResourcePublisher getComplianceDetailsByResourcePaginator(
            GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) {
        return new GetComplianceDetailsByResourcePublisher(this, applyPaginatorUserAgent(getComplianceDetailsByResourceRequest));
    }

    /**
     * <p>
     * Returns the number of Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     *
     * @param getComplianceSummaryByConfigRuleRequest
     * @return A Java Future containing the result of the GetComplianceSummaryByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetComplianceSummaryByConfigRuleResponse> getComplianceSummaryByConfigRule(
            GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getComplianceSummaryByConfigRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComplianceSummaryByConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComplianceSummaryByConfigRuleResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetComplianceSummaryByConfigRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetComplianceSummaryByConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComplianceSummaryByConfigRuleRequest, GetComplianceSummaryByConfigRuleResponse>()
                            .withOperationName("GetComplianceSummaryByConfigRule")
                            .withMarshaller(new GetComplianceSummaryByConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getComplianceSummaryByConfigRuleRequest));
            CompletableFuture<GetComplianceSummaryByConfigRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     *
     * @param getComplianceSummaryByResourceTypeRequest
     * @return A Java Future containing the result of the GetComplianceSummaryByResourceType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetComplianceSummaryByResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetComplianceSummaryByResourceTypeResponse> getComplianceSummaryByResourceType(
            GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getComplianceSummaryByResourceTypeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComplianceSummaryByResourceType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetComplianceSummaryByResourceTypeResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetComplianceSummaryByResourceTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetComplianceSummaryByResourceTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetComplianceSummaryByResourceTypeRequest, GetComplianceSummaryByResourceTypeResponse>()
                            .withOperationName("GetComplianceSummaryByResourceType")
                            .withMarshaller(new GetComplianceSummaryByResourceTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getComplianceSummaryByResourceTypeRequest));
            CompletableFuture<GetComplianceSummaryByResourceTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by
     * conformance pack.
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     * @return A Java Future containing the result of the GetConformancePackComplianceDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConformancePackComplianceDetailsResponse> getConformancePackComplianceDetails(
            GetConformancePackComplianceDetailsRequest getConformancePackComplianceDetailsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConformancePackComplianceDetailsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConformancePackComplianceDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConformancePackComplianceDetailsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetConformancePackComplianceDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConformancePackComplianceDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConformancePackComplianceDetailsRequest, GetConformancePackComplianceDetailsResponse>()
                            .withOperationName("GetConformancePackComplianceDetails")
                            .withMarshaller(new GetConformancePackComplianceDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getConformancePackComplianceDetailsRequest));
            CompletableFuture<GetConformancePackComplianceDetailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by
     * conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConformancePackComplianceDetails(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsPublisher publisher = client.getConformancePackComplianceDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsPublisher publisher = client.getConformancePackComplianceDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConformancePackComplianceDetails(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    public GetConformancePackComplianceDetailsPublisher getConformancePackComplianceDetailsPaginator(
            GetConformancePackComplianceDetailsRequest getConformancePackComplianceDetailsRequest) {
        return new GetConformancePackComplianceDetailsPublisher(this,
                applyPaginatorUserAgent(getConformancePackComplianceDetailsRequest));
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     * @return A Java Future containing the result of the GetConformancePackComplianceSummary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConformancePackComplianceSummaryResponse> getConformancePackComplianceSummary(
            GetConformancePackComplianceSummaryRequest getConformancePackComplianceSummaryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConformancePackComplianceSummaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConformancePackComplianceSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConformancePackComplianceSummaryResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetConformancePackComplianceSummaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConformancePackComplianceSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConformancePackComplianceSummaryRequest, GetConformancePackComplianceSummaryResponse>()
                            .withOperationName("GetConformancePackComplianceSummary")
                            .withMarshaller(new GetConformancePackComplianceSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getConformancePackComplianceSummaryRequest));
            CompletableFuture<GetConformancePackComplianceSummaryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryPublisher publisher = client.getConformancePackComplianceSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryPublisher publisher = client.getConformancePackComplianceSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    public GetConformancePackComplianceSummaryPublisher getConformancePackComplianceSummaryPaginator(
            GetConformancePackComplianceSummaryRequest getConformancePackComplianceSummaryRequest) {
        return new GetConformancePackComplianceSummaryPublisher(this,
                applyPaginatorUserAgent(getConformancePackComplianceSummaryRequest));
    }

    /**
     * <p>
     * Returns the policy definition containing the logic for your Config Custom Policy rule.
     * </p>
     *
     * @param getCustomRulePolicyRequest
     * @return A Java Future containing the result of the GetCustomRulePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetCustomRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetCustomRulePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCustomRulePolicyResponse> getCustomRulePolicy(
            GetCustomRulePolicyRequest getCustomRulePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCustomRulePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCustomRulePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCustomRulePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCustomRulePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCustomRulePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCustomRulePolicyRequest, GetCustomRulePolicyResponse>()
                            .withOperationName("GetCustomRulePolicy")
                            .withMarshaller(new GetCustomRulePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCustomRulePolicyRequest));
            CompletableFuture<GetCustomRulePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note>
     *
     * @param getDiscoveredResourceCountsRequest
     * @return A Java Future containing the result of the GetDiscoveredResourceCounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDiscoveredResourceCountsResponse> getDiscoveredResourceCounts(
            GetDiscoveredResourceCountsRequest getDiscoveredResourceCountsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDiscoveredResourceCountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDiscoveredResourceCounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDiscoveredResourceCountsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDiscoveredResourceCountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDiscoveredResourceCountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDiscoveredResourceCountsRequest, GetDiscoveredResourceCountsResponse>()
                            .withOperationName("GetDiscoveredResourceCounts")
                            .withMarshaller(new GetDiscoveredResourceCountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDiscoveredResourceCountsRequest));
            CompletableFuture<GetDiscoveredResourceCountsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsPublisher publisher = client.getDiscoveredResourceCountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsPublisher publisher = client.getDiscoveredResourceCountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getDiscoveredResourceCountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    public GetDiscoveredResourceCountsPublisher getDiscoveredResourceCountsPaginator(
            GetDiscoveredResourceCountsRequest getDiscoveredResourceCountsRequest) {
        return new GetDiscoveredResourceCountsPublisher(this, applyPaginatorUserAgent(getDiscoveredResourceCountsRequest));
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization Config rule.
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     * @return A Java Future containing the result of the GetOrganizationConfigRuleDetailedStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOrganizationConfigRuleDetailedStatusResponse> getOrganizationConfigRuleDetailedStatus(
            GetOrganizationConfigRuleDetailedStatusRequest getOrganizationConfigRuleDetailedStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getOrganizationConfigRuleDetailedStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOrganizationConfigRuleDetailedStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOrganizationConfigRuleDetailedStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetOrganizationConfigRuleDetailedStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOrganizationConfigRuleDetailedStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOrganizationConfigRuleDetailedStatusRequest, GetOrganizationConfigRuleDetailedStatusResponse>()
                            .withOperationName("GetOrganizationConfigRuleDetailedStatus")
                            .withMarshaller(new GetOrganizationConfigRuleDetailedStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getOrganizationConfigRuleDetailedStatusRequest));
            CompletableFuture<GetOrganizationConfigRuleDetailedStatusResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization Config rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOrganizationConfigRuleDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusPublisher publisher = client.getOrganizationConfigRuleDetailedStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusPublisher publisher = client.getOrganizationConfigRuleDetailedStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOrganizationConfigRuleDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    public GetOrganizationConfigRuleDetailedStatusPublisher getOrganizationConfigRuleDetailedStatusPaginator(
            GetOrganizationConfigRuleDetailedStatusRequest getOrganizationConfigRuleDetailedStatusRequest) {
        return new GetOrganizationConfigRuleDetailedStatusPublisher(this,
                applyPaginatorUserAgent(getOrganizationConfigRuleDetailedStatusRequest));
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     * @return A Java Future containing the result of the GetOrganizationConformancePackDetailedStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOrganizationConformancePackDetailedStatusResponse> getOrganizationConformancePackDetailedStatus(
            GetOrganizationConformancePackDetailedStatusRequest getOrganizationConformancePackDetailedStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getOrganizationConformancePackDetailedStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOrganizationConformancePackDetailedStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOrganizationConformancePackDetailedStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetOrganizationConformancePackDetailedStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOrganizationConformancePackDetailedStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOrganizationConformancePackDetailedStatusRequest, GetOrganizationConformancePackDetailedStatusResponse>()
                            .withOperationName("GetOrganizationConformancePackDetailedStatus")
                            .withMarshaller(new GetOrganizationConformancePackDetailedStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getOrganizationConformancePackDetailedStatusRequest));
            CompletableFuture<GetOrganizationConformancePackDetailedStatusResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOrganizationConformancePackDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusPublisher publisher = client.getOrganizationConformancePackDetailedStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusPublisher publisher = client.getOrganizationConformancePackDetailedStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOrganizationConformancePackDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    public GetOrganizationConformancePackDetailedStatusPublisher getOrganizationConformancePackDetailedStatusPaginator(
            GetOrganizationConformancePackDetailedStatusRequest getOrganizationConformancePackDetailedStatusRequest) {
        return new GetOrganizationConformancePackDetailedStatusPublisher(this,
                applyPaginatorUserAgent(getOrganizationConformancePackDetailedStatusRequest));
    }

    /**
     * <p>
     * Returns the policy definition containing the logic for your organization Config Custom Policy rule.
     * </p>
     *
     * @param getOrganizationCustomRulePolicyRequest
     * @return A Java Future containing the result of the GetOrganizationCustomRulePolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetOrganizationCustomRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationCustomRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOrganizationCustomRulePolicyResponse> getOrganizationCustomRulePolicy(
            GetOrganizationCustomRulePolicyRequest getOrganizationCustomRulePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getOrganizationCustomRulePolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOrganizationCustomRulePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOrganizationCustomRulePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOrganizationCustomRulePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOrganizationCustomRulePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOrganizationCustomRulePolicyRequest, GetOrganizationCustomRulePolicyResponse>()
                            .withOperationName("GetOrganizationCustomRulePolicy")
                            .withMarshaller(new GetOrganizationCustomRulePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getOrganizationCustomRulePolicyRequest));
            CompletableFuture<GetOrganizationCustomRulePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of <code>ConfigurationItems</code> for the specified resource. The list contains details about
     * each state of the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns
     * the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note>
     *
     * @param getResourceConfigHistoryRequest
     *        The input for the <a>GetResourceConfigHistory</a> action.
     * @return A Java Future containing the result of the GetResourceConfigHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidTimeRangeException The specified time range is not valid. The earlier time is not
     *         chronologically before the later time.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceConfigHistoryResponse> getResourceConfigHistory(
            GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceConfigHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceConfigHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceConfigHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceConfigHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourceConfigHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceConfigHistoryRequest, GetResourceConfigHistoryResponse>()
                            .withOperationName("GetResourceConfigHistory")
                            .withMarshaller(new GetResourceConfigHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getResourceConfigHistoryRequest));
            CompletableFuture<GetResourceConfigHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of <code>ConfigurationItems</code> for the specified resource. The list contains details about
     * each state of the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns
     * the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryPublisher publisher = client.getResourceConfigHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryPublisher publisher = client.getResourceConfigHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceConfigHistoryRequest
     *        The input for the <a>GetResourceConfigHistory</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidTimeRangeException The specified time range is not valid. The earlier time is not
     *         chronologically before the later time.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>ResourceNotDiscoveredException You have specified a resource that is either unknown or has not been
     *         discovered.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    public GetResourceConfigHistoryPublisher getResourceConfigHistoryPaginator(
            GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) {
        return new GetResourceConfigHistoryPublisher(this, applyPaginatorUserAgent(getResourceConfigHistoryRequest));
    }

    /**
     * <p>
     * Returns a summary of resource evaluation for the specified resource evaluation ID from the proactive rules that
     * were run. The results indicate which evaluation context was used to evaluate the rules, which resource details
     * were evaluated, the evaluation mode that was run, and whether the resource details comply with the configuration
     * of the proactive rules.
     * </p>
     * <note>
     * <p>
     * To see additional information about the evaluation result, such as which rule flagged a resource as
     * NON_COMPLIANT, use the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceDetailsByResource.html"
     * >GetComplianceDetailsByResource</a> API. For more information, see the <a href=
     * "https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceEvaluationSummary.html#API_GetResourceEvaluationSummary_Examples"
     * >Examples</a> section.
     * </p>
     * </note>
     *
     * @param getResourceEvaluationSummaryRequest
     * @return A Java Future containing the result of the GetResourceEvaluationSummary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetResourceEvaluationSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceEvaluationSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceEvaluationSummaryResponse> getResourceEvaluationSummary(
            GetResourceEvaluationSummaryRequest getResourceEvaluationSummaryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceEvaluationSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceEvaluationSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceEvaluationSummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceEvaluationSummaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourceEvaluationSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceEvaluationSummaryRequest, GetResourceEvaluationSummaryResponse>()
                            .withOperationName("GetResourceEvaluationSummary")
                            .withMarshaller(new GetResourceEvaluationSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getResourceEvaluationSummaryRequest));
            CompletableFuture<GetResourceEvaluationSummaryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details of a specific stored query.
     * </p>
     *
     * @param getStoredQueryRequest
     * @return A Java Future containing the result of the GetStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.GetStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStoredQueryResponse> getStoredQuery(GetStoredQueryRequest getStoredQueryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStoredQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStoredQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStoredQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetStoredQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStoredQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStoredQueryRequest, GetStoredQueryResponse>()
                            .withOperationName("GetStoredQuery")
                            .withMarshaller(new GetStoredQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStoredQueryRequest));
            CompletableFuture<GetStoredQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource
     * type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom
     * resource name, source account, and source region. You can narrow the results to include only resources that have
     * specific resource IDs, or a resource name, or source account ID, or source region.
     * </p>
     * <p>
     * For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type
     * <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910
     * and region us-east-1.
     * </p>
     *
     * @param listAggregateDiscoveredResourcesRequest
     * @return A Java Future containing the result of the ListAggregateDiscoveredResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListAggregateDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAggregateDiscoveredResourcesResponse> listAggregateDiscoveredResources(
            ListAggregateDiscoveredResourcesRequest listAggregateDiscoveredResourcesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAggregateDiscoveredResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAggregateDiscoveredResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAggregateDiscoveredResourcesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListAggregateDiscoveredResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAggregateDiscoveredResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAggregateDiscoveredResourcesRequest, ListAggregateDiscoveredResourcesResponse>()
                            .withOperationName("ListAggregateDiscoveredResources")
                            .withMarshaller(new ListAggregateDiscoveredResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAggregateDiscoveredResourcesRequest));
            CompletableFuture<ListAggregateDiscoveredResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource
     * type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom
     * resource name, source account, and source region. You can narrow the results to include only resources that have
     * specific resource IDs, or a resource name, or source account ID, or source region.
     * </p>
     * <p>
     * For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type
     * <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910
     * and region us-east-1.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAggregateDiscoveredResources(software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesPublisher publisher = client.listAggregateDiscoveredResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesPublisher publisher = client.listAggregateDiscoveredResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAggregateDiscoveredResources(software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAggregateDiscoveredResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListAggregateDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    public ListAggregateDiscoveredResourcesPublisher listAggregateDiscoveredResourcesPaginator(
            ListAggregateDiscoveredResourcesRequest listAggregateDiscoveredResourcesRequest) {
        return new ListAggregateDiscoveredResourcesPublisher(this,
                applyPaginatorUserAgent(listAggregateDiscoveredResourcesRequest));
    }

    /**
     * <p>
     * Returns a list of conformance pack compliance scores. A compliance score is the percentage of the number of
     * compliant rule-resource combinations in a conformance pack compared to the number of total possible rule-resource
     * combinations in the conformance pack. This metric provides you with a high-level view of the compliance state of
     * your conformance packs. You can use it to identify, investigate, and understand the level of compliance in your
     * conformance packs.
     * </p>
     * <note>
     * <p>
     * Conformance packs with no evaluation results will have a compliance score of <code>INSUFFICIENT_DATA</code>.
     * </p>
     * </note>
     *
     * @param listConformancePackComplianceScoresRequest
     * @return A Java Future containing the result of the ListConformancePackComplianceScores operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListConformancePackComplianceScores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListConformancePackComplianceScores"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConformancePackComplianceScoresResponse> listConformancePackComplianceScores(
            ListConformancePackComplianceScoresRequest listConformancePackComplianceScoresRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listConformancePackComplianceScoresRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConformancePackComplianceScores");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConformancePackComplianceScoresResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListConformancePackComplianceScoresResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConformancePackComplianceScoresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConformancePackComplianceScoresRequest, ListConformancePackComplianceScoresResponse>()
                            .withOperationName("ListConformancePackComplianceScores")
                            .withMarshaller(new ListConformancePackComplianceScoresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listConformancePackComplianceScoresRequest));
            CompletableFuture<ListConformancePackComplianceScoresResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of conformance pack compliance scores. A compliance score is the percentage of the number of
     * compliant rule-resource combinations in a conformance pack compared to the number of total possible rule-resource
     * combinations in the conformance pack. This metric provides you with a high-level view of the compliance state of
     * your conformance packs. You can use it to identify, investigate, and understand the level of compliance in your
     * conformance packs.
     * </p>
     * <note>
     * <p>
     * Conformance packs with no evaluation results will have a compliance score of <code>INSUFFICIENT_DATA</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listConformancePackComplianceScores(software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresPublisher publisher = client.listConformancePackComplianceScoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresPublisher publisher = client.listConformancePackComplianceScoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConformancePackComplianceScores(software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConformancePackComplianceScoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListConformancePackComplianceScores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListConformancePackComplianceScores"
     *      target="_top">AWS API Documentation</a>
     */
    public ListConformancePackComplianceScoresPublisher listConformancePackComplianceScoresPaginator(
            ListConformancePackComplianceScoresRequest listConformancePackComplianceScoresRequest) {
        return new ListConformancePackComplianceScoresPublisher(this,
                applyPaginatorUserAgent(listConformancePackComplianceScoresRequest));
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource
     * identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of
     * resources that Config has discovered, including those that Config is not currently recording. You can narrow the
     * results to include only resources that have specific resource IDs or a resource name.
     * </p>
     * <note>
     * <p>
     * You can specify either resource IDs or a resource name, but not both, in the same request.
     * </p>
     * </note>
     * <p>
     * The response is paginated. By default, Config lists 100 resource identifiers on each page. You can customize this
     * number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the
     * next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     * @return A Java Future containing the result of the ListDiscoveredResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDiscoveredResourcesResponse> listDiscoveredResources(
            ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDiscoveredResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDiscoveredResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDiscoveredResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDiscoveredResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDiscoveredResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDiscoveredResourcesRequest, ListDiscoveredResourcesResponse>()
                            .withOperationName("ListDiscoveredResources")
                            .withMarshaller(new ListDiscoveredResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDiscoveredResourcesRequest));
            CompletableFuture<ListDiscoveredResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource
     * identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of
     * resources that Config has discovered, including those that Config is not currently recording. You can narrow the
     * results to include only resources that have specific resource IDs or a resource name.
     * </p>
     * <note>
     * <p>
     * You can specify either resource IDs or a resource name, but not both, in the same request.
     * </p>
     * </note>
     * <p>
     * The response is paginated. By default, Config lists 100 resource identifiers on each page. You can customize this
     * number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the
     * next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDiscoveredResources(software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesPublisher publisher = client.listDiscoveredResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesPublisher publisher = client.listDiscoveredResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveredResources(software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDiscoveredResourcesPublisher listDiscoveredResourcesPaginator(
            ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        return new ListDiscoveredResourcesPublisher(this, applyPaginatorUserAgent(listDiscoveredResourcesRequest));
    }

    /**
     * <p>
     * Returns a list of proactive resource evaluations.
     * </p>
     *
     * @param listResourceEvaluationsRequest
     * @return A Java Future containing the result of the ListResourceEvaluations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidTimeRangeException The specified time range is not valid. The earlier time is not
     *         chronologically before the later time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListResourceEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListResourceEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceEvaluationsResponse> listResourceEvaluations(
            ListResourceEvaluationsRequest listResourceEvaluationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceEvaluationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceEvaluations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceEvaluationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceEvaluationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceEvaluationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceEvaluationsRequest, ListResourceEvaluationsResponse>()
                            .withOperationName("ListResourceEvaluations")
                            .withMarshaller(new ListResourceEvaluationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listResourceEvaluationsRequest));
            CompletableFuture<ListResourceEvaluationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of proactive resource evaluations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceEvaluations(software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsPublisher publisher = client.listResourceEvaluationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsPublisher publisher = client.listResourceEvaluationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceEvaluations(software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceEvaluationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidTimeRangeException The specified time range is not valid. The earlier time is not
     *         chronologically before the later time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListResourceEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListResourceEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    public ListResourceEvaluationsPublisher listResourceEvaluationsPaginator(
            ListResourceEvaluationsRequest listResourceEvaluationsRequest) {
        return new ListResourceEvaluationsPublisher(this, applyPaginatorUserAgent(listResourceEvaluationsRequest));
    }

    /**
     * <p>
     * Lists the stored queries for a single Amazon Web Services account and a single Amazon Web Services Region. The
     * default is 100.
     * </p>
     *
     * @param listStoredQueriesRequest
     * @return A Java Future containing the result of the ListStoredQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListStoredQueriesResponse> listStoredQueries(ListStoredQueriesRequest listStoredQueriesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStoredQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStoredQueries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStoredQueriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListStoredQueriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListStoredQueriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStoredQueriesRequest, ListStoredQueriesResponse>()
                            .withOperationName("ListStoredQueries")
                            .withMarshaller(new ListStoredQueriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStoredQueriesRequest));
            CompletableFuture<ListStoredQueriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the stored queries for a single Amazon Web Services account and a single Amazon Web Services Region. The
     * default is 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesPublisher publisher = client.listStoredQueriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesPublisher publisher = client.listStoredQueriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.ListStoredQueriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.ListStoredQueriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation.</b>
     * </p>
     *
     * @param listStoredQueriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    public ListStoredQueriesPublisher listStoredQueriesPaginator(ListStoredQueriesRequest listStoredQueriesRequest) {
        return new ListStoredQueriesPublisher(this, applyPaginatorUserAgent(listStoredQueriesRequest));
    }

    /**
     * <p>
     * List the tags for Config resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the tags for Config resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.config.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.config.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    public ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /**
     * <p>
     * Authorizes the aggregator account and region to collect data from the source account and region.
     * </p>
     * <note>
     * <p>
     * <code>PutAggregationAuthorization</code> is an idempotent API. Subsequent requests won’t create a duplicate
     * resource if one was already created. If a following request has different <code>tags</code> values, Config will
     * ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code>
     * will not be updated, even if they are different.
     * </p>
     * </note>
     *
     * @param putAggregationAuthorizationRequest
     * @return A Java Future containing the result of the PutAggregationAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAggregationAuthorizationResponse> putAggregationAuthorization(
            PutAggregationAuthorizationRequest putAggregationAuthorizationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putAggregationAuthorizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAggregationAuthorization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutAggregationAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutAggregationAuthorizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutAggregationAuthorizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAggregationAuthorizationRequest, PutAggregationAuthorizationResponse>()
                            .withOperationName("PutAggregationAuthorization")
                            .withMarshaller(new PutAggregationAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putAggregationAuthorizationRequest));
            CompletableFuture<PutAggregationAuthorizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates an Config rule to evaluate if your Amazon Web Services resources comply with your desired
     * configurations. For information on how many Config rules you can have per account, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b> </a> in
     * the <i>Config Developer Guide</i>.
     * </p>
     * <p>
     * There are two types of rules: <i>Config Managed Rules</i> and <i>Config Custom Rules</i>. You can use
     * <code>PutConfigRule</code> to create both Config Managed Rules and Config Custom Rules.
     * </p>
     * <p>
     * Config Managed Rules are predefined, customizable rules created by Config. For a list of managed rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config
     * Managed Rules</a>. If you are adding an Config managed rule, you must specify the rule's identifier for the
     * <code>SourceIdentifier</code> key.
     * </p>
     * <p>
     * Config Custom Rules are rules that you create from scratch. There are two ways to create Config custom rules:
     * with Lambda functions (<a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/gettingstarted-concepts.html#gettingstarted-concepts-function"
     * > Lambda Developer Guide</a>) and with Guard (<a
     * href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>), a policy-as-code
     * language. Config custom rules created with Lambda are called <i>Config Custom Lambda Rules</i> and Config custom
     * rules created with Guard are called <i>Config Custom Policy Rules</i>.
     * </p>
     * <p>
     * If you are adding a new Config Custom Lambda rule, you first need to create an Lambda function that the rule
     * invokes to evaluate your resources. When you use <code>PutConfigRule</code> to add a Custom Lambda rule to
     * Config, you must specify the Amazon Resource Name (ARN) that Lambda assigns to the function. You specify the ARN
     * in the <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of
     * the <code>ConfigRule</code> object.
     * </p>
     * <p>
     * For any new Config rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code>
     * object. Do not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code>. These values are
     * generated by Config for new rules.
     * </p>
     * <p>
     * If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code>,
     * <code>ConfigRuleId</code>, or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in
     * this request.
     * </p>
     * <p>
     * For more information about developing and using Config rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating Resources with
     * Config Rules</a> in the <i>Config Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * <code>PutConfigRule</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if one was
     * already created. If a following request has different <code>tags</code> values, Config will ignore these
     * differences and treat it as an idempotent request of the previous. In this case, <code>tags</code> will not be
     * updated, even if they are different.
     * </p>
     * </note>
     *
     * @param putConfigRuleRequest
     * @return A Java Future containing the result of the PutConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>MaxNumberOfConfigRulesExceededException Failed to add the Config rule because the account already
     *         contains the maximum number of 150 rules. Consider deleting any deactivated rules before you add new
     *         rules.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutConfigRuleResponse> putConfigRule(PutConfigRuleRequest putConfigRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putConfigRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutConfigRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConfigRuleRequest, PutConfigRuleResponse>()
                            .withOperationName("PutConfigRule")
                            .withMarshaller(new PutConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putConfigRuleRequest));
            CompletableFuture<PutConfigRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and updates the configuration aggregator with the selected source accounts and regions. The source
     * account can be individual account(s) or an organization.
     * </p>
     * <p>
     * <code>accountIds</code> that are passed will be replaced with existing accounts. If you want to add additional
     * accounts into the aggregator, call <code>DescribeConfigurationAggregators</code> to get the previous accounts and
     * then append new ones.
     * </p>
     * <note>
     * <p>
     * Config should be enabled in source accounts and regions you want to aggregate.
     * </p>
     * <p>
     * If your source type is an organization, you must be signed in to the management account or a registered delegated
     * administrator and all the features must be enabled in your organization. If the caller is a management account,
     * Config calls <code>EnableAwsServiceAccess</code> API to enable integration between Config and Organizations. If
     * the caller is a registered delegated administrator, Config calls <code>ListDelegatedAdministrators</code> API to
     * verify whether the caller is a valid delegated administrator.
     * </p>
     * <p>
     * To register a delegated administrator, see <a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli"
     * >Register a Delegated Administrator</a> in the <i>Config developer guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * <code>PutConfigurationAggregator</code> is an idempotent API. Subsequent requests won’t create a duplicate
     * resource if one was already created. If a following request has different <code>tags</code> values, Config will
     * ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code>
     * will not be updated, even if they are different.
     * </p>
     * </note>
     *
     * @param putConfigurationAggregatorRequest
     * @return A Java Future containing the result of the PutConfigurationAggregator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>LimitExceededException For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if
     *         an evaluation is in progress or if you call the <a>StartConfigRulesEvaluation</a> API more than once per
     *         minute.</p>
     *         <p>
     *         For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and
     *         aggregators exceeds the limit.</li>
     *         <li>InvalidRoleException You have provided a null or empty role ARN.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>NoAvailableOrganizationException Organization is no longer available.</li>
     *         <li>OrganizationAllFeaturesNotEnabledException Config resource cannot be created because your
     *         organization does not have all features enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutConfigurationAggregatorResponse> putConfigurationAggregator(
            PutConfigurationAggregatorRequest putConfigurationAggregatorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putConfigurationAggregatorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigurationAggregator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConfigurationAggregatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutConfigurationAggregatorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConfigurationAggregatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConfigurationAggregatorRequest, PutConfigurationAggregatorResponse>()
                            .withOperationName("PutConfigurationAggregator")
                            .withMarshaller(new PutConfigurationAggregatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putConfigurationAggregatorRequest));
            CompletableFuture<PutConfigurationAggregatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new configuration recorder to record the selected resource configurations.
     * </p>
     * <p>
     * You can use this action to change the role <code>roleARN</code> or the <code>recordingGroup</code> of an existing
     * recorder. To change the role, call the action on the existing configuration recorder and specify a role.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one configuration recorder per region in your account.
     * </p>
     * <p>
     * If <code>ConfigurationRecorder</code> does not have the <b>recordingGroup</b> parameter specified, the default is
     * to record all supported resource types.
     * </p>
     * </note>
     *
     * @param putConfigurationRecorderRequest
     *        The input for the <a>PutConfigurationRecorder</a> action.
     * @return A Java Future containing the result of the PutConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfConfigurationRecordersExceededException You have reached the limit of the number of
     *         recorders you can create.</li>
     *         <li>InvalidConfigurationRecorderNameException You have provided a configuration recorder name that is not
     *         valid.</li>
     *         <li>InvalidRoleException You have provided a null or empty role ARN.</li>
     *         <li>InvalidRecordingGroupException Config throws an exception if the recording group does not contain a
     *         valid list of resource types. Values that are not valid might also be incorrectly formatted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutConfigurationRecorderResponse> putConfigurationRecorder(
            PutConfigurationRecorderRequest putConfigurationRecorderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putConfigurationRecorderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConfigurationRecorder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutConfigurationRecorderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConfigurationRecorderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConfigurationRecorderRequest, PutConfigurationRecorderResponse>()
                            .withOperationName("PutConfigurationRecorder")
                            .withMarshaller(new PutConfigurationRecorderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putConfigurationRecorderRequest));
            CompletableFuture<PutConfigurationRecorderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates a conformance pack. A conformance pack is a collection of Config rules that can be easily
     * deployed in an account and a region and across an organization. For information on how many conformance packs you
     * can have per account, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html">
     * <b>Service Limits</b> </a> in the Config Developer Guide.
     * </p>
     * <p>
     * This API creates a service-linked role <code>AWSServiceRoleForConfigConforms</code> in your account. The
     * service-linked role is created only when the role does not exist in your account.
     * </p>
     * <note>
     * <p>
     * You must specify only one of the follow parameters: <code>TemplateS3Uri</code>, <code>TemplateBody</code> or
     * <code>TemplateSSMDocumentDetails</code>.
     * </p>
     * </note>
     *
     * @param putConformancePackRequest
     * @return A Java Future containing the result of the PutConformancePack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>ConformancePackTemplateValidationException You have specified a template that is not valid or
     *         supported.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>MaxNumberOfConformancePacksExceededException You have reached the limit of the number of conformance
     *         packs you can create in an account. For more information, see <a
     *         href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b>
     *         </a> in the Config Developer Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConformancePack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutConformancePackResponse> putConformancePack(PutConformancePackRequest putConformancePackRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putConformancePackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutConformancePack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConformancePackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutConformancePackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConformancePackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConformancePackRequest, PutConformancePackResponse>()
                            .withOperationName("PutConformancePack")
                            .withMarshaller(new PutConformancePackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putConformancePackRequest));
            CompletableFuture<PutConformancePackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS
     * topic.
     * </p>
     * <p>
     * Before you can create a delivery channel, you must create a configuration recorder.
     * </p>
     * <p>
     * You can use this action to change the Amazon S3 bucket or an Amazon SNS topic of the existing delivery channel.
     * To change the Amazon S3 bucket or an Amazon SNS topic, call this action and specify the changed values for the S3
     * bucket and the SNS topic. If you specify a different value for either the S3 bucket or the SNS topic, this action
     * will keep the existing value for the parameter that is not changed.
     * </p>
     * <note>
     * <p>
     * You can have only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param putDeliveryChannelRequest
     *        The input for the <a>PutDeliveryChannel</a> action.
     * @return A Java Future containing the result of the PutDeliveryChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfDeliveryChannelsExceededException You have reached the limit of the number of delivery
     *         channels you can create.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no configuration recorders available to provide
     *         the role needed to describe your resources. Create a configuration recorder.</li>
     *         <li>InvalidDeliveryChannelNameException The specified delivery channel name is not valid.</li>
     *         <li>NoSuchBucketException The specified Amazon S3 bucket does not exist.</li>
     *         <li>InvalidS3KeyPrefixException The specified Amazon S3 key prefix is not valid.</li>
     *         <li>InvalidS3KmsKeyArnException The specified Amazon KMS Key ARN is not valid.</li>
     *         <li>InvalidSnsTopicArnException The specified Amazon SNS topic does not exist.</li>
     *         <li>InsufficientDeliveryPolicyException Your Amazon S3 bucket policy does not permit Config to write to
     *         it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutDeliveryChannelResponse> putDeliveryChannel(PutDeliveryChannelRequest putDeliveryChannelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDeliveryChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDeliveryChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutDeliveryChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutDeliveryChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutDeliveryChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutDeliveryChannelRequest, PutDeliveryChannelResponse>()
                            .withOperationName("PutDeliveryChannel")
                            .withMarshaller(new PutDeliveryChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putDeliveryChannelRequest));
            CompletableFuture<PutDeliveryChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used by an Lambda function to deliver evaluation results to Config. This action is required in every Lambda
     * function that is invoked by an Config rule.
     * </p>
     *
     * @param putEvaluationsRequest
     * @return A Java Future containing the result of the PutEvaluations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidResultTokenException The specified <code>ResultToken</code> is not valid.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutEvaluationsResponse> putEvaluations(PutEvaluationsRequest putEvaluationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEvaluationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEvaluations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEvaluationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutEvaluationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEvaluationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEvaluationsRequest, PutEvaluationsResponse>()
                            .withOperationName("PutEvaluations")
                            .withMarshaller(new PutEvaluationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putEvaluationsRequest));
            CompletableFuture<PutEvaluationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add or updates the evaluations for process checks. This API checks if the rule is a process check when the name
     * of the Config rule is provided.
     * </p>
     *
     * @param putExternalEvaluationRequest
     * @return A Java Future containing the result of the PutExternalEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutExternalEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutExternalEvaluation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutExternalEvaluationResponse> putExternalEvaluation(
            PutExternalEvaluationRequest putExternalEvaluationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putExternalEvaluationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutExternalEvaluation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutExternalEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutExternalEvaluationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutExternalEvaluationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutExternalEvaluationRequest, PutExternalEvaluationResponse>()
                            .withOperationName("PutExternalEvaluation")
                            .withMarshaller(new PutExternalEvaluationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putExternalEvaluationRequest));
            CompletableFuture<PutExternalEvaluationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates an Config rule for your entire organization to evaluate if your Amazon Web Services resources
     * comply with your desired configurations. For information on how many organization Config rules you can have per
     * account, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service
     * Limits</b> </a> in the <i>Config Developer Guide</i>.
     * </p>
     * <p>
     * Only a management account and a delegated administrator can create or update an organization Config rule. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added. An organization can have up to 3 delegated
     * administrators.
     * </p>
     * <p>
     * This API enables organization service access through the <code>EnableAWSServiceAccess</code> action and creates a
     * service-linked role <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the management or delegated
     * administrator account of your organization. The service-linked role is created only when the role does not exist
     * in the caller account. Config verifies the existence of role with <code>GetRole</code> action.
     * </p>
     * <p>
     * To use this API with delegated administrator, register a delegated administrator by calling Amazon Web Services
     * Organization <code>register-delegated-administrator</code> for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * There are two types of rules: <i>Config Managed Rules</i> and <i>Config Custom Rules</i>. You can use
     * <code>PutOrganizationConfigRule</code> to create both Config Managed Rules and Config Custom Rules.
     * </p>
     * <p>
     * Config Managed Rules are predefined, customizable rules created by Config. For a list of managed rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config
     * Managed Rules</a>. If you are adding an Config managed rule, you must specify the rule's identifier for the
     * <code>RuleIdentifier</code> key.
     * </p>
     * <p>
     * Config Custom Rules are rules that you create from scratch. There are two ways to create Config custom rules:
     * with Lambda functions (<a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/gettingstarted-concepts.html#gettingstarted-concepts-function"
     * > Lambda Developer Guide</a>) and with Guard (<a
     * href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>), a policy-as-code
     * language. Config custom rules created with Lambda are called <i>Config Custom Lambda Rules</i> and Config custom
     * rules created with Guard are called <i>Config Custom Policy Rules</i>.
     * </p>
     * <p>
     * If you are adding a new Config Custom Lambda rule, you first need to create an Lambda function in the management
     * account or a delegated administrator that the rule invokes to evaluate your resources. You also need to create an
     * IAM role in the managed account that can be assumed by the Lambda function. When you use
     * <code>PutOrganizationConfigRule</code> to add a Custom Lambda rule to Config, you must specify the Amazon
     * Resource Name (ARN) that Lambda assigns to the function.
     * </p>
     * <note>
     * <p>
     * Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.
     * </p>
     * <p>
     * Make sure to specify one of either <code>OrganizationCustomPolicyRuleMetadata</code> for Custom Policy rules,
     * <code>OrganizationCustomRuleMetadata</code> for Custom Lambda rules, or
     * <code>OrganizationManagedRuleMetadata</code> for managed rules.
     * </p>
     * </note>
     *
     * @param putOrganizationConfigRuleRequest
     * @return A Java Future containing the result of the PutOrganizationConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfOrganizationConfigRulesExceededException You have reached the limit of the number of
     *         organization Config rules you can create. For more information, see see <a
     *         href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b>
     *         </a> in the Config Developer Guide.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>NoAvailableOrganizationException Organization is no longer available.</li>
     *         <li>OrganizationAllFeaturesNotEnabledException Config resource cannot be created because your
     *         organization does not have all features enabled.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutOrganizationConfigRuleResponse> putOrganizationConfigRule(
            PutOrganizationConfigRuleRequest putOrganizationConfigRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putOrganizationConfigRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutOrganizationConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutOrganizationConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutOrganizationConfigRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutOrganizationConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutOrganizationConfigRuleRequest, PutOrganizationConfigRuleResponse>()
                            .withOperationName("PutOrganizationConfigRule")
                            .withMarshaller(new PutOrganizationConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putOrganizationConfigRuleRequest));
            CompletableFuture<PutOrganizationConfigRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deploys conformance packs across member accounts in an Amazon Web Services Organization. For information on how
     * many organization conformance packs and how many Config rules you can have per account, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b> </a> in
     * the Config Developer Guide.
     * </p>
     * <p>
     * Only a management account and a delegated administrator can call this API. When calling this API with a delegated
     * administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added. An
     * organization can have up to 3 delegated administrators.
     * </p>
     * <p>
     * This API enables organization service access for <code>config-multiaccountsetup.amazonaws.com</code> through the
     * <code>EnableAWSServiceAccess</code> action and creates a service-linked role
     * <code>AWSServiceRoleForConfigMultiAccountSetup</code> in the management or delegated administrator account of
     * your organization. The service-linked role is created only when the role does not exist in the caller account. To
     * use this API with delegated administrator, register a delegated administrator by calling Amazon Web Services
     * Organization <code>register-delegate-admin</code> for <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <note>
     * <p>
     * Prerequisite: Ensure you call <code>EnableAllFeatures</code> API to enable all features in an organization.
     * </p>
     * <p>
     * You must specify either the <code>TemplateS3Uri</code> or the <code>TemplateBody</code> parameter, but not both.
     * If you provide both Config uses the <code>TemplateS3Uri</code> parameter and ignores the
     * <code>TemplateBody</code> parameter.
     * </p>
     * <p>
     * Config sets the state of a conformance pack to CREATE_IN_PROGRESS and UPDATE_IN_PROGRESS until the conformance
     * pack is created or updated. You cannot update a conformance pack while it is in this state.
     * </p>
     * </note>
     *
     * @param putOrganizationConformancePackRequest
     * @return A Java Future containing the result of the PutOrganizationConformancePack operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaxNumberOfOrganizationConformancePacksExceededException You have reached the limit of the number of
     *         organization conformance packs you can create in an account. For more information, see <a
     *         href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b>
     *         </a> in the Config Developer Guide.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>OrganizationConformancePackTemplateValidationException You have specified a template that is not
     *         valid or supported.</li>
     *         <li>OrganizationAllFeaturesNotEnabledException Config resource cannot be created because your
     *         organization does not have all features enabled.</li>
     *         <li>NoAvailableOrganizationException Organization is no longer available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutOrganizationConformancePackResponse> putOrganizationConformancePack(
            PutOrganizationConformancePackRequest putOrganizationConformancePackRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putOrganizationConformancePackRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutOrganizationConformancePack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutOrganizationConformancePackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutOrganizationConformancePackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutOrganizationConformancePackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutOrganizationConformancePackRequest, PutOrganizationConformancePackResponse>()
                            .withOperationName("PutOrganizationConformancePack")
                            .withMarshaller(new PutOrganizationConformancePackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putOrganizationConformancePackRequest));
            CompletableFuture<PutOrganizationConformancePackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates the remediation configuration with a specific Config rule with the selected target or action. The
     * API creates the <code>RemediationConfiguration</code> object for the Config rule. The Config rule must already
     * exist for you to add a remediation configuration. The target (SSM document) must exist and have permissions to
     * use the target.
     * </p>
     * <note>
     * <p>
     * If you make backward incompatible changes to the SSM document, you must call this again to ensure the
     * remediations can run.
     * </p>
     * <p>
     * This API does not support adding remediation configurations for service-linked Config Rules such as Organization
     * Config rules, the rules deployed by conformance packs, and rules deployed by Amazon Web Services Security Hub.
     * </p>
     * </note> <note>
     * <p>
     * For manual remediation configuration, you need to provide a value for <code>automationAssumeRole</code> or use a
     * value in the <code>assumeRole</code>field to remediate your resources. The SSM automation document can use either
     * as long as it maps to a valid parameter.
     * </p>
     * <p>
     * However, for automatic remediation configuration, the only valid <code>assumeRole</code> field value is
     * <code>AutomationAssumeRole</code> and you need to provide a value for <code>AutomationAssumeRole</code> to
     * remediate your resources.
     * </p>
     * </note>
     *
     * @param putRemediationConfigurationsRequest
     * @return A Java Future containing the result of the PutRemediationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutRemediationConfigurationsResponse> putRemediationConfigurations(
            PutRemediationConfigurationsRequest putRemediationConfigurationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRemediationConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRemediationConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRemediationConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutRemediationConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutRemediationConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRemediationConfigurationsRequest, PutRemediationConfigurationsResponse>()
                            .withOperationName("PutRemediationConfigurations")
                            .withMarshaller(new PutRemediationConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putRemediationConfigurationsRequest));
            CompletableFuture<PutRemediationConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A remediation exception is when a specified resource is no longer considered for auto-remediation. This API adds
     * a new exception or updates an existing exception for a specified resource with a specified Config rule.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs running a remediation action for a specified
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note> <note>
     * <p>
     * When placing an exception on an Amazon Web Services resource, it is recommended that remediation is set as manual
     * remediation until the given Config rule for the specified resource evaluates the resource as
     * <code>NON_COMPLIANT</code>. Once the resource has been evaluated as <code>NON_COMPLIANT</code>, you can add
     * remediation exceptions and change the remediation type back from Manual to Auto if you want to use
     * auto-remediation. Otherwise, using auto-remediation before a <code>NON_COMPLIANT</code> evaluation result can
     * delete resources before the exception is applied.
     * </p>
     * </note> <note>
     * <p>
     * Placing an exception can only be performed on resources that are <code>NON_COMPLIANT</code>. If you use this API
     * for <code>COMPLIANT</code> resources or resources that are <code>NOT_APPLICABLE</code>, a remediation exception
     * will not be generated. For more information on the conditions that initiate the possible Config evaluation
     * results, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.html#aws-config-rules">Concepts |
     * Config Rules</a> in the Config Developer Guide.
     * </p>
     * </note>
     *
     * @param putRemediationExceptionsRequest
     * @return A Java Future containing the result of the PutRemediationExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutRemediationExceptionsResponse> putRemediationExceptions(
            PutRemediationExceptionsRequest putRemediationExceptionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRemediationExceptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRemediationExceptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRemediationExceptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutRemediationExceptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutRemediationExceptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRemediationExceptionsRequest, PutRemediationExceptionsResponse>()
                            .withOperationName("PutRemediationExceptions")
                            .withMarshaller(new PutRemediationExceptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putRemediationExceptionsRequest));
            CompletableFuture<PutRemediationExceptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Records the configuration state for the resource provided in the request. The configuration state of a resource
     * is represented in Config as Configuration Items. Once this API records the configuration item, you can retrieve
     * the list of configuration items for the custom resource type using existing Config APIs.
     * </p>
     * <note>
     * <p>
     * The custom resource type must be registered with CloudFormation. This API accepts the configuration item
     * registered with CloudFormation.
     * </p>
     * <p>
     * When you call this API, Config only stores configuration state of the resource provided in the request. This API
     * does not change or remediate the configuration of the resource.
     * </p>
     * <p>
     * Write-only schema properites are not recorded as part of the published configuration item.
     * </p>
     * </note>
     *
     * @param putResourceConfigRequest
     * @return A Java Future containing the result of the PutResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>MaxActiveResourcesExceededException You have reached the limit of active custom resource types in
     *         your account. There is a limit of 100,000. Delete unused resources using <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteResourceConfig.html"
     *         >DeleteResourceConfig</a> <code/>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutResourceConfig" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutResourceConfigResponse> putResourceConfig(PutResourceConfigRequest putResourceConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResourceConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutResourceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResourceConfigRequest, PutResourceConfigResponse>()
                            .withOperationName("PutResourceConfig")
                            .withMarshaller(new PutResourceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putResourceConfigRequest));
            CompletableFuture<PutResourceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and updates the retention configuration with details about retention period (number of days) that Config
     * stores your historical information. The API creates the <code>RetentionConfiguration</code> object and names the
     * object as <b>default</b>. When you have a <code>RetentionConfiguration</code> object named <b>default</b>,
     * calling the API modifies the default object.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @param putRetentionConfigurationRequest
     * @return A Java Future containing the result of the PutRetentionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>MaxNumberOfRetentionConfigurationsExceededException Failed to add the retention configuration because
     *         a retention configuration with that name already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutRetentionConfigurationResponse> putRetentionConfiguration(
            PutRetentionConfigurationRequest putRetentionConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRetentionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRetentionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRetentionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutRetentionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutRetentionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRetentionConfigurationRequest, PutRetentionConfigurationResponse>()
                            .withOperationName("PutRetentionConfiguration")
                            .withMarshaller(new PutRetentionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putRetentionConfigurationRequest));
            CompletableFuture<PutRetentionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Saves a new query or updates an existing saved query. The <code>QueryName</code> must be unique for a single
     * Amazon Web Services account and a single Amazon Web Services Region. You can create upto 300 queries in a single
     * Amazon Web Services account and a single Amazon Web Services Region.
     * </p>
     * <note>
     * <p>
     * <code>PutStoredQuery</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if one
     * was already created. If a following request has different <code>tags</code> values, Config will ignore these
     * differences and treat it as an idempotent request of the previous. In this case, <code>tags</code> will not be
     * updated, even if they are different.
     * </p>
     * </note>
     *
     * @param putStoredQueryRequest
     * @return A Java Future containing the result of the PutStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>TooManyTagsException You have reached the limit of the number of tags you can use. For more
     *         information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html">
     *         <b>Service Limits</b> </a> in the Config Developer Guide.</li>
     *         <li>ResourceConcurrentModificationException Two users are trying to modify the same query at the same
     *         time. Wait for a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.PutStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutStoredQueryResponse> putStoredQuery(PutStoredQueryRequest putStoredQueryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putStoredQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutStoredQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutStoredQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutStoredQueryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutStoredQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutStoredQueryRequest, PutStoredQueryResponse>()
                            .withOperationName("PutStoredQuery")
                            .withMarshaller(new PutStoredQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putStoredQueryRequest));
            CompletableFuture<PutStoredQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of Amazon
     * Web Services resources across multiple accounts and regions, performs the corresponding search, and returns
     * resource configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the Config Developer Guide.
     * </p>
     * <note>
     * <p>
     * If you run an aggregation query (i.e., using <code>GROUP BY</code> or using aggregate functions such as
     * <code>COUNT</code>; e.g.,
     * <code>SELECT resourceId, COUNT(*) WHERE resourceType = 'AWS::IAM::Role' GROUP BY resourceId</code>) and do not
     * specify the <code>MaxResults</code> or the <code>Limit</code> query parameters, the default page size is set to
     * 500.
     * </p>
     * <p>
     * If you run a non-aggregation query (i.e., not using <code>GROUP BY</code> or aggregate function; e.g.,
     * <code>SELECT * WHERE resourceType = 'AWS::IAM::Role'</code>) and do not specify the <code>MaxResults</code> or
     * the <code>Limit</code> query parameters, the default page size is set to 25.
     * </p>
     * </note>
     *
     * @param selectAggregateResourceConfigRequest
     * @return A Java Future containing the result of the SelectAggregateResourceConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidExpressionException The syntax of the query is incorrect.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.SelectAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SelectAggregateResourceConfigResponse> selectAggregateResourceConfig(
            SelectAggregateResourceConfigRequest selectAggregateResourceConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                selectAggregateResourceConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SelectAggregateResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SelectAggregateResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SelectAggregateResourceConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SelectAggregateResourceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SelectAggregateResourceConfigRequest, SelectAggregateResourceConfigResponse>()
                            .withOperationName("SelectAggregateResourceConfig")
                            .withMarshaller(new SelectAggregateResourceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(selectAggregateResourceConfigRequest));
            CompletableFuture<SelectAggregateResourceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of Amazon
     * Web Services resources across multiple accounts and regions, performs the corresponding search, and returns
     * resource configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the Config Developer Guide.
     * </p>
     * <note>
     * <p>
     * If you run an aggregation query (i.e., using <code>GROUP BY</code> or using aggregate functions such as
     * <code>COUNT</code>; e.g.,
     * <code>SELECT resourceId, COUNT(*) WHERE resourceType = 'AWS::IAM::Role' GROUP BY resourceId</code>) and do not
     * specify the <code>MaxResults</code> or the <code>Limit</code> query parameters, the default page size is set to
     * 500.
     * </p>
     * <p>
     * If you run a non-aggregation query (i.e., not using <code>GROUP BY</code> or aggregate function; e.g.,
     * <code>SELECT * WHERE resourceType = 'AWS::IAM::Role'</code>) and do not specify the <code>MaxResults</code> or
     * the <code>Limit</code> query parameters, the default page size is set to 25.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #selectAggregateResourceConfig(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigPublisher publisher = client.selectAggregateResourceConfigPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigPublisher publisher = client.selectAggregateResourceConfigPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #selectAggregateResourceConfig(software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest)}
     * operation.</b>
     * </p>
     *
     * @param selectAggregateResourceConfigRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidExpressionException The syntax of the query is incorrect.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.SelectAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    public SelectAggregateResourceConfigPublisher selectAggregateResourceConfigPaginator(
            SelectAggregateResourceConfigRequest selectAggregateResourceConfigRequest) {
        return new SelectAggregateResourceConfigPublisher(this, applyPaginatorUserAgent(selectAggregateResourceConfigRequest));
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) <code>SELECT</code> command, performs the corresponding search, and
     * returns resource configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the <i>Config Developer Guide</i>.
     * </p>
     *
     * @param selectResourceConfigRequest
     * @return A Java Future containing the result of the SelectResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidExpressionException The syntax of the query is incorrect.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.SelectResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SelectResourceConfigResponse> selectResourceConfig(
            SelectResourceConfigRequest selectResourceConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, selectResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SelectResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SelectResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SelectResourceConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SelectResourceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SelectResourceConfigRequest, SelectResourceConfigResponse>()
                            .withOperationName("SelectResourceConfig")
                            .withMarshaller(new SelectResourceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(selectResourceConfigRequest));
            CompletableFuture<SelectResourceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts a structured query language (SQL) <code>SELECT</code> command, performs the corresponding search, and
     * returns resource configurations matching the properties.
     * </p>
     * <p>
     * For more information about query components, see the <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/query-components.html"> <b>Query Components</b>
     * </a> section in the <i>Config Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #selectResourceConfig(software.amazon.awssdk.services.config.model.SelectResourceConfigRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.SelectResourceConfigPublisher publisher = client.selectResourceConfigPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.SelectResourceConfigPublisher publisher = client.selectResourceConfigPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.config.model.SelectResourceConfigResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.config.model.SelectResourceConfigResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #selectResourceConfig(software.amazon.awssdk.services.config.model.SelectResourceConfigRequest)}
     * operation.</b>
     * </p>
     *
     * @param selectResourceConfigRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidExpressionException The syntax of the query is incorrect.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.SelectResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    public SelectResourceConfigPublisher selectResourceConfigPaginator(SelectResourceConfigRequest selectResourceConfigRequest) {
        return new SelectResourceConfigPublisher(this, applyPaginatorUserAgent(selectResourceConfigRequest));
    }

    /**
     * <p>
     * Runs an on-demand evaluation for the specified Config rules against the last known configuration state of the
     * resources. Use <code>StartConfigRulesEvaluation</code> when you want to test that a rule you updated is working
     * as expected. <code>StartConfigRulesEvaluation</code> does not re-record the latest configuration state for your
     * resources. It re-runs an evaluation against the last known state of your resources.
     * </p>
     * <p>
     * You can specify up to 25 Config rules per request.
     * </p>
     * <p>
     * An existing <code>StartConfigRulesEvaluation</code> call for the specified rules must complete before you can
     * call the API again. If you chose to have Config stream to an Amazon SNS topic, you will receive a
     * <code>ConfigRuleEvaluationStarted</code> notification when the evaluation starts.
     * </p>
     * <note>
     * <p>
     * You don't need to call the <code>StartConfigRulesEvaluation</code> API to run an evaluation for a new rule. When
     * you create a rule, Config evaluates your resources against the rule automatically.
     * </p>
     * </note>
     * <p>
     * The <code>StartConfigRulesEvaluation</code> API is useful if you want to run on-demand evaluations, such as the
     * following example:
     * </p>
     * <ol>
     * <li>
     * <p>
     * You have a custom rule that evaluates your IAM resources every 24 hours.
     * </p>
     * </li>
     * <li>
     * <p>
     * You update your Lambda function to add additional conditions to your rule.
     * </p>
     * </li>
     * <li>
     * <p>
     * Instead of waiting for the next periodic evaluation, you call the <code>StartConfigRulesEvaluation</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config invokes your Lambda function and evaluates your IAM resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your custom rule will still run periodic evaluations every 24 hours.
     * </p>
     * </li>
     * </ol>
     *
     * @param startConfigRulesEvaluationRequest
     * @return A Java Future containing the result of the StartConfigRulesEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>LimitExceededException For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if
     *         an evaluation is in progress or if you call the <a>StartConfigRulesEvaluation</a> API more than once per
     *         minute.</p>
     *         <p>
     *         For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and
     *         aggregators exceeds the limit.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StartConfigRulesEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartConfigRulesEvaluationResponse> startConfigRulesEvaluation(
            StartConfigRulesEvaluationRequest startConfigRulesEvaluationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startConfigRulesEvaluationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartConfigRulesEvaluation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartConfigRulesEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartConfigRulesEvaluationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartConfigRulesEvaluationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartConfigRulesEvaluationRequest, StartConfigRulesEvaluationResponse>()
                            .withOperationName("StartConfigRulesEvaluation")
                            .withMarshaller(new StartConfigRulesEvaluationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startConfigRulesEvaluationRequest));
            CompletableFuture<StartConfigRulesEvaluationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts recording configurations of the Amazon Web Services resources you have selected to record in your Amazon
     * Web Services account.
     * </p>
     * <p>
     * You must have created at least one delivery channel to successfully start the configuration recorder.
     * </p>
     *
     * @param startConfigurationRecorderRequest
     *        The input for the <a>StartConfigurationRecorder</a> action.
     * @return A Java Future containing the result of the StartConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>NoAvailableDeliveryChannelException There is no delivery channel available to record configurations.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StartConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartConfigurationRecorderResponse> startConfigurationRecorder(
            StartConfigurationRecorderRequest startConfigurationRecorderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startConfigurationRecorderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartConfigurationRecorder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartConfigurationRecorderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartConfigurationRecorderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartConfigurationRecorderRequest, StartConfigurationRecorderResponse>()
                            .withOperationName("StartConfigurationRecorder")
                            .withMarshaller(new StartConfigurationRecorderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startConfigurationRecorderRequest));
            CompletableFuture<StartConfigurationRecorderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Runs an on-demand remediation for the specified Config rules against the last known remediation configuration. It
     * runs an execution against the current state of your resources. Remediation execution is asynchronous.
     * </p>
     * <p>
     * You can specify up to 100 resource keys per request. An existing StartRemediationExecution call for the specified
     * resource keys must complete before you can call the API again.
     * </p>
     *
     * @param startRemediationExecutionRequest
     * @return A Java Future containing the result of the StartRemediationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li></li>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StartRemediationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartRemediationExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartRemediationExecutionResponse> startRemediationExecution(
            StartRemediationExecutionRequest startRemediationExecutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRemediationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRemediationExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartRemediationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartRemediationExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartRemediationExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartRemediationExecutionRequest, StartRemediationExecutionResponse>()
                            .withOperationName("StartRemediationExecution")
                            .withMarshaller(new StartRemediationExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startRemediationExecutionRequest));
            CompletableFuture<StartRemediationExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Runs an on-demand evaluation for the specified resource to determine whether the resource details will comply
     * with configured Config rules. You can also use it for evaluation purposes. Config recommends using an evaluation
     * context. It runs an execution against the resource details with all of the Config rules in your account that
     * match with the specified proactive mode and resource type.
     * </p>
     * <note>
     * <p>
     * Ensure you have the <code>cloudformation:DescribeType</code> role setup to validate the resource type schema.
     * </p>
     * <p>
     * You can find the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource type
     * schema</a> in "<i>Amazon Web Services public extensions</i>" within the CloudFormation registry or with the
     * following CLI commmand:
     * <code>aws cloudformation describe-type --type-name "AWS::S3::Bucket" --type RESOURCE</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view">Managing
     * extensions through the CloudFormation registry</a> and <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon
     * Web Services resource and property types reference</a> in the CloudFormation User Guide.
     * </p>
     * </note>
     *
     * @param startResourceEvaluationRequest
     * @return A Java Future containing the result of the StartResourceEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>IdempotentParameterMismatchException Using the same client token with one or more different
     *         parameters. Specify a new client token with the parameter changes and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StartResourceEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartResourceEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartResourceEvaluationResponse> startResourceEvaluation(
            StartResourceEvaluationRequest startResourceEvaluationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startResourceEvaluationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartResourceEvaluation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartResourceEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartResourceEvaluationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartResourceEvaluationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartResourceEvaluationRequest, StartResourceEvaluationResponse>()
                            .withOperationName("StartResourceEvaluation")
                            .withMarshaller(new StartResourceEvaluationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startResourceEvaluationRequest));
            CompletableFuture<StartResourceEvaluationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops recording configurations of the Amazon Web Services resources you have selected to record in your Amazon
     * Web Services account.
     * </p>
     *
     * @param stopConfigurationRecorderRequest
     *        The input for the <a>StopConfigurationRecorder</a> action.
     * @return A Java Future containing the result of the StopConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.StopConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopConfigurationRecorderResponse> stopConfigurationRecorder(
            StopConfigurationRecorderRequest stopConfigurationRecorderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopConfigurationRecorderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopConfigurationRecorder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopConfigurationRecorderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopConfigurationRecorderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopConfigurationRecorderRequest, StopConfigurationRecorderResponse>()
                            .withOperationName("StopConfigurationRecorder")
                            .withMarshaller(new StopConfigurationRecorderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopConfigurationRecorderRequest));
            CompletableFuture<StopConfigurationRecorderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are
     * not specified in the request parameters, they are not changed. If existing tags are specified, however, then
     * their values will be updated. When a resource is deleted, the tags associated with that resource are deleted as
     * well.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>TooManyTagsException You have reached the limit of the number of tags you can use. For more
     *         information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html">
     *         <b>Service Limits</b> </a> in the Config Developer Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.</li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ConfigException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                                .exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException")
                                .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                                .exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                                .exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                                .exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                                .exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                .exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResultTokenException")
                                .exceptionBuilderSupplier(InvalidResultTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                                .exceptionBuilderSupplier(OversizedConfigurationItemException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                                .exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                                .exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                                .exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                                .exceptionBuilderSupplier(RemediationInProgressException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                                .exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                                .exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                                .exceptionBuilderSupplier(NoAvailableOrganizationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                                .exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                                .exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                                .exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLimitException")
                                .exceptionBuilderSupplier(InvalidLimitException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                .exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch")
                                .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                                .exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                                .exceptionBuilderSupplier(InsufficientPermissionsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidExpressionException")
                                .exceptionBuilderSupplier(InvalidExpressionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException")
                                .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                                .exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                                .exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                                .exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                                .exceptionBuilderSupplier(NoSuchConformancePackException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException")
                                .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchBucketException")
                                .exceptionBuilderSupplier(NoSuchBucketException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                                .exceptionBuilderSupplier(InvalidRecordingGroupException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                                .exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTimeRangeException")
                                .exceptionBuilderSupplier(InvalidTimeRangeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException")
                                .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRoleException")
                                .exceptionBuilderSupplier(InvalidRoleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                                .exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                                .exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException")
                                .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException")
                                .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends ConfigRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
