/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse;

public class SelectAggregateResourceConfigPublisher
implements SdkPublisher<SelectAggregateResourceConfigResponse> {
    private final ConfigAsyncClient client;
    private final SelectAggregateResourceConfigRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SelectAggregateResourceConfigPublisher(ConfigAsyncClient client, SelectAggregateResourceConfigRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SelectAggregateResourceConfigPublisher(ConfigAsyncClient client, SelectAggregateResourceConfigRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SelectAggregateResourceConfigResponseFetcher();
    }

    public void subscribe(Subscriber<? super SelectAggregateResourceConfigResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> results() {
        Function<SelectAggregateResourceConfigResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SelectAggregateResourceConfigResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SelectAggregateResourceConfigResponseFetcher
    implements AsyncPageFetcher<SelectAggregateResourceConfigResponse> {
        private SelectAggregateResourceConfigResponseFetcher() {
        }

        public boolean hasNextPage(SelectAggregateResourceConfigResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SelectAggregateResourceConfigResponse> nextPage(SelectAggregateResourceConfigResponse previousPage) {
            if (previousPage == null) {
                return SelectAggregateResourceConfigPublisher.this.client.selectAggregateResourceConfig(SelectAggregateResourceConfigPublisher.this.firstRequest);
            }
            return SelectAggregateResourceConfigPublisher.this.client.selectAggregateResourceConfig((SelectAggregateResourceConfigRequest)((Object)SelectAggregateResourceConfigPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

