/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.model.ResourceTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordingGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordingGroup> {
    private static final SdkField<Boolean> ALL_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allSupported").getter(RecordingGroup.getter(RecordingGroup::allSupported)).setter(RecordingGroup.setter(Builder::allSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allSupported").build()}).build();
    private static final SdkField<Boolean> INCLUDE_GLOBAL_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeGlobalResourceTypes").getter(RecordingGroup.getter(RecordingGroup::includeGlobalResourceTypes)).setter(RecordingGroup.setter(Builder::includeGlobalResourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeGlobalResourceTypes").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTypes").getter(RecordingGroup.getter(RecordingGroup::resourceTypesAsStrings)).setter(RecordingGroup.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_SUPPORTED_FIELD, INCLUDE_GLOBAL_RESOURCE_TYPES_FIELD, RESOURCE_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean allSupported;
    private final Boolean includeGlobalResourceTypes;
    private final List<String> resourceTypes;

    private RecordingGroup(BuilderImpl builder) {
        this.allSupported = builder.allSupported;
        this.includeGlobalResourceTypes = builder.includeGlobalResourceTypes;
        this.resourceTypes = builder.resourceTypes;
    }

    public final Boolean allSupported() {
        return this.allSupported;
    }

    public final Boolean includeGlobalResourceTypes() {
        return this.includeGlobalResourceTypes;
    }

    public final List<ResourceType> resourceTypes() {
        return ResourceTypeListCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeGlobalResourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingGroup)) {
            return false;
        }
        RecordingGroup other = (RecordingGroup)obj;
        return Objects.equals(this.allSupported(), other.allSupported()) && Objects.equals(this.includeGlobalResourceTypes(), other.includeGlobalResourceTypes()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"RecordingGroup").add("AllSupported", (Object)this.allSupported()).add("IncludeGlobalResourceTypes", (Object)this.includeGlobalResourceTypes()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allSupported": {
                return Optional.ofNullable(clazz.cast(this.allSupported()));
            }
            case "includeGlobalResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.includeGlobalResourceTypes()));
            }
            case "resourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordingGroup, T> g) {
        return obj -> g.apply((RecordingGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allSupported;
        private Boolean includeGlobalResourceTypes;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingGroup model) {
            this.allSupported(model.allSupported);
            this.includeGlobalResourceTypes(model.includeGlobalResourceTypes);
            this.resourceTypesWithStrings(model.resourceTypes);
        }

        public final Boolean getAllSupported() {
            return this.allSupported;
        }

        public final void setAllSupported(Boolean allSupported) {
            this.allSupported = allSupported;
        }

        @Override
        public final Builder allSupported(Boolean allSupported) {
            this.allSupported = allSupported;
            return this;
        }

        public final Boolean getIncludeGlobalResourceTypes() {
            return this.includeGlobalResourceTypes;
        }

        public final void setIncludeGlobalResourceTypes(Boolean includeGlobalResourceTypes) {
            this.includeGlobalResourceTypes = includeGlobalResourceTypes;
        }

        @Override
        public final Builder includeGlobalResourceTypes(Boolean includeGlobalResourceTypes) {
            this.includeGlobalResourceTypes = includeGlobalResourceTypes;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public RecordingGroup build() {
            return new RecordingGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordingGroup> {
        public Builder allSupported(Boolean var1);

        public Builder includeGlobalResourceTypes(Boolean var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceType> var1);

        public Builder resourceTypes(ResourceType ... var1);
    }
}

