/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.OrganizationConfigRule;
import software.amazon.awssdk.services.config.model.OrganizationConfigRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConfigRulesResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationConfigRulesResponse> {
    private static final SdkField<List<OrganizationConfigRule>> ORGANIZATION_CONFIG_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConfigRules").getter(DescribeOrganizationConfigRulesResponse.getter(DescribeOrganizationConfigRulesResponse::organizationConfigRules)).setter(DescribeOrganizationConfigRulesResponse.setter(Builder::organizationConfigRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationConfigRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOrganizationConfigRulesResponse.getter(DescribeOrganizationConfigRulesResponse::nextToken)).setter(DescribeOrganizationConfigRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFIG_RULES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrganizationConfigRules", ORGANIZATION_CONFIG_RULES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<OrganizationConfigRule> organizationConfigRules;
    private final String nextToken;

    private DescribeOrganizationConfigRulesResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRules = builder.organizationConfigRules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOrganizationConfigRules() {
        return this.organizationConfigRules != null && !(this.organizationConfigRules instanceof SdkAutoConstructList);
    }

    public final List<OrganizationConfigRule> organizationConfigRules() {
        return this.organizationConfigRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationConfigRules() ? this.organizationConfigRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigRulesResponse)) {
            return false;
        }
        DescribeOrganizationConfigRulesResponse other = (DescribeOrganizationConfigRulesResponse)((Object)obj);
        return this.hasOrganizationConfigRules() == other.hasOrganizationConfigRules() && Objects.equals(this.organizationConfigRules(), other.organizationConfigRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationConfigRulesResponse").add("OrganizationConfigRules", this.hasOrganizationConfigRules() ? this.organizationConfigRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConfigRules": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigRulesResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<OrganizationConfigRule> organizationConfigRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigRulesResponse model) {
            super(model);
            this.organizationConfigRules(model.organizationConfigRules);
            this.nextToken(model.nextToken);
        }

        public final List<OrganizationConfigRule.Builder> getOrganizationConfigRules() {
            List<OrganizationConfigRule.Builder> result = OrganizationConfigRulesCopier.copyToBuilder(this.organizationConfigRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationConfigRules(Collection<OrganizationConfigRule.BuilderImpl> organizationConfigRules) {
            this.organizationConfigRules = OrganizationConfigRulesCopier.copyFromBuilder(organizationConfigRules);
        }

        @Override
        public final Builder organizationConfigRules(Collection<OrganizationConfigRule> organizationConfigRules) {
            this.organizationConfigRules = OrganizationConfigRulesCopier.copy(organizationConfigRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRules(OrganizationConfigRule ... organizationConfigRules) {
            this.organizationConfigRules(Arrays.asList(organizationConfigRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRules(Consumer<OrganizationConfigRule.Builder> ... organizationConfigRules) {
            this.organizationConfigRules(Stream.of(organizationConfigRules).map(c -> (OrganizationConfigRule)((OrganizationConfigRule.Builder)OrganizationConfigRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOrganizationConfigRulesResponse build() {
            return new DescribeOrganizationConfigRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConfigRulesResponse> {
        public Builder organizationConfigRules(Collection<OrganizationConfigRule> var1);

        public Builder organizationConfigRules(OrganizationConfigRule ... var1);

        public Builder organizationConfigRules(Consumer<OrganizationConfigRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

