/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ComplianceContributorCount;
import software.amazon.awssdk.services.config.model.ComplianceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Compliance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Compliance> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(Compliance.getter(Compliance::complianceTypeAsString)).setter(Compliance.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<ComplianceContributorCount> COMPLIANCE_CONTRIBUTOR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComplianceContributorCount").getter(Compliance.getter(Compliance::complianceContributorCount)).setter(Compliance.setter(Builder::complianceContributorCount)).constructor(ComplianceContributorCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceContributorCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD, COMPLIANCE_CONTRIBUTOR_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ComplianceType", COMPLIANCE_TYPE_FIELD);
            this.put("ComplianceContributorCount", COMPLIANCE_CONTRIBUTOR_COUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String complianceType;
    private final ComplianceContributorCount complianceContributorCount;

    private Compliance(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.complianceContributorCount = builder.complianceContributorCount;
    }

    public final ComplianceType complianceType() {
        return ComplianceType.fromValue(this.complianceType);
    }

    public final String complianceTypeAsString() {
        return this.complianceType;
    }

    public final ComplianceContributorCount complianceContributorCount() {
        return this.complianceContributorCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceContributorCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compliance)) {
            return false;
        }
        Compliance other = (Compliance)obj;
        return Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && Objects.equals(this.complianceContributorCount(), other.complianceContributorCount());
    }

    public final String toString() {
        return ToString.builder((String)"Compliance").add("ComplianceType", (Object)this.complianceTypeAsString()).add("ComplianceContributorCount", (Object)this.complianceContributorCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "ComplianceContributorCount": {
                return Optional.ofNullable(clazz.cast(this.complianceContributorCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Compliance, T> g) {
        return obj -> g.apply((Compliance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private ComplianceContributorCount complianceContributorCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Compliance model) {
            this.complianceType(model.complianceType);
            this.complianceContributorCount(model.complianceContributorCount);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final ComplianceContributorCount.Builder getComplianceContributorCount() {
            return this.complianceContributorCount != null ? this.complianceContributorCount.toBuilder() : null;
        }

        public final void setComplianceContributorCount(ComplianceContributorCount.BuilderImpl complianceContributorCount) {
            this.complianceContributorCount = complianceContributorCount != null ? complianceContributorCount.build() : null;
        }

        @Override
        public final Builder complianceContributorCount(ComplianceContributorCount complianceContributorCount) {
            this.complianceContributorCount = complianceContributorCount;
            return this;
        }

        public Compliance build() {
            return new Compliance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Compliance> {
        public Builder complianceType(String var1);

        public Builder complianceType(ComplianceType var1);

        public Builder complianceContributorCount(ComplianceContributorCount var1);

        default public Builder complianceContributorCount(Consumer<ComplianceContributorCount.Builder> complianceContributorCount) {
            return this.complianceContributorCount((ComplianceContributorCount)((ComplianceContributorCount.Builder)ComplianceContributorCount.builder().applyMutation(complianceContributorCount)).build());
        }
    }
}

