/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatus;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatusListCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationAggregatorSourcesStatusResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationAggregatorSourcesStatusResponse> {
    private static final SdkField<List<AggregatedSourceStatus>> AGGREGATED_SOURCE_STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AggregatedSourceStatusList").getter(DescribeConfigurationAggregatorSourcesStatusResponse.getter(DescribeConfigurationAggregatorSourcesStatusResponse::aggregatedSourceStatusList)).setter(DescribeConfigurationAggregatorSourcesStatusResponse.setter(Builder::aggregatedSourceStatusList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatedSourceStatusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregatedSourceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeConfigurationAggregatorSourcesStatusResponse.getter(DescribeConfigurationAggregatorSourcesStatusResponse::nextToken)).setter(DescribeConfigurationAggregatorSourcesStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATED_SOURCE_STATUS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AggregatedSourceStatusList", AGGREGATED_SOURCE_STATUS_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AggregatedSourceStatus> aggregatedSourceStatusList;
    private final String nextToken;

    private DescribeConfigurationAggregatorSourcesStatusResponse(BuilderImpl builder) {
        super(builder);
        this.aggregatedSourceStatusList = builder.aggregatedSourceStatusList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAggregatedSourceStatusList() {
        return this.aggregatedSourceStatusList != null && !(this.aggregatedSourceStatusList instanceof SdkAutoConstructList);
    }

    public final List<AggregatedSourceStatus> aggregatedSourceStatusList() {
        return this.aggregatedSourceStatusList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregatedSourceStatusList() ? this.aggregatedSourceStatusList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationAggregatorSourcesStatusResponse)) {
            return false;
        }
        DescribeConfigurationAggregatorSourcesStatusResponse other = (DescribeConfigurationAggregatorSourcesStatusResponse)((Object)obj);
        return this.hasAggregatedSourceStatusList() == other.hasAggregatedSourceStatusList() && Objects.equals(this.aggregatedSourceStatusList(), other.aggregatedSourceStatusList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationAggregatorSourcesStatusResponse").add("AggregatedSourceStatusList", this.hasAggregatedSourceStatusList() ? this.aggregatedSourceStatusList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregatedSourceStatusList": {
                return Optional.ofNullable(clazz.cast(this.aggregatedSourceStatusList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationAggregatorSourcesStatusResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationAggregatorSourcesStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<AggregatedSourceStatus> aggregatedSourceStatusList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationAggregatorSourcesStatusResponse model) {
            super(model);
            this.aggregatedSourceStatusList(model.aggregatedSourceStatusList);
            this.nextToken(model.nextToken);
        }

        public final List<AggregatedSourceStatus.Builder> getAggregatedSourceStatusList() {
            List<AggregatedSourceStatus.Builder> result = AggregatedSourceStatusListCopier.copyToBuilder(this.aggregatedSourceStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedSourceStatusList(Collection<AggregatedSourceStatus.BuilderImpl> aggregatedSourceStatusList) {
            this.aggregatedSourceStatusList = AggregatedSourceStatusListCopier.copyFromBuilder(aggregatedSourceStatusList);
        }

        @Override
        public final Builder aggregatedSourceStatusList(Collection<AggregatedSourceStatus> aggregatedSourceStatusList) {
            this.aggregatedSourceStatusList = AggregatedSourceStatusListCopier.copy(aggregatedSourceStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedSourceStatusList(AggregatedSourceStatus ... aggregatedSourceStatusList) {
            this.aggregatedSourceStatusList(Arrays.asList(aggregatedSourceStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedSourceStatusList(Consumer<AggregatedSourceStatus.Builder> ... aggregatedSourceStatusList) {
            this.aggregatedSourceStatusList(Stream.of(aggregatedSourceStatusList).map(c -> (AggregatedSourceStatus)((AggregatedSourceStatus.Builder)AggregatedSourceStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConfigurationAggregatorSourcesStatusResponse build() {
            return new DescribeConfigurationAggregatorSourcesStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationAggregatorSourcesStatusResponse> {
        public Builder aggregatedSourceStatusList(Collection<AggregatedSourceStatus> var1);

        public Builder aggregatedSourceStatusList(AggregatedSourceStatus ... var1);

        public Builder aggregatedSourceStatusList(Consumer<AggregatedSourceStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

