/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.RecordingGroup;
import software.amazon.awssdk.services.config.model.RecordingMode;
import software.amazon.awssdk.services.config.model.RecordingScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationRecorder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationRecorder> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ConfigurationRecorder.getter(ConfigurationRecorder::arn)).setter(ConfigurationRecorder.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ConfigurationRecorder.getter(ConfigurationRecorder::name)).setter(ConfigurationRecorder.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleARN").getter(ConfigurationRecorder.getter(ConfigurationRecorder::roleARN)).setter(ConfigurationRecorder.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleARN").build()}).build();
    private static final SdkField<RecordingGroup> RECORDING_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recordingGroup").getter(ConfigurationRecorder.getter(ConfigurationRecorder::recordingGroup)).setter(ConfigurationRecorder.setter(Builder::recordingGroup)).constructor(RecordingGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingGroup").build()}).build();
    private static final SdkField<RecordingMode> RECORDING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recordingMode").getter(ConfigurationRecorder.getter(ConfigurationRecorder::recordingMode)).setter(ConfigurationRecorder.setter(Builder::recordingMode)).constructor(RecordingMode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingMode").build()}).build();
    private static final SdkField<String> RECORDING_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingScope").getter(ConfigurationRecorder.getter(ConfigurationRecorder::recordingScopeAsString)).setter(ConfigurationRecorder.setter(Builder::recordingScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingScope").build()}).build();
    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("servicePrincipal").getter(ConfigurationRecorder.getter(ConfigurationRecorder::servicePrincipal)).setter(ConfigurationRecorder.setter(Builder::servicePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servicePrincipal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, ROLE_ARN_FIELD, RECORDING_GROUP_FIELD, RECORDING_MODE_FIELD, RECORDING_SCOPE_FIELD, SERVICE_PRINCIPAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("roleARN", ROLE_ARN_FIELD);
            this.put("recordingGroup", RECORDING_GROUP_FIELD);
            this.put("recordingMode", RECORDING_MODE_FIELD);
            this.put("recordingScope", RECORDING_SCOPE_FIELD);
            this.put("servicePrincipal", SERVICE_PRINCIPAL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String roleARN;
    private final RecordingGroup recordingGroup;
    private final RecordingMode recordingMode;
    private final String recordingScope;
    private final String servicePrincipal;

    private ConfigurationRecorder(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.roleARN = builder.roleARN;
        this.recordingGroup = builder.recordingGroup;
        this.recordingMode = builder.recordingMode;
        this.recordingScope = builder.recordingScope;
        this.servicePrincipal = builder.servicePrincipal;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final RecordingGroup recordingGroup() {
        return this.recordingGroup;
    }

    public final RecordingMode recordingMode() {
        return this.recordingMode;
    }

    public final RecordingScope recordingScope() {
        return RecordingScope.fromValue(this.recordingScope);
    }

    public final String recordingScopeAsString() {
        return this.recordingScope;
    }

    public final String servicePrincipal() {
        return this.servicePrincipal;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePrincipal());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorder)) {
            return false;
        }
        ConfigurationRecorder other = (ConfigurationRecorder)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.recordingGroup(), other.recordingGroup()) && Objects.equals(this.recordingMode(), other.recordingMode()) && Objects.equals(this.recordingScopeAsString(), other.recordingScopeAsString()) && Objects.equals(this.servicePrincipal(), other.servicePrincipal());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationRecorder").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("RoleARN", (Object)this.roleARN()).add("RecordingGroup", (Object)this.recordingGroup()).add("RecordingMode", (Object)this.recordingMode()).add("RecordingScope", (Object)this.recordingScopeAsString()).add("ServicePrincipal", (Object)this.servicePrincipal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "roleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "recordingGroup": {
                return Optional.ofNullable(clazz.cast(this.recordingGroup()));
            }
            case "recordingMode": {
                return Optional.ofNullable(clazz.cast(this.recordingMode()));
            }
            case "recordingScope": {
                return Optional.ofNullable(clazz.cast(this.recordingScopeAsString()));
            }
            case "servicePrincipal": {
                return Optional.ofNullable(clazz.cast(this.servicePrincipal()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorder, T> g) {
        return obj -> g.apply((ConfigurationRecorder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String roleARN;
        private RecordingGroup recordingGroup;
        private RecordingMode recordingMode;
        private String recordingScope;
        private String servicePrincipal;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorder model) {
            this.arn(model.arn);
            this.name(model.name);
            this.roleARN(model.roleARN);
            this.recordingGroup(model.recordingGroup);
            this.recordingMode(model.recordingMode);
            this.recordingScope(model.recordingScope);
            this.servicePrincipal(model.servicePrincipal);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final RecordingGroup.Builder getRecordingGroup() {
            return this.recordingGroup != null ? this.recordingGroup.toBuilder() : null;
        }

        public final void setRecordingGroup(RecordingGroup.BuilderImpl recordingGroup) {
            this.recordingGroup = recordingGroup != null ? recordingGroup.build() : null;
        }

        @Override
        public final Builder recordingGroup(RecordingGroup recordingGroup) {
            this.recordingGroup = recordingGroup;
            return this;
        }

        public final RecordingMode.Builder getRecordingMode() {
            return this.recordingMode != null ? this.recordingMode.toBuilder() : null;
        }

        public final void setRecordingMode(RecordingMode.BuilderImpl recordingMode) {
            this.recordingMode = recordingMode != null ? recordingMode.build() : null;
        }

        @Override
        public final Builder recordingMode(RecordingMode recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        public final String getRecordingScope() {
            return this.recordingScope;
        }

        public final void setRecordingScope(String recordingScope) {
            this.recordingScope = recordingScope;
        }

        @Override
        public final Builder recordingScope(String recordingScope) {
            this.recordingScope = recordingScope;
            return this;
        }

        @Override
        public final Builder recordingScope(RecordingScope recordingScope) {
            this.recordingScope(recordingScope == null ? null : recordingScope.toString());
            return this;
        }

        public final String getServicePrincipal() {
            return this.servicePrincipal;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public ConfigurationRecorder build() {
            return new ConfigurationRecorder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationRecorder> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder roleARN(String var1);

        public Builder recordingGroup(RecordingGroup var1);

        default public Builder recordingGroup(Consumer<RecordingGroup.Builder> recordingGroup) {
            return this.recordingGroup((RecordingGroup)((RecordingGroup.Builder)RecordingGroup.builder().applyMutation(recordingGroup)).build());
        }

        public Builder recordingMode(RecordingMode var1);

        default public Builder recordingMode(Consumer<RecordingMode.Builder> recordingMode) {
            return this.recordingMode((RecordingMode)((RecordingMode.Builder)RecordingMode.builder().applyMutation(recordingMode)).build());
        }

        public Builder recordingScope(String var1);

        public Builder recordingScope(RecordingScope var1);

        public Builder servicePrincipal(String var1);
    }
}

