/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAggregateResourceConfigRequest extends ConfigRequest implements
        ToCopyableBuilder<BatchGetAggregateResourceConfigRequest.Builder, BatchGetAggregateResourceConfigRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(BatchGetAggregateResourceConfigRequest::configurationAggregatorName))
            .setter(setter(Builder::configurationAggregatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName")
                    .build()).build();

    private static final SdkField<List<AggregateResourceIdentifier>> RESOURCE_IDENTIFIERS_FIELD = SdkField
            .<List<AggregateResourceIdentifier>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetAggregateResourceConfigRequest::resourceIdentifiers))
            .setter(setter(Builder::resourceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregateResourceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregateResourceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_AGGREGATOR_NAME_FIELD, RESOURCE_IDENTIFIERS_FIELD));

    private final String configurationAggregatorName;

    private final List<AggregateResourceIdentifier> resourceIdentifiers;

    private BatchGetAggregateResourceConfigRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.resourceIdentifiers = builder.resourceIdentifiers;
    }

    /**
     * <p>
     * The name of the configuration aggregator.
     * </p>
     * 
     * @return The name of the configuration aggregator.
     */
    public String configurationAggregatorName() {
        return configurationAggregatorName;
    }

    /**
     * <p>
     * A list of aggregate ResourceIdentifiers objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of aggregate ResourceIdentifiers objects.
     */
    public List<AggregateResourceIdentifier> resourceIdentifiers() {
        return resourceIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifiers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAggregateResourceConfigRequest)) {
            return false;
        }
        BatchGetAggregateResourceConfigRequest other = (BatchGetAggregateResourceConfigRequest) obj;
        return Objects.equals(configurationAggregatorName(), other.configurationAggregatorName())
                && Objects.equals(resourceIdentifiers(), other.resourceIdentifiers());
    }

    @Override
    public String toString() {
        return ToString.builder("BatchGetAggregateResourceConfigRequest")
                .add("ConfigurationAggregatorName", configurationAggregatorName())
                .add("ResourceIdentifiers", resourceIdentifiers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorName":
            return Optional.ofNullable(clazz.cast(configurationAggregatorName()));
        case "ResourceIdentifiers":
            return Optional.ofNullable(clazz.cast(resourceIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAggregateResourceConfigRequest, T> g) {
        return obj -> g.apply((BatchGetAggregateResourceConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetAggregateResourceConfigRequest> {
        /**
         * <p>
         * The name of the configuration aggregator.
         * </p>
         * 
         * @param configurationAggregatorName
         *        The name of the configuration aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorName(String configurationAggregatorName);

        /**
         * <p>
         * A list of aggregate ResourceIdentifiers objects.
         * </p>
         * 
         * @param resourceIdentifiers
         *        A list of aggregate ResourceIdentifiers objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers);

        /**
         * <p>
         * A list of aggregate ResourceIdentifiers objects.
         * </p>
         * 
         * @param resourceIdentifiers
         *        A list of aggregate ResourceIdentifiers objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(AggregateResourceIdentifier... resourceIdentifiers);

        /**
         * <p>
         * A list of aggregate ResourceIdentifiers objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AggregateResourceIdentifier>.Builder}
         * avoiding the need to create one manually via {@link List<AggregateResourceIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregateResourceIdentifier>.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceIdentifiers(List<AggregateResourceIdentifier>)}.
         * 
         * @param resourceIdentifiers
         *        a consumer that will call methods on {@link List<AggregateResourceIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifiers(List<AggregateResourceIdentifier>)
         */
        Builder resourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder>... resourceIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationAggregatorName;

        private List<AggregateResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAggregateResourceConfigRequest model) {
            super(model);
            configurationAggregatorName(model.configurationAggregatorName);
            resourceIdentifiers(model.resourceIdentifiers);
        }

        public final String getConfigurationAggregatorName() {
            return configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        public final Collection<AggregateResourceIdentifier.Builder> getResourceIdentifiers() {
            return resourceIdentifiers != null ? resourceIdentifiers.stream().map(AggregateResourceIdentifier::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(AggregateResourceIdentifier... resourceIdentifiers) {
            resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder>... resourceIdentifiers) {
            resourceIdentifiers(Stream.of(resourceIdentifiers)
                    .map(c -> AggregateResourceIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceIdentifiers(Collection<AggregateResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersListCopier.copyFromBuilder(resourceIdentifiers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetAggregateResourceConfigRequest build() {
            return new BatchGetAggregateResourceConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
