/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetResourceConfigResponse extends ConfigResponse implements
        ToCopyableBuilder<BatchGetResourceConfigResponse.Builder, BatchGetResourceConfigResponse> {
    private static final SdkField<List<BaseConfigurationItem>> BASE_CONFIGURATION_ITEMS_FIELD = SdkField
            .<List<BaseConfigurationItem>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetResourceConfigResponse::baseConfigurationItems))
            .setter(setter(Builder::baseConfigurationItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseConfigurationItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BaseConfigurationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BaseConfigurationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceKey>> UNPROCESSED_RESOURCE_KEYS_FIELD = SdkField
            .<List<ResourceKey>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetResourceConfigResponse::unprocessedResourceKeys))
            .setter(setter(Builder::unprocessedResourceKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedResourceKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BASE_CONFIGURATION_ITEMS_FIELD, UNPROCESSED_RESOURCE_KEYS_FIELD));

    private final List<BaseConfigurationItem> baseConfigurationItems;

    private final List<ResourceKey> unprocessedResourceKeys;

    private BatchGetResourceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.baseConfigurationItems = builder.baseConfigurationItems;
        this.unprocessedResourceKeys = builder.unprocessedResourceKeys;
    }

    /**
     * <p>
     * A list that contains the current configuration of one or more resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains the current configuration of one or more resources.
     */
    public List<BaseConfigurationItem> baseConfigurationItems() {
        return baseConfigurationItems;
    }

    /**
     * <p>
     * A list of resource keys that were not processed with the current response. The unprocessesResourceKeys value is
     * in the same form as ResourceKeys, so the value can be directly provided to a subsequent BatchGetResourceConfig
     * operation. If there are no unprocessed resource keys, the response contains an empty unprocessedResourceKeys
     * list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of resource keys that were not processed with the current response. The unprocessesResourceKeys
     *         value is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
     *         BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an
     *         empty unprocessedResourceKeys list.
     */
    public List<ResourceKey> unprocessedResourceKeys() {
        return unprocessedResourceKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseConfigurationItems());
        hashCode = 31 * hashCode + Objects.hashCode(unprocessedResourceKeys());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetResourceConfigResponse)) {
            return false;
        }
        BatchGetResourceConfigResponse other = (BatchGetResourceConfigResponse) obj;
        return Objects.equals(baseConfigurationItems(), other.baseConfigurationItems())
                && Objects.equals(unprocessedResourceKeys(), other.unprocessedResourceKeys());
    }

    @Override
    public String toString() {
        return ToString.builder("BatchGetResourceConfigResponse").add("BaseConfigurationItems", baseConfigurationItems())
                .add("UnprocessedResourceKeys", unprocessedResourceKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baseConfigurationItems":
            return Optional.ofNullable(clazz.cast(baseConfigurationItems()));
        case "unprocessedResourceKeys":
            return Optional.ofNullable(clazz.cast(unprocessedResourceKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetResourceConfigResponse, T> g) {
        return obj -> g.apply((BatchGetResourceConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetResourceConfigResponse> {
        /**
         * <p>
         * A list that contains the current configuration of one or more resources.
         * </p>
         * 
         * @param baseConfigurationItems
         *        A list that contains the current configuration of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems);

        /**
         * <p>
         * A list that contains the current configuration of one or more resources.
         * </p>
         * 
         * @param baseConfigurationItems
         *        A list that contains the current configuration of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseConfigurationItems(BaseConfigurationItem... baseConfigurationItems);

        /**
         * <p>
         * A list that contains the current configuration of one or more resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BaseConfigurationItem>.Builder} avoiding
         * the need to create one manually via {@link List<BaseConfigurationItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BaseConfigurationItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #baseConfigurationItems(List<BaseConfigurationItem>)}.
         * 
         * @param baseConfigurationItems
         *        a consumer that will call methods on {@link List<BaseConfigurationItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baseConfigurationItems(List<BaseConfigurationItem>)
         */
        Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder>... baseConfigurationItems);

        /**
         * <p>
         * A list of resource keys that were not processed with the current response. The unprocessesResourceKeys value
         * is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
         * BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an empty
         * unprocessedResourceKeys list.
         * </p>
         * 
         * @param unprocessedResourceKeys
         *        A list of resource keys that were not processed with the current response. The unprocessesResourceKeys
         *        value is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
         *        BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an
         *        empty unprocessedResourceKeys list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedResourceKeys(Collection<ResourceKey> unprocessedResourceKeys);

        /**
         * <p>
         * A list of resource keys that were not processed with the current response. The unprocessesResourceKeys value
         * is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
         * BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an empty
         * unprocessedResourceKeys list.
         * </p>
         * 
         * @param unprocessedResourceKeys
         *        A list of resource keys that were not processed with the current response. The unprocessesResourceKeys
         *        value is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
         *        BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an
         *        empty unprocessedResourceKeys list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedResourceKeys(ResourceKey... unprocessedResourceKeys);

        /**
         * <p>
         * A list of resource keys that were not processed with the current response. The unprocessesResourceKeys value
         * is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
         * BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an empty
         * unprocessedResourceKeys list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceKey>.Builder} avoiding the need to
         * create one manually via {@link List<ResourceKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #unprocessedResourceKeys(List<ResourceKey>)}.
         * 
         * @param unprocessedResourceKeys
         *        a consumer that will call methods on {@link List<ResourceKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedResourceKeys(List<ResourceKey>)
         */
        Builder unprocessedResourceKeys(Consumer<ResourceKey.Builder>... unprocessedResourceKeys);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<BaseConfigurationItem> baseConfigurationItems = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceKey> unprocessedResourceKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetResourceConfigResponse model) {
            super(model);
            baseConfigurationItems(model.baseConfigurationItems);
            unprocessedResourceKeys(model.unprocessedResourceKeys);
        }

        public final Collection<BaseConfigurationItem.Builder> getBaseConfigurationItems() {
            return baseConfigurationItems != null ? baseConfigurationItems.stream().map(BaseConfigurationItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder baseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copy(baseConfigurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(BaseConfigurationItem... baseConfigurationItems) {
            baseConfigurationItems(Arrays.asList(baseConfigurationItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder>... baseConfigurationItems) {
            baseConfigurationItems(Stream.of(baseConfigurationItems)
                    .map(c -> BaseConfigurationItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBaseConfigurationItems(Collection<BaseConfigurationItem.BuilderImpl> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copyFromBuilder(baseConfigurationItems);
        }

        public final Collection<ResourceKey.Builder> getUnprocessedResourceKeys() {
            return unprocessedResourceKeys != null ? unprocessedResourceKeys.stream().map(ResourceKey::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedResourceKeys(Collection<ResourceKey> unprocessedResourceKeys) {
            this.unprocessedResourceKeys = ResourceKeysCopier.copy(unprocessedResourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceKeys(ResourceKey... unprocessedResourceKeys) {
            unprocessedResourceKeys(Arrays.asList(unprocessedResourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceKeys(Consumer<ResourceKey.Builder>... unprocessedResourceKeys) {
            unprocessedResourceKeys(Stream.of(unprocessedResourceKeys).map(c -> ResourceKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedResourceKeys(Collection<ResourceKey.BuilderImpl> unprocessedResourceKeys) {
            this.unprocessedResourceKeys = ResourceKeysCopier.copyFromBuilder(unprocessedResourceKeys);
        }

        @Override
        public BatchGetResourceConfigResponse build() {
            return new BatchGetResourceConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
