/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the recording of configuration changes of an AWS resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationRecorder implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationRecorder.Builder, ConfigurationRecorder> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationRecorder::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationRecorder::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleARN").build()).build();

    private static final SdkField<RecordingGroup> RECORDING_GROUP_FIELD = SdkField
            .<RecordingGroup> builder(MarshallingType.SDK_POJO).getter(getter(ConfigurationRecorder::recordingGroup))
            .setter(setter(Builder::recordingGroup)).constructor(RecordingGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_ARN_FIELD,
            RECORDING_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String roleARN;

    private final RecordingGroup recordingGroup;

    private ConfigurationRecorder(BuilderImpl builder) {
        this.name = builder.name;
        this.roleARN = builder.roleARN;
        this.recordingGroup = builder.recordingGroup;
    }

    /**
     * <p>
     * The name of the recorder. By default, AWS Config automatically assigns the name "default" when creating the
     * configuration recorder. You cannot change the assigned name.
     * </p>
     * 
     * @return The name of the recorder. By default, AWS Config automatically assigns the name "default" when creating
     *         the configuration recorder. You cannot change the assigned name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources associated with the account.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources associated with the
     *         account.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Specifies the types of AWS resources for which AWS Config records configuration changes.
     * </p>
     * 
     * @return Specifies the types of AWS resources for which AWS Config records configuration changes.
     */
    public RecordingGroup recordingGroup() {
        return recordingGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(recordingGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorder)) {
            return false;
        }
        ConfigurationRecorder other = (ConfigurationRecorder) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(recordingGroup(), other.recordingGroup());
    }

    @Override
    public String toString() {
        return ToString.builder("ConfigurationRecorder").add("Name", name()).add("RoleARN", roleARN())
                .add("RecordingGroup", recordingGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "recordingGroup":
            return Optional.ofNullable(clazz.cast(recordingGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorder, T> g) {
        return obj -> g.apply((ConfigurationRecorder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationRecorder> {
        /**
         * <p>
         * The name of the recorder. By default, AWS Config automatically assigns the name "default" when creating the
         * configuration recorder. You cannot change the assigned name.
         * </p>
         * 
         * @param name
         *        The name of the recorder. By default, AWS Config automatically assigns the name "default" when
         *        creating the configuration recorder. You cannot change the assigned name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources associated with the account.
         * </p>
         * 
         * @param roleARN
         *        Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources associated with the
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Specifies the types of AWS resources for which AWS Config records configuration changes.
         * </p>
         * 
         * @param recordingGroup
         *        Specifies the types of AWS resources for which AWS Config records configuration changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingGroup(RecordingGroup recordingGroup);

        /**
         * <p>
         * Specifies the types of AWS resources for which AWS Config records configuration changes.
         * </p>
         * This is a convenience that creates an instance of the {@link RecordingGroup.Builder} avoiding the need to
         * create one manually via {@link RecordingGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecordingGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #recordingGroup(RecordingGroup)}.
         * 
         * @param recordingGroup
         *        a consumer that will call methods on {@link RecordingGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordingGroup(RecordingGroup)
         */
        default Builder recordingGroup(Consumer<RecordingGroup.Builder> recordingGroup) {
            return recordingGroup(RecordingGroup.builder().applyMutation(recordingGroup).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String roleARN;

        private RecordingGroup recordingGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorder model) {
            name(model.name);
            roleARN(model.roleARN);
            recordingGroup(model.recordingGroup);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final RecordingGroup.Builder getRecordingGroup() {
            return recordingGroup != null ? recordingGroup.toBuilder() : null;
        }

        @Override
        public final Builder recordingGroup(RecordingGroup recordingGroup) {
            this.recordingGroup = recordingGroup;
            return this;
        }

        public final void setRecordingGroup(RecordingGroup.BuilderImpl recordingGroup) {
            this.recordingGroup = recordingGroup != null ? recordingGroup.build() : null;
        }

        @Override
        public ConfigurationRecorder build() {
            return new ConfigurationRecorder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
