/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComplianceByConfigRuleResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeComplianceByConfigRuleResponse.Builder, DescribeComplianceByConfigRuleResponse> {
    private static final SdkField<List<ComplianceByConfigRule>> COMPLIANCE_BY_CONFIG_RULES_FIELD = SdkField
            .<List<ComplianceByConfigRule>> builder(MarshallingType.LIST)
            .getter(getter(DescribeComplianceByConfigRuleResponse::complianceByConfigRules))
            .setter(setter(Builder::complianceByConfigRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceByConfigRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComplianceByConfigRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComplianceByConfigRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeComplianceByConfigRuleResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPLIANCE_BY_CONFIG_RULES_FIELD, NEXT_TOKEN_FIELD));

    private final List<ComplianceByConfigRule> complianceByConfigRules;

    private final String nextToken;

    private DescribeComplianceByConfigRuleResponse(BuilderImpl builder) {
        super(builder);
        this.complianceByConfigRules = builder.complianceByConfigRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Indicates whether each of the specified AWS Config rules is compliant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Indicates whether each of the specified AWS Config rules is compliant.
     */
    public List<ComplianceByConfigRule> complianceByConfigRules() {
        return complianceByConfigRules;
    }

    /**
     * <p>
     * The string that you use in a subsequent request to get the next page of results in a paginated response.
     * </p>
     * 
     * @return The string that you use in a subsequent request to get the next page of results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceByConfigRules());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByConfigRuleResponse)) {
            return false;
        }
        DescribeComplianceByConfigRuleResponse other = (DescribeComplianceByConfigRuleResponse) obj;
        return Objects.equals(complianceByConfigRules(), other.complianceByConfigRules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeComplianceByConfigRuleResponse")
                .add("ComplianceByConfigRules", complianceByConfigRules()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceByConfigRules":
            return Optional.ofNullable(clazz.cast(complianceByConfigRules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComplianceByConfigRuleResponse, T> g) {
        return obj -> g.apply((DescribeComplianceByConfigRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComplianceByConfigRuleResponse> {
        /**
         * <p>
         * Indicates whether each of the specified AWS Config rules is compliant.
         * </p>
         * 
         * @param complianceByConfigRules
         *        Indicates whether each of the specified AWS Config rules is compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceByConfigRules(Collection<ComplianceByConfigRule> complianceByConfigRules);

        /**
         * <p>
         * Indicates whether each of the specified AWS Config rules is compliant.
         * </p>
         * 
         * @param complianceByConfigRules
         *        Indicates whether each of the specified AWS Config rules is compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceByConfigRules(ComplianceByConfigRule... complianceByConfigRules);

        /**
         * <p>
         * Indicates whether each of the specified AWS Config rules is compliant.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComplianceByConfigRule>.Builder} avoiding
         * the need to create one manually via {@link List<ComplianceByConfigRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComplianceByConfigRule>.Builder#build()} is called
         * immediately and its result is passed to {@link #complianceByConfigRules(List<ComplianceByConfigRule>)}.
         * 
         * @param complianceByConfigRules
         *        a consumer that will call methods on {@link List<ComplianceByConfigRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceByConfigRules(List<ComplianceByConfigRule>)
         */
        Builder complianceByConfigRules(Consumer<ComplianceByConfigRule.Builder>... complianceByConfigRules);

        /**
         * <p>
         * The string that you use in a subsequent request to get the next page of results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The string that you use in a subsequent request to get the next page of results in a paginated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ComplianceByConfigRule> complianceByConfigRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByConfigRuleResponse model) {
            super(model);
            complianceByConfigRules(model.complianceByConfigRules);
            nextToken(model.nextToken);
        }

        public final Collection<ComplianceByConfigRule.Builder> getComplianceByConfigRules() {
            return complianceByConfigRules != null ? complianceByConfigRules.stream().map(ComplianceByConfigRule::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder complianceByConfigRules(Collection<ComplianceByConfigRule> complianceByConfigRules) {
            this.complianceByConfigRules = ComplianceByConfigRulesCopier.copy(complianceByConfigRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByConfigRules(ComplianceByConfigRule... complianceByConfigRules) {
            complianceByConfigRules(Arrays.asList(complianceByConfigRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByConfigRules(Consumer<ComplianceByConfigRule.Builder>... complianceByConfigRules) {
            complianceByConfigRules(Stream.of(complianceByConfigRules)
                    .map(c -> ComplianceByConfigRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceByConfigRules(Collection<ComplianceByConfigRule.BuilderImpl> complianceByConfigRules) {
            this.complianceByConfigRules = ComplianceByConfigRulesCopier.copyFromBuilder(complianceByConfigRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComplianceByConfigRuleResponse build() {
            return new DescribeComplianceByConfigRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
