/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComplianceSummaryByResourceTypeResponse extends ConfigResponse implements
        ToCopyableBuilder<GetComplianceSummaryByResourceTypeResponse.Builder, GetComplianceSummaryByResourceTypeResponse> {
    private static final SdkField<List<ComplianceSummaryByResourceType>> COMPLIANCE_SUMMARIES_BY_RESOURCE_TYPE_FIELD = SdkField
            .<List<ComplianceSummaryByResourceType>> builder(MarshallingType.LIST)
            .getter(getter(GetComplianceSummaryByResourceTypeResponse::complianceSummariesByResourceType))
            .setter(setter(Builder::complianceSummariesByResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummariesByResourceType")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComplianceSummaryByResourceType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComplianceSummaryByResourceType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COMPLIANCE_SUMMARIES_BY_RESOURCE_TYPE_FIELD));

    private final List<ComplianceSummaryByResourceType> complianceSummariesByResourceType;

    private GetComplianceSummaryByResourceTypeResponse(BuilderImpl builder) {
        super(builder);
        this.complianceSummariesByResourceType = builder.complianceSummariesByResourceType;
    }

    /**
     * <p>
     * The number of resources that are compliant and the number that are noncompliant. If one or more resource types
     * were provided with the request, the numbers are returned for each resource type. The maximum number returned is
     * 100.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The number of resources that are compliant and the number that are noncompliant. If one or more resource
     *         types were provided with the request, the numbers are returned for each resource type. The maximum number
     *         returned is 100.
     */
    public List<ComplianceSummaryByResourceType> complianceSummariesByResourceType() {
        return complianceSummariesByResourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceSummariesByResourceType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceSummaryByResourceTypeResponse)) {
            return false;
        }
        GetComplianceSummaryByResourceTypeResponse other = (GetComplianceSummaryByResourceTypeResponse) obj;
        return Objects.equals(complianceSummariesByResourceType(), other.complianceSummariesByResourceType());
    }

    @Override
    public String toString() {
        return ToString.builder("GetComplianceSummaryByResourceTypeResponse")
                .add("ComplianceSummariesByResourceType", complianceSummariesByResourceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceSummariesByResourceType":
            return Optional.ofNullable(clazz.cast(complianceSummariesByResourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceSummaryByResourceTypeResponse, T> g) {
        return obj -> g.apply((GetComplianceSummaryByResourceTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetComplianceSummaryByResourceTypeResponse> {
        /**
         * <p>
         * The number of resources that are compliant and the number that are noncompliant. If one or more resource
         * types were provided with the request, the numbers are returned for each resource type. The maximum number
         * returned is 100.
         * </p>
         * 
         * @param complianceSummariesByResourceType
         *        The number of resources that are compliant and the number that are noncompliant. If one or more
         *        resource types were provided with the request, the numbers are returned for each resource type. The
         *        maximum number returned is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummariesByResourceType(Collection<ComplianceSummaryByResourceType> complianceSummariesByResourceType);

        /**
         * <p>
         * The number of resources that are compliant and the number that are noncompliant. If one or more resource
         * types were provided with the request, the numbers are returned for each resource type. The maximum number
         * returned is 100.
         * </p>
         * 
         * @param complianceSummariesByResourceType
         *        The number of resources that are compliant and the number that are noncompliant. If one or more
         *        resource types were provided with the request, the numbers are returned for each resource type. The
         *        maximum number returned is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummariesByResourceType(ComplianceSummaryByResourceType... complianceSummariesByResourceType);

        /**
         * <p>
         * The number of resources that are compliant and the number that are noncompliant. If one or more resource
         * types were provided with the request, the numbers are returned for each resource type. The maximum number
         * returned is 100.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComplianceSummaryByResourceType>.Builder}
         * avoiding the need to create one manually via {@link List<ComplianceSummaryByResourceType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComplianceSummaryByResourceType>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #complianceSummariesByResourceType(List<ComplianceSummaryByResourceType>)}.
         * 
         * @param complianceSummariesByResourceType
         *        a consumer that will call methods on {@link List<ComplianceSummaryByResourceType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceSummariesByResourceType(List<ComplianceSummaryByResourceType>)
         */
        Builder complianceSummariesByResourceType(
                Consumer<ComplianceSummaryByResourceType.Builder>... complianceSummariesByResourceType);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ComplianceSummaryByResourceType> complianceSummariesByResourceType = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceSummaryByResourceTypeResponse model) {
            super(model);
            complianceSummariesByResourceType(model.complianceSummariesByResourceType);
        }

        public final Collection<ComplianceSummaryByResourceType.Builder> getComplianceSummariesByResourceType() {
            return complianceSummariesByResourceType != null ? complianceSummariesByResourceType.stream()
                    .map(ComplianceSummaryByResourceType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder complianceSummariesByResourceType(
                Collection<ComplianceSummaryByResourceType> complianceSummariesByResourceType) {
            this.complianceSummariesByResourceType = ComplianceSummariesByResourceTypeCopier
                    .copy(complianceSummariesByResourceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSummariesByResourceType(
                ComplianceSummaryByResourceType... complianceSummariesByResourceType) {
            complianceSummariesByResourceType(Arrays.asList(complianceSummariesByResourceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSummariesByResourceType(
                Consumer<ComplianceSummaryByResourceType.Builder>... complianceSummariesByResourceType) {
            complianceSummariesByResourceType(Stream.of(complianceSummariesByResourceType)
                    .map(c -> ComplianceSummaryByResourceType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceSummariesByResourceType(
                Collection<ComplianceSummaryByResourceType.BuilderImpl> complianceSummariesByResourceType) {
            this.complianceSummariesByResourceType = ComplianceSummariesByResourceTypeCopier
                    .copyFromBuilder(complianceSummariesByResourceType);
        }

        @Override
        public GetComplianceSummaryByResourceTypeResponse build() {
            return new GetComplianceSummaryByResourceTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
