/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDiscoveredResourceCountsRequest extends ConfigRequest implements
        ToCopyableBuilder<GetDiscoveredResourceCountsRequest.Builder, GetDiscoveredResourceCountsRequest> {
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetDiscoveredResourceCountsRequest::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetDiscoveredResourceCountsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDiscoveredResourceCountsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPES_FIELD,
            LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> resourceTypes;

    private final Integer limit;

    private final String nextToken;

    private GetDiscoveredResourceCountsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceTypes = builder.resourceTypes;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The comma-separated list that specifies the resource types that you want AWS Config to return (for example,
     * <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).
     * </p>
     * <p>
     * If a value for <code>resourceTypes</code> is not specified, AWS Config returns all resource types that AWS Config
     * is recording in the region for your account.
     * </p>
     * <note>
     * <p>
     * If the configuration recorder is turned off, AWS Config returns an empty list of <a>ResourceCount</a> objects. If
     * the configuration recorder is not recording a specific resource type (for example, S3 buckets), that resource
     * type is not returned in the list of <a>ResourceCount</a> objects.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The comma-separated list that specifies the resource types that you want AWS Config to return (for
     *         example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p>
     *         <p>
     *         If a value for <code>resourceTypes</code> is not specified, AWS Config returns all resource types that
     *         AWS Config is recording in the region for your account.
     *         </p>
     *         <note>
     *         <p>
     *         If the configuration recorder is turned off, AWS Config returns an empty list of <a>ResourceCount</a>
     *         objects. If the configuration recorder is not recording a specific resource type (for example, S3
     *         buckets), that resource type is not returned in the list of <a>ResourceCount</a> objects.
     *         </p>
     */
    public List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The maximum number of <a>ResourceCount</a> objects returned on each page. The default is 100. You cannot specify
     * a number greater than 100. If you specify 0, AWS Config uses the default.
     * </p>
     * 
     * @return The maximum number of <a>ResourceCount</a> objects returned on each page. The default is 100. You cannot
     *         specify a number greater than 100. If you specify 0, AWS Config uses the default.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoveredResourceCountsRequest)) {
            return false;
        }
        GetDiscoveredResourceCountsRequest other = (GetDiscoveredResourceCountsRequest) obj;
        return Objects.equals(resourceTypes(), other.resourceTypes()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDiscoveredResourceCountsRequest").add("ResourceTypes", resourceTypes()).add("Limit", limit())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDiscoveredResourceCountsRequest, T> g) {
        return obj -> g.apply((GetDiscoveredResourceCountsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDiscoveredResourceCountsRequest> {
        /**
         * <p>
         * The comma-separated list that specifies the resource types that you want AWS Config to return (for example,
         * <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).
         * </p>
         * <p>
         * If a value for <code>resourceTypes</code> is not specified, AWS Config returns all resource types that AWS
         * Config is recording in the region for your account.
         * </p>
         * <note>
         * <p>
         * If the configuration recorder is turned off, AWS Config returns an empty list of <a>ResourceCount</a>
         * objects. If the configuration recorder is not recording a specific resource type (for example, S3 buckets),
         * that resource type is not returned in the list of <a>ResourceCount</a> objects.
         * </p>
         * </note>
         * 
         * @param resourceTypes
         *        The comma-separated list that specifies the resource types that you want AWS Config to return (for
         *        example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p>
         *        <p>
         *        If a value for <code>resourceTypes</code> is not specified, AWS Config returns all resource types that
         *        AWS Config is recording in the region for your account.
         *        </p>
         *        <note>
         *        <p>
         *        If the configuration recorder is turned off, AWS Config returns an empty list of <a>ResourceCount</a>
         *        objects. If the configuration recorder is not recording a specific resource type (for example, S3
         *        buckets), that resource type is not returned in the list of <a>ResourceCount</a> objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The comma-separated list that specifies the resource types that you want AWS Config to return (for example,
         * <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).
         * </p>
         * <p>
         * If a value for <code>resourceTypes</code> is not specified, AWS Config returns all resource types that AWS
         * Config is recording in the region for your account.
         * </p>
         * <note>
         * <p>
         * If the configuration recorder is turned off, AWS Config returns an empty list of <a>ResourceCount</a>
         * objects. If the configuration recorder is not recording a specific resource type (for example, S3 buckets),
         * that resource type is not returned in the list of <a>ResourceCount</a> objects.
         * </p>
         * </note>
         * 
         * @param resourceTypes
         *        The comma-separated list that specifies the resource types that you want AWS Config to return (for
         *        example, <code>"AWS::EC2::Instance"</code>, <code>"AWS::IAM::User"</code>).</p>
         *        <p>
         *        If a value for <code>resourceTypes</code> is not specified, AWS Config returns all resource types that
         *        AWS Config is recording in the region for your account.
         *        </p>
         *        <note>
         *        <p>
         *        If the configuration recorder is turned off, AWS Config returns an empty list of <a>ResourceCount</a>
         *        objects. If the configuration recorder is not recording a specific resource type (for example, S3
         *        buckets), that resource type is not returned in the list of <a>ResourceCount</a> objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The maximum number of <a>ResourceCount</a> objects returned on each page. The default is 100. You cannot
         * specify a number greater than 100. If you specify 0, AWS Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of <a>ResourceCount</a> objects returned on each page. The default is 100. You
         *        cannot specify a number greater than 100. If you specify 0, AWS Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiscoveredResourceCountsRequest model) {
            super(model);
            resourceTypes(model.resourceTypes);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final Collection<String> getResourceTypes() {
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDiscoveredResourceCountsRequest build() {
            return new GetDiscoveredResourceCountsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
