/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAggregateDiscoveredResourcesResponse extends ConfigResponse implements
        ToCopyableBuilder<ListAggregateDiscoveredResourcesResponse.Builder, ListAggregateDiscoveredResourcesResponse> {
    private static final SdkField<List<AggregateResourceIdentifier>> RESOURCE_IDENTIFIERS_FIELD = SdkField
            .<List<AggregateResourceIdentifier>> builder(MarshallingType.LIST)
            .getter(getter(ListAggregateDiscoveredResourcesResponse::resourceIdentifiers))
            .setter(setter(Builder::resourceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregateResourceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregateResourceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAggregateDiscoveredResourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AggregateResourceIdentifier> resourceIdentifiers;

    private final String nextToken;

    private ListAggregateDiscoveredResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Returns a list of <code>ResourceIdentifiers</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns a list of <code>ResourceIdentifiers</code> objects.
     */
    public List<AggregateResourceIdentifier> resourceIdentifiers() {
        return resourceIdentifiers;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAggregateDiscoveredResourcesResponse)) {
            return false;
        }
        ListAggregateDiscoveredResourcesResponse other = (ListAggregateDiscoveredResourcesResponse) obj;
        return Objects.equals(resourceIdentifiers(), other.resourceIdentifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListAggregateDiscoveredResourcesResponse").add("ResourceIdentifiers", resourceIdentifiers())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdentifiers":
            return Optional.ofNullable(clazz.cast(resourceIdentifiers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAggregateDiscoveredResourcesResponse, T> g) {
        return obj -> g.apply((ListAggregateDiscoveredResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAggregateDiscoveredResourcesResponse> {
        /**
         * <p>
         * Returns a list of <code>ResourceIdentifiers</code> objects.
         * </p>
         * 
         * @param resourceIdentifiers
         *        Returns a list of <code>ResourceIdentifiers</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers);

        /**
         * <p>
         * Returns a list of <code>ResourceIdentifiers</code> objects.
         * </p>
         * 
         * @param resourceIdentifiers
         *        Returns a list of <code>ResourceIdentifiers</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(AggregateResourceIdentifier... resourceIdentifiers);

        /**
         * <p>
         * Returns a list of <code>ResourceIdentifiers</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AggregateResourceIdentifier>.Builder}
         * avoiding the need to create one manually via {@link List<AggregateResourceIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregateResourceIdentifier>.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceIdentifiers(List<AggregateResourceIdentifier>)}.
         * 
         * @param resourceIdentifiers
         *        a consumer that will call methods on {@link List<AggregateResourceIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifiers(List<AggregateResourceIdentifier>)
         */
        Builder resourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder>... resourceIdentifiers);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<AggregateResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAggregateDiscoveredResourcesResponse model) {
            super(model);
            resourceIdentifiers(model.resourceIdentifiers);
            nextToken(model.nextToken);
        }

        public final Collection<AggregateResourceIdentifier.Builder> getResourceIdentifiers() {
            return resourceIdentifiers != null ? resourceIdentifiers.stream().map(AggregateResourceIdentifier::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = DiscoveredResourceIdentifierListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(AggregateResourceIdentifier... resourceIdentifiers) {
            resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder>... resourceIdentifiers) {
            resourceIdentifiers(Stream.of(resourceIdentifiers)
                    .map(c -> AggregateResourceIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceIdentifiers(Collection<AggregateResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = DiscoveredResourceIdentifierListCopier.copyFromBuilder(resourceIdentifiers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAggregateDiscoveredResourcesResponse build() {
            return new ListAggregateDiscoveredResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
