/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationConformancePackStatusesRequest extends ConfigRequest
        implements
        ToCopyableBuilder<DescribeOrganizationConformancePackStatusesRequest.Builder, DescribeOrganizationConformancePackStatusesRequest> {
    private static final SdkField<List<String>> ORGANIZATION_CONFORMANCE_PACK_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OrganizationConformancePackNames")
            .getter(getter(DescribeOrganizationConformancePackStatusesRequest::organizationConformancePackNames))
            .setter(setter(Builder::organizationConformancePackNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConformancePackNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeOrganizationConformancePackStatusesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeOrganizationConformancePackStatusesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFORMANCE_PACK_NAMES_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> organizationConformancePackNames;

    private final Integer limit;

    private final String nextToken;

    private DescribeOrganizationConformancePackStatusesRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConformancePackNames = builder.organizationConformancePackNames;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationConformancePackNames
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasOrganizationConformancePackNames() {
        return organizationConformancePackNames != null && !(organizationConformancePackNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of organization conformance packs for which you want status details. If you do not specify any names,
     * Config returns details for all your organization conformance packs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationConformancePackNames}
     * method.
     * </p>
     * 
     * @return The names of organization conformance packs for which you want status details. If you do not specify any
     *         names, Config returns details for all your organization conformance packs.
     */
    public final List<String> organizationConformancePackNames() {
        return organizationConformancePackNames;
    }

    /**
     * <p>
     * The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify a number,
     * Config uses the default. The default is 100.
     * </p>
     * 
     * @return The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify a
     *         number, Config uses the default. The default is 100.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasOrganizationConformancePackNames() ? organizationConformancePackNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConformancePackStatusesRequest)) {
            return false;
        }
        DescribeOrganizationConformancePackStatusesRequest other = (DescribeOrganizationConformancePackStatusesRequest) obj;
        return hasOrganizationConformancePackNames() == other.hasOrganizationConformancePackNames()
                && Objects.equals(organizationConformancePackNames(), other.organizationConformancePackNames())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeOrganizationConformancePackStatusesRequest")
                .add("OrganizationConformancePackNames",
                        hasOrganizationConformancePackNames() ? organizationConformancePackNames() : null).add("Limit", limit())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConformancePackNames":
            return Optional.ofNullable(clazz.cast(organizationConformancePackNames()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationConformancePackNames", ORGANIZATION_CONFORMANCE_PACK_NAMES_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConformancePackStatusesRequest, T> g) {
        return obj -> g.apply((DescribeOrganizationConformancePackStatusesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationConformancePackStatusesRequest> {
        /**
         * <p>
         * The names of organization conformance packs for which you want status details. If you do not specify any
         * names, Config returns details for all your organization conformance packs.
         * </p>
         * 
         * @param organizationConformancePackNames
         *        The names of organization conformance packs for which you want status details. If you do not specify
         *        any names, Config returns details for all your organization conformance packs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackNames(Collection<String> organizationConformancePackNames);

        /**
         * <p>
         * The names of organization conformance packs for which you want status details. If you do not specify any
         * names, Config returns details for all your organization conformance packs.
         * </p>
         * 
         * @param organizationConformancePackNames
         *        The names of organization conformance packs for which you want status details. If you do not specify
         *        any names, Config returns details for all your organization conformance packs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConformancePackNames(String... organizationConformancePackNames);

        /**
         * <p>
         * The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify a
         * number, Config uses the default. The default is 100.
         * </p>
         * 
         * @param limit
         *        The maximum number of OrganizationConformancePackStatuses returned on each page. If you do no specify
         *        a number, Config uses the default. The default is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> organizationConformancePackNames = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConformancePackStatusesRequest model) {
            super(model);
            organizationConformancePackNames(model.organizationConformancePackNames);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final Collection<String> getOrganizationConformancePackNames() {
            if (organizationConformancePackNames instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationConformancePackNames;
        }

        public final void setOrganizationConformancePackNames(Collection<String> organizationConformancePackNames) {
            this.organizationConformancePackNames = OrganizationConformancePackNamesCopier.copy(organizationConformancePackNames);
        }

        @Override
        public final Builder organizationConformancePackNames(Collection<String> organizationConformancePackNames) {
            this.organizationConformancePackNames = OrganizationConformancePackNamesCopier.copy(organizationConformancePackNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConformancePackNames(String... organizationConformancePackNames) {
            organizationConformancePackNames(Arrays.asList(organizationConformancePackNames));
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOrganizationConformancePackStatusesRequest build() {
            return new DescribeOrganizationConformancePackStatusesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
