/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns details of a resource evaluation based on the selected filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceEvaluationFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceEvaluationFilters.Builder, ResourceEvaluationFilters> {
    private static final SdkField<String> EVALUATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationMode").getter(getter(ResourceEvaluationFilters::evaluationModeAsString))
            .setter(setter(Builder::evaluationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMode").build()).build();

    private static final SdkField<TimeWindow> TIME_WINDOW_FIELD = SdkField.<TimeWindow> builder(MarshallingType.SDK_POJO)
            .memberName("TimeWindow").getter(getter(ResourceEvaluationFilters::timeWindow)).setter(setter(Builder::timeWindow))
            .constructor(TimeWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeWindow").build()).build();

    private static final SdkField<String> EVALUATION_CONTEXT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EvaluationContextIdentifier")
            .getter(getter(ResourceEvaluationFilters::evaluationContextIdentifier))
            .setter(setter(Builder::evaluationContextIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContextIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_MODE_FIELD,
            TIME_WINDOW_FIELD, EVALUATION_CONTEXT_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String evaluationMode;

    private final TimeWindow timeWindow;

    private final String evaluationContextIdentifier;

    private ResourceEvaluationFilters(BuilderImpl builder) {
        this.evaluationMode = builder.evaluationMode;
        this.timeWindow = builder.timeWindow;
        this.evaluationContextIdentifier = builder.evaluationContextIdentifier;
    }

    /**
     * <p>
     * Filters all resource evaluations results based on an evaluation mode.
     * </p>
     * <important>
     * <p>
     * Currently, <code>DECTECTIVE</code> is not supported as a valid value. Ignore other documentation stating
     * otherwise.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMode}
     * will return {@link EvaluationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationModeAsString}.
     * </p>
     * 
     * @return Filters all resource evaluations results based on an evaluation mode.</p> <important>
     *         <p>
     *         Currently, <code>DECTECTIVE</code> is not supported as a valid value. Ignore other documentation stating
     *         otherwise.
     *         </p>
     * @see EvaluationMode
     */
    public final EvaluationMode evaluationMode() {
        return EvaluationMode.fromValue(evaluationMode);
    }

    /**
     * <p>
     * Filters all resource evaluations results based on an evaluation mode.
     * </p>
     * <important>
     * <p>
     * Currently, <code>DECTECTIVE</code> is not supported as a valid value. Ignore other documentation stating
     * otherwise.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMode}
     * will return {@link EvaluationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationModeAsString}.
     * </p>
     * 
     * @return Filters all resource evaluations results based on an evaluation mode.</p> <important>
     *         <p>
     *         Currently, <code>DECTECTIVE</code> is not supported as a valid value. Ignore other documentation stating
     *         otherwise.
     *         </p>
     * @see EvaluationMode
     */
    public final String evaluationModeAsString() {
        return evaluationMode;
    }

    /**
     * <p>
     * Returns a <code>TimeWindow</code> object.
     * </p>
     * 
     * @return Returns a <code>TimeWindow</code> object.
     */
    public final TimeWindow timeWindow() {
        return timeWindow;
    }

    /**
     * <p>
     * Filters evaluations for a given infrastructure deployment. For example: CFN Stack.
     * </p>
     * 
     * @return Filters evaluations for a given infrastructure deployment. For example: CFN Stack.
     */
    public final String evaluationContextIdentifier() {
        return evaluationContextIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeWindow());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationContextIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceEvaluationFilters)) {
            return false;
        }
        ResourceEvaluationFilters other = (ResourceEvaluationFilters) obj;
        return Objects.equals(evaluationModeAsString(), other.evaluationModeAsString())
                && Objects.equals(timeWindow(), other.timeWindow())
                && Objects.equals(evaluationContextIdentifier(), other.evaluationContextIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceEvaluationFilters").add("EvaluationMode", evaluationModeAsString())
                .add("TimeWindow", timeWindow()).add("EvaluationContextIdentifier", evaluationContextIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationMode":
            return Optional.ofNullable(clazz.cast(evaluationModeAsString()));
        case "TimeWindow":
            return Optional.ofNullable(clazz.cast(timeWindow()));
        case "EvaluationContextIdentifier":
            return Optional.ofNullable(clazz.cast(evaluationContextIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EvaluationMode", EVALUATION_MODE_FIELD);
        map.put("TimeWindow", TIME_WINDOW_FIELD);
        map.put("EvaluationContextIdentifier", EVALUATION_CONTEXT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceEvaluationFilters, T> g) {
        return obj -> g.apply((ResourceEvaluationFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceEvaluationFilters> {
        /**
         * <p>
         * Filters all resource evaluations results based on an evaluation mode.
         * </p>
         * <important>
         * <p>
         * Currently, <code>DECTECTIVE</code> is not supported as a valid value. Ignore other documentation stating
         * otherwise.
         * </p>
         * </important>
         * 
         * @param evaluationMode
         *        Filters all resource evaluations results based on an evaluation mode.</p> <important>
         *        <p>
         *        Currently, <code>DECTECTIVE</code> is not supported as a valid value. Ignore other documentation
         *        stating otherwise.
         *        </p>
         * @see EvaluationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMode
         */
        Builder evaluationMode(String evaluationMode);

        /**
         * <p>
         * Filters all resource evaluations results based on an evaluation mode.
         * </p>
         * <important>
         * <p>
         * Currently, <code>DECTECTIVE</code> is not supported as a valid value. Ignore other documentation stating
         * otherwise.
         * </p>
         * </important>
         * 
         * @param evaluationMode
         *        Filters all resource evaluations results based on an evaluation mode.</p> <important>
         *        <p>
         *        Currently, <code>DECTECTIVE</code> is not supported as a valid value. Ignore other documentation
         *        stating otherwise.
         *        </p>
         * @see EvaluationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMode
         */
        Builder evaluationMode(EvaluationMode evaluationMode);

        /**
         * <p>
         * Returns a <code>TimeWindow</code> object.
         * </p>
         * 
         * @param timeWindow
         *        Returns a <code>TimeWindow</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeWindow(TimeWindow timeWindow);

        /**
         * <p>
         * Returns a <code>TimeWindow</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeWindow.Builder} avoiding the need to
         * create one manually via {@link TimeWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeWindow.Builder#build()} is called immediately and its result
         * is passed to {@link #timeWindow(TimeWindow)}.
         * 
         * @param timeWindow
         *        a consumer that will call methods on {@link TimeWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeWindow(TimeWindow)
         */
        default Builder timeWindow(Consumer<TimeWindow.Builder> timeWindow) {
            return timeWindow(TimeWindow.builder().applyMutation(timeWindow).build());
        }

        /**
         * <p>
         * Filters evaluations for a given infrastructure deployment. For example: CFN Stack.
         * </p>
         * 
         * @param evaluationContextIdentifier
         *        Filters evaluations for a given infrastructure deployment. For example: CFN Stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationContextIdentifier(String evaluationContextIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationMode;

        private TimeWindow timeWindow;

        private String evaluationContextIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceEvaluationFilters model) {
            evaluationMode(model.evaluationMode);
            timeWindow(model.timeWindow);
            evaluationContextIdentifier(model.evaluationContextIdentifier);
        }

        public final String getEvaluationMode() {
            return evaluationMode;
        }

        public final void setEvaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
        }

        @Override
        public final Builder evaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
            return this;
        }

        @Override
        public final Builder evaluationMode(EvaluationMode evaluationMode) {
            this.evaluationMode(evaluationMode == null ? null : evaluationMode.toString());
            return this;
        }

        public final TimeWindow.Builder getTimeWindow() {
            return timeWindow != null ? timeWindow.toBuilder() : null;
        }

        public final void setTimeWindow(TimeWindow.BuilderImpl timeWindow) {
            this.timeWindow = timeWindow != null ? timeWindow.build() : null;
        }

        @Override
        public final Builder timeWindow(TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public final String getEvaluationContextIdentifier() {
            return evaluationContextIdentifier;
        }

        public final void setEvaluationContextIdentifier(String evaluationContextIdentifier) {
            this.evaluationContextIdentifier = evaluationContextIdentifier;
        }

        @Override
        public final Builder evaluationContextIdentifier(String evaluationContextIdentifier) {
            this.evaluationContextIdentifier = evaluationContextIdentifier;
            return this;
        }

        @Override
        public ResourceEvaluationFilters build() {
            return new ResourceEvaluationFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
