/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object to filter service-linked configuration recorders in an aggregator based on the linked Amazon Web Services
 * service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregatorFilterServicePrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregatorFilterServicePrincipal.Builder, AggregatorFilterServicePrincipal> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AggregatorFilterServicePrincipal::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<String>> VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Value")
            .getter(getter(AggregatorFilterServicePrincipal::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<String> value;

    private AggregatorFilterServicePrincipal(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * The type of service principal filter to apply. <code>INCLUDE</code> specifies that the list of service principals
     * in the <code>Value</code> field will be aggregated and no other service principals will be filtered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AggregatorFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of service principal filter to apply. <code>INCLUDE</code> specifies that the list of service
     *         principals in the <code>Value</code> field will be aggregated and no other service principals will be
     *         filtered.
     * @see AggregatorFilterType
     */
    public final AggregatorFilterType type() {
        return AggregatorFilterType.fromValue(type);
    }

    /**
     * <p>
     * The type of service principal filter to apply. <code>INCLUDE</code> specifies that the list of service principals
     * in the <code>Value</code> field will be aggregated and no other service principals will be filtered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AggregatorFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of service principal filter to apply. <code>INCLUDE</code> specifies that the list of service
     *         principals in the <code>Value</code> field will be aggregated and no other service principals will be
     *         filtered.
     * @see AggregatorFilterType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Value property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasValue() {
        return value != null && !(value instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Comma-separated list of service principals for the linked Amazon Web Services services to filter your aggregated
     * service-linked configuration recorders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValue} method.
     * </p>
     * 
     * @return Comma-separated list of service principals for the linked Amazon Web Services services to filter your
     *         aggregated service-linked configuration recorders.
     */
    public final List<String> value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValue() ? value() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatorFilterServicePrincipal)) {
            return false;
        }
        AggregatorFilterServicePrincipal other = (AggregatorFilterServicePrincipal) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && hasValue() == other.hasValue()
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregatorFilterServicePrincipal").add("Type", typeAsString())
                .add("Value", hasValue() ? value() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregatorFilterServicePrincipal, T> g) {
        return obj -> g.apply((AggregatorFilterServicePrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregatorFilterServicePrincipal> {
        /**
         * <p>
         * The type of service principal filter to apply. <code>INCLUDE</code> specifies that the list of service
         * principals in the <code>Value</code> field will be aggregated and no other service principals will be
         * filtered.
         * </p>
         * 
         * @param type
         *        The type of service principal filter to apply. <code>INCLUDE</code> specifies that the list of service
         *        principals in the <code>Value</code> field will be aggregated and no other service principals will be
         *        filtered.
         * @see AggregatorFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregatorFilterType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of service principal filter to apply. <code>INCLUDE</code> specifies that the list of service
         * principals in the <code>Value</code> field will be aggregated and no other service principals will be
         * filtered.
         * </p>
         * 
         * @param type
         *        The type of service principal filter to apply. <code>INCLUDE</code> specifies that the list of service
         *        principals in the <code>Value</code> field will be aggregated and no other service principals will be
         *        filtered.
         * @see AggregatorFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregatorFilterType
         */
        Builder type(AggregatorFilterType type);

        /**
         * <p>
         * Comma-separated list of service principals for the linked Amazon Web Services services to filter your
         * aggregated service-linked configuration recorders.
         * </p>
         * 
         * @param value
         *        Comma-separated list of service principals for the linked Amazon Web Services services to filter your
         *        aggregated service-linked configuration recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Collection<String> value);

        /**
         * <p>
         * Comma-separated list of service principals for the linked Amazon Web Services services to filter your
         * aggregated service-linked configuration recorders.
         * </p>
         * 
         * @param value
         *        Comma-separated list of service principals for the linked Amazon Web Services services to filter your
         *        aggregated service-linked configuration recorders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String... value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<String> value = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatorFilterServicePrincipal model) {
            type(model.type);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AggregatorFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getValue() {
            if (value instanceof SdkAutoConstructList) {
                return null;
            }
            return value;
        }

        public final void setValue(Collection<String> value) {
            this.value = ServicePrincipalValueListCopier.copy(value);
        }

        @Override
        public final Builder value(Collection<String> value) {
            this.value = ServicePrincipalValueListCopier.copy(value);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder value(String... value) {
            value(Arrays.asList(value));
            return this;
        }

        @Override
        public AggregatorFilterServicePrincipal build() {
            return new AggregatorFilterServicePrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
