/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetResourceConfigResponse extends ConfigResponse implements
        ToCopyableBuilder<BatchGetResourceConfigResponse.Builder, BatchGetResourceConfigResponse> {
    private static final SdkField<List<BaseConfigurationItem>> BASE_CONFIGURATION_ITEMS_FIELD = SdkField
            .<List<BaseConfigurationItem>> builder(MarshallingType.LIST)
            .memberName("baseConfigurationItems")
            .getter(getter(BatchGetResourceConfigResponse::baseConfigurationItems))
            .setter(setter(Builder::baseConfigurationItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseConfigurationItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BaseConfigurationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BaseConfigurationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceKey>> UNPROCESSED_RESOURCE_KEYS_FIELD = SdkField
            .<List<ResourceKey>> builder(MarshallingType.LIST)
            .memberName("unprocessedResourceKeys")
            .getter(getter(BatchGetResourceConfigResponse::unprocessedResourceKeys))
            .setter(setter(Builder::unprocessedResourceKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedResourceKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BASE_CONFIGURATION_ITEMS_FIELD, UNPROCESSED_RESOURCE_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BaseConfigurationItem> baseConfigurationItems;

    private final List<ResourceKey> unprocessedResourceKeys;

    private BatchGetResourceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.baseConfigurationItems = builder.baseConfigurationItems;
        this.unprocessedResourceKeys = builder.unprocessedResourceKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the BaseConfigurationItems property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBaseConfigurationItems() {
        return baseConfigurationItems != null && !(baseConfigurationItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains the current configuration of one or more resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBaseConfigurationItems} method.
     * </p>
     * 
     * @return A list that contains the current configuration of one or more resources.
     */
    public final List<BaseConfigurationItem> baseConfigurationItems() {
        return baseConfigurationItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedResourceKeys property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnprocessedResourceKeys() {
        return unprocessedResourceKeys != null && !(unprocessedResourceKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource keys that were not processed with the current response. The unprocessesResourceKeys value is
     * in the same form as ResourceKeys, so the value can be directly provided to a subsequent BatchGetResourceConfig
     * operation. If there are no unprocessed resource keys, the response contains an empty unprocessedResourceKeys
     * list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedResourceKeys} method.
     * </p>
     * 
     * @return A list of resource keys that were not processed with the current response. The unprocessesResourceKeys
     *         value is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
     *         BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an
     *         empty unprocessedResourceKeys list.
     */
    public final List<ResourceKey> unprocessedResourceKeys() {
        return unprocessedResourceKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBaseConfigurationItems() ? baseConfigurationItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedResourceKeys() ? unprocessedResourceKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetResourceConfigResponse)) {
            return false;
        }
        BatchGetResourceConfigResponse other = (BatchGetResourceConfigResponse) obj;
        return hasBaseConfigurationItems() == other.hasBaseConfigurationItems()
                && Objects.equals(baseConfigurationItems(), other.baseConfigurationItems())
                && hasUnprocessedResourceKeys() == other.hasUnprocessedResourceKeys()
                && Objects.equals(unprocessedResourceKeys(), other.unprocessedResourceKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetResourceConfigResponse")
                .add("BaseConfigurationItems", hasBaseConfigurationItems() ? baseConfigurationItems() : null)
                .add("UnprocessedResourceKeys", hasUnprocessedResourceKeys() ? unprocessedResourceKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baseConfigurationItems":
            return Optional.ofNullable(clazz.cast(baseConfigurationItems()));
        case "unprocessedResourceKeys":
            return Optional.ofNullable(clazz.cast(unprocessedResourceKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("baseConfigurationItems", BASE_CONFIGURATION_ITEMS_FIELD);
        map.put("unprocessedResourceKeys", UNPROCESSED_RESOURCE_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetResourceConfigResponse, T> g) {
        return obj -> g.apply((BatchGetResourceConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetResourceConfigResponse> {
        /**
         * <p>
         * A list that contains the current configuration of one or more resources.
         * </p>
         * 
         * @param baseConfigurationItems
         *        A list that contains the current configuration of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems);

        /**
         * <p>
         * A list that contains the current configuration of one or more resources.
         * </p>
         * 
         * @param baseConfigurationItems
         *        A list that contains the current configuration of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseConfigurationItems(BaseConfigurationItem... baseConfigurationItems);

        /**
         * <p>
         * A list that contains the current configuration of one or more resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.BaseConfigurationItem.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.config.model.BaseConfigurationItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.BaseConfigurationItem.Builder#build()} is called
         * immediately and its result is passed to {@link #baseConfigurationItems(List<BaseConfigurationItem>)}.
         * 
         * @param baseConfigurationItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.BaseConfigurationItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baseConfigurationItems(java.util.Collection<BaseConfigurationItem>)
         */
        Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder>... baseConfigurationItems);

        /**
         * <p>
         * A list of resource keys that were not processed with the current response. The unprocessesResourceKeys value
         * is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
         * BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an empty
         * unprocessedResourceKeys list.
         * </p>
         * 
         * @param unprocessedResourceKeys
         *        A list of resource keys that were not processed with the current response. The unprocessesResourceKeys
         *        value is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
         *        BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an
         *        empty unprocessedResourceKeys list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedResourceKeys(Collection<ResourceKey> unprocessedResourceKeys);

        /**
         * <p>
         * A list of resource keys that were not processed with the current response. The unprocessesResourceKeys value
         * is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
         * BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an empty
         * unprocessedResourceKeys list.
         * </p>
         * 
         * @param unprocessedResourceKeys
         *        A list of resource keys that were not processed with the current response. The unprocessesResourceKeys
         *        value is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
         *        BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an
         *        empty unprocessedResourceKeys list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedResourceKeys(ResourceKey... unprocessedResourceKeys);

        /**
         * <p>
         * A list of resource keys that were not processed with the current response. The unprocessesResourceKeys value
         * is in the same form as ResourceKeys, so the value can be directly provided to a subsequent
         * BatchGetResourceConfig operation. If there are no unprocessed resource keys, the response contains an empty
         * unprocessedResourceKeys list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.ResourceKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.config.model.ResourceKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.ResourceKey.Builder#build()} is called immediately and
         * its result is passed to {@link #unprocessedResourceKeys(List<ResourceKey>)}.
         * 
         * @param unprocessedResourceKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.ResourceKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedResourceKeys(java.util.Collection<ResourceKey>)
         */
        Builder unprocessedResourceKeys(Consumer<ResourceKey.Builder>... unprocessedResourceKeys);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<BaseConfigurationItem> baseConfigurationItems = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceKey> unprocessedResourceKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetResourceConfigResponse model) {
            super(model);
            baseConfigurationItems(model.baseConfigurationItems);
            unprocessedResourceKeys(model.unprocessedResourceKeys);
        }

        public final List<BaseConfigurationItem.Builder> getBaseConfigurationItems() {
            List<BaseConfigurationItem.Builder> result = BaseConfigurationItemsCopier.copyToBuilder(this.baseConfigurationItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBaseConfigurationItems(Collection<BaseConfigurationItem.BuilderImpl> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copyFromBuilder(baseConfigurationItems);
        }

        @Override
        public final Builder baseConfigurationItems(Collection<BaseConfigurationItem> baseConfigurationItems) {
            this.baseConfigurationItems = BaseConfigurationItemsCopier.copy(baseConfigurationItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(BaseConfigurationItem... baseConfigurationItems) {
            baseConfigurationItems(Arrays.asList(baseConfigurationItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseConfigurationItems(Consumer<BaseConfigurationItem.Builder>... baseConfigurationItems) {
            baseConfigurationItems(Stream.of(baseConfigurationItems)
                    .map(c -> BaseConfigurationItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceKey.Builder> getUnprocessedResourceKeys() {
            List<ResourceKey.Builder> result = ResourceKeysCopier.copyToBuilder(this.unprocessedResourceKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedResourceKeys(Collection<ResourceKey.BuilderImpl> unprocessedResourceKeys) {
            this.unprocessedResourceKeys = ResourceKeysCopier.copyFromBuilder(unprocessedResourceKeys);
        }

        @Override
        public final Builder unprocessedResourceKeys(Collection<ResourceKey> unprocessedResourceKeys) {
            this.unprocessedResourceKeys = ResourceKeysCopier.copy(unprocessedResourceKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceKeys(ResourceKey... unprocessedResourceKeys) {
            unprocessedResourceKeys(Arrays.asList(unprocessedResourceKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedResourceKeys(Consumer<ResourceKey.Builder>... unprocessedResourceKeys) {
            unprocessedResourceKeys(Stream.of(unprocessedResourceKeys).map(c -> ResourceKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetResourceConfigResponse build() {
            return new BatchGetResourceConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
