/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a configuration recorder, including the <code>arn</code>, <code>name</code>,
 * <code>servicePrincipal</code>, and <code>recordingScope</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationRecorderSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationRecorderSummary.Builder, ConfigurationRecorderSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ConfigurationRecorderSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConfigurationRecorderSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("servicePrincipal").getter(getter(ConfigurationRecorderSummary::servicePrincipal))
            .setter(setter(Builder::servicePrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servicePrincipal").build()).build();

    private static final SdkField<String> RECORDING_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingScope").getter(getter(ConfigurationRecorderSummary::recordingScopeAsString))
            .setter(setter(Builder::recordingScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            SERVICE_PRINCIPAL_FIELD, RECORDING_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String servicePrincipal;

    private final String recordingScope;

    private ConfigurationRecorderSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.servicePrincipal = builder.servicePrincipal;
        this.recordingScope = builder.recordingScope;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configuration recorder.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configuration recorder.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the configuration recorder.
     * </p>
     * 
     * @return The name of the configuration recorder.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * For service-linked configuration recorders, indicates which Amazon Web Services service the configuration
     * recorder is linked to.
     * </p>
     * 
     * @return For service-linked configuration recorders, indicates which Amazon Web Services service the configuration
     *         recorder is linked to.
     */
    public final String servicePrincipal() {
        return servicePrincipal;
    }

    /**
     * <p>
     * Indicates whether the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a>
     * in scope for the configuration recorder are recorded for free (<code>INTERNAL</code>) or if you are charged a
     * service fee for recording (<code>PAID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordingScope}
     * will return {@link RecordingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordingScopeAsString}.
     * </p>
     * 
     * @return Indicates whether the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
     *         >ConfigurationItems</a> in scope for the configuration recorder are recorded for free (
     *         <code>INTERNAL</code>) or if you are charged a service fee for recording (<code>PAID</code>).
     * @see RecordingScope
     */
    public final RecordingScope recordingScope() {
        return RecordingScope.fromValue(recordingScope);
    }

    /**
     * <p>
     * Indicates whether the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a>
     * in scope for the configuration recorder are recorded for free (<code>INTERNAL</code>) or if you are charged a
     * service fee for recording (<code>PAID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordingScope}
     * will return {@link RecordingScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordingScopeAsString}.
     * </p>
     * 
     * @return Indicates whether the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
     *         >ConfigurationItems</a> in scope for the configuration recorder are recorded for free (
     *         <code>INTERNAL</code>) or if you are charged a service fee for recording (<code>PAID</code>).
     * @see RecordingScope
     */
    public final String recordingScopeAsString() {
        return recordingScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(recordingScopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderSummary)) {
            return false;
        }
        ConfigurationRecorderSummary other = (ConfigurationRecorderSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(servicePrincipal(), other.servicePrincipal())
                && Objects.equals(recordingScopeAsString(), other.recordingScopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationRecorderSummary").add("Arn", arn()).add("Name", name())
                .add("ServicePrincipal", servicePrincipal()).add("RecordingScope", recordingScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "servicePrincipal":
            return Optional.ofNullable(clazz.cast(servicePrincipal()));
        case "recordingScope":
            return Optional.ofNullable(clazz.cast(recordingScopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("servicePrincipal", SERVICE_PRINCIPAL_FIELD);
        map.put("recordingScope", RECORDING_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorderSummary, T> g) {
        return obj -> g.apply((ConfigurationRecorderSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationRecorderSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configuration recorder.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the configuration recorder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the configuration recorder.
         * </p>
         * 
         * @param name
         *        The name of the configuration recorder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * For service-linked configuration recorders, indicates which Amazon Web Services service the configuration
         * recorder is linked to.
         * </p>
         * 
         * @param servicePrincipal
         *        For service-linked configuration recorders, indicates which Amazon Web Services service the
         *        configuration recorder is linked to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipal(String servicePrincipal);

        /**
         * <p>
         * Indicates whether the <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         * >ConfigurationItems</a> in scope for the configuration recorder are recorded for free (<code>INTERNAL</code>)
         * or if you are charged a service fee for recording (<code>PAID</code>).
         * </p>
         * 
         * @param recordingScope
         *        Indicates whether the <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         *        >ConfigurationItems</a> in scope for the configuration recorder are recorded for free (
         *        <code>INTERNAL</code>) or if you are charged a service fee for recording (<code>PAID</code>).
         * @see RecordingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingScope
         */
        Builder recordingScope(String recordingScope);

        /**
         * <p>
         * Indicates whether the <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         * >ConfigurationItems</a> in scope for the configuration recorder are recorded for free (<code>INTERNAL</code>)
         * or if you are charged a service fee for recording (<code>PAID</code>).
         * </p>
         * 
         * @param recordingScope
         *        Indicates whether the <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html"
         *        >ConfigurationItems</a> in scope for the configuration recorder are recorded for free (
         *        <code>INTERNAL</code>) or if you are charged a service fee for recording (<code>PAID</code>).
         * @see RecordingScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingScope
         */
        Builder recordingScope(RecordingScope recordingScope);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String servicePrincipal;

        private String recordingScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderSummary model) {
            arn(model.arn);
            name(model.name);
            servicePrincipal(model.servicePrincipal);
            recordingScope(model.recordingScope);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServicePrincipal() {
            return servicePrincipal;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final String getRecordingScope() {
            return recordingScope;
        }

        public final void setRecordingScope(String recordingScope) {
            this.recordingScope = recordingScope;
        }

        @Override
        public final Builder recordingScope(String recordingScope) {
            this.recordingScope = recordingScope;
            return this;
        }

        @Override
        public final Builder recordingScope(RecordingScope recordingScope) {
            this.recordingScope(recordingScope == null ? null : recordingScope.toString());
            return this;
        }

        @Override
        public ConfigurationRecorderSummary build() {
            return new ConfigurationRecorderSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
