/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAggregationAuthorizationRequest extends ConfigRequest implements
        ToCopyableBuilder<DeleteAggregationAuthorizationRequest.Builder, DeleteAggregationAuthorizationRequest> {
    private static final SdkField<String> AUTHORIZED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizedAccountId").getter(getter(DeleteAggregationAuthorizationRequest::authorizedAccountId))
            .setter(setter(Builder::authorizedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAccountId").build())
            .build();

    private static final SdkField<String> AUTHORIZED_AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizedAwsRegion").getter(getter(DeleteAggregationAuthorizationRequest::authorizedAwsRegion))
            .setter(setter(Builder::authorizedAwsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAwsRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_ACCOUNT_ID_FIELD,
            AUTHORIZED_AWS_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authorizedAccountId;

    private final String authorizedAwsRegion;

    private DeleteAggregationAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.authorizedAccountId = builder.authorizedAccountId;
        this.authorizedAwsRegion = builder.authorizedAwsRegion;
    }

    /**
     * <p>
     * The 12-digit account ID of the account authorized to aggregate data.
     * </p>
     * 
     * @return The 12-digit account ID of the account authorized to aggregate data.
     */
    public final String authorizedAccountId() {
        return authorizedAccountId;
    }

    /**
     * <p>
     * The region authorized to collect aggregated data.
     * </p>
     * 
     * @return The region authorized to collect aggregated data.
     */
    public final String authorizedAwsRegion() {
        return authorizedAwsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorizedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(authorizedAwsRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAggregationAuthorizationRequest)) {
            return false;
        }
        DeleteAggregationAuthorizationRequest other = (DeleteAggregationAuthorizationRequest) obj;
        return Objects.equals(authorizedAccountId(), other.authorizedAccountId())
                && Objects.equals(authorizedAwsRegion(), other.authorizedAwsRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAggregationAuthorizationRequest").add("AuthorizedAccountId", authorizedAccountId())
                .add("AuthorizedAwsRegion", authorizedAwsRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizedAccountId":
            return Optional.ofNullable(clazz.cast(authorizedAccountId()));
        case "AuthorizedAwsRegion":
            return Optional.ofNullable(clazz.cast(authorizedAwsRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthorizedAccountId", AUTHORIZED_ACCOUNT_ID_FIELD);
        map.put("AuthorizedAwsRegion", AUTHORIZED_AWS_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAggregationAuthorizationRequest, T> g) {
        return obj -> g.apply((DeleteAggregationAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAggregationAuthorizationRequest> {
        /**
         * <p>
         * The 12-digit account ID of the account authorized to aggregate data.
         * </p>
         * 
         * @param authorizedAccountId
         *        The 12-digit account ID of the account authorized to aggregate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAccountId(String authorizedAccountId);

        /**
         * <p>
         * The region authorized to collect aggregated data.
         * </p>
         * 
         * @param authorizedAwsRegion
         *        The region authorized to collect aggregated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAwsRegion(String authorizedAwsRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String authorizedAccountId;

        private String authorizedAwsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAggregationAuthorizationRequest model) {
            super(model);
            authorizedAccountId(model.authorizedAccountId);
            authorizedAwsRegion(model.authorizedAwsRegion);
        }

        public final String getAuthorizedAccountId() {
            return authorizedAccountId;
        }

        public final void setAuthorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
        }

        @Override
        public final Builder authorizedAccountId(String authorizedAccountId) {
            this.authorizedAccountId = authorizedAccountId;
            return this;
        }

        public final String getAuthorizedAwsRegion() {
            return authorizedAwsRegion;
        }

        public final void setAuthorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
        }

        @Override
        public final Builder authorizedAwsRegion(String authorizedAwsRegion) {
            this.authorizedAwsRegion = authorizedAwsRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAggregationAuthorizationRequest build() {
            return new DeleteAggregationAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
