/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConformancePackComplianceRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeConformancePackComplianceRequest.Builder, DescribeConformancePackComplianceRequest> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConformancePackName").getter(getter(DescribeConformancePackComplianceRequest::conformancePackName))
            .setter(setter(Builder::conformancePackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build())
            .build();

    private static final SdkField<ConformancePackComplianceFilters> FILTERS_FIELD = SdkField
            .<ConformancePackComplianceFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(DescribeConformancePackComplianceRequest::filters)).setter(setter(Builder::filters))
            .constructor(ConformancePackComplianceFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeConformancePackComplianceRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeConformancePackComplianceRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD,
            FILTERS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String conformancePackName;

    private final ConformancePackComplianceFilters filters;

    private final Integer limit;

    private final String nextToken;

    private DescribeConformancePackComplianceRequest(BuilderImpl builder) {
        super(builder);
        this.conformancePackName = builder.conformancePackName;
        this.filters = builder.filters;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Name of the conformance pack.
     * </p>
     * 
     * @return Name of the conformance pack.
     */
    public final String conformancePackName() {
        return conformancePackName;
    }

    /**
     * <p>
     * A <code>ConformancePackComplianceFilters</code> object.
     * </p>
     * 
     * @return A <code>ConformancePackComplianceFilters</code> object.
     */
    public final ConformancePackComplianceFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of Config rules within a conformance pack are returned on each page.
     * </p>
     * 
     * @return The maximum number of Config rules within a conformance pack are returned on each page.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned in a previous request that you use to request the next page of results
     * in a paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned in a previous request that you use to request the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConformancePackComplianceRequest)) {
            return false;
        }
        DescribeConformancePackComplianceRequest other = (DescribeConformancePackComplianceRequest) obj;
        return Objects.equals(conformancePackName(), other.conformancePackName()) && Objects.equals(filters(), other.filters())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConformancePackComplianceRequest").add("ConformancePackName", conformancePackName())
                .add("Filters", filters()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackName":
            return Optional.ofNullable(clazz.cast(conformancePackName()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConformancePackName", CONFORMANCE_PACK_NAME_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConformancePackComplianceRequest, T> g) {
        return obj -> g.apply((DescribeConformancePackComplianceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConformancePackComplianceRequest> {
        /**
         * <p>
         * Name of the conformance pack.
         * </p>
         * 
         * @param conformancePackName
         *        Name of the conformance pack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackName(String conformancePackName);

        /**
         * <p>
         * A <code>ConformancePackComplianceFilters</code> object.
         * </p>
         * 
         * @param filters
         *        A <code>ConformancePackComplianceFilters</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ConformancePackComplianceFilters filters);

        /**
         * <p>
         * A <code>ConformancePackComplianceFilters</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConformancePackComplianceFilters.Builder}
         * avoiding the need to create one manually via {@link ConformancePackComplianceFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConformancePackComplianceFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(ConformancePackComplianceFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ConformancePackComplianceFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ConformancePackComplianceFilters)
         */
        default Builder filters(Consumer<ConformancePackComplianceFilters.Builder> filters) {
            return filters(ConformancePackComplianceFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The maximum number of Config rules within a conformance pack are returned on each page.
         * </p>
         * 
         * @param limit
         *        The maximum number of Config rules within a conformance pack are returned on each page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The <code>nextToken</code> string returned in a previous request that you use to request the next page of
         * results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned in a previous request that you use to request the next page
         *        of results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String conformancePackName;

        private ConformancePackComplianceFilters filters;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConformancePackComplianceRequest model) {
            super(model);
            conformancePackName(model.conformancePackName);
            filters(model.filters);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getConformancePackName() {
            return conformancePackName;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final ConformancePackComplianceFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ConformancePackComplianceFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ConformancePackComplianceFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConformancePackComplianceRequest build() {
            return new DescribeConformancePackComplianceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
