/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRemediationExceptionsResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeRemediationExceptionsResponse.Builder, DescribeRemediationExceptionsResponse> {
    private static final SdkField<List<RemediationException>> REMEDIATION_EXCEPTIONS_FIELD = SdkField
            .<List<RemediationException>> builder(MarshallingType.LIST)
            .memberName("RemediationExceptions")
            .getter(getter(DescribeRemediationExceptionsResponse::remediationExceptions))
            .setter(setter(Builder::remediationExceptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationExceptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemediationException> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationException::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeRemediationExceptionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMEDIATION_EXCEPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RemediationException> remediationExceptions;

    private final String nextToken;

    private DescribeRemediationExceptionsResponse(BuilderImpl builder) {
        super(builder);
        this.remediationExceptions = builder.remediationExceptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemediationExceptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemediationExceptions() {
        return remediationExceptions != null && !(remediationExceptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of remediation exception objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemediationExceptions} method.
     * </p>
     * 
     * @return Returns a list of remediation exception objects.
     */
    public final List<RemediationException> remediationExceptions() {
        return remediationExceptions;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned in a previous request that you use to request the next page of results
     * in a paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned in a previous request that you use to request the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRemediationExceptions() ? remediationExceptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRemediationExceptionsResponse)) {
            return false;
        }
        DescribeRemediationExceptionsResponse other = (DescribeRemediationExceptionsResponse) obj;
        return hasRemediationExceptions() == other.hasRemediationExceptions()
                && Objects.equals(remediationExceptions(), other.remediationExceptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRemediationExceptionsResponse")
                .add("RemediationExceptions", hasRemediationExceptions() ? remediationExceptions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RemediationExceptions":
            return Optional.ofNullable(clazz.cast(remediationExceptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RemediationExceptions", REMEDIATION_EXCEPTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRemediationExceptionsResponse, T> g) {
        return obj -> g.apply((DescribeRemediationExceptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRemediationExceptionsResponse> {
        /**
         * <p>
         * Returns a list of remediation exception objects.
         * </p>
         * 
         * @param remediationExceptions
         *        Returns a list of remediation exception objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationExceptions(Collection<RemediationException> remediationExceptions);

        /**
         * <p>
         * Returns a list of remediation exception objects.
         * </p>
         * 
         * @param remediationExceptions
         *        Returns a list of remediation exception objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationExceptions(RemediationException... remediationExceptions);

        /**
         * <p>
         * Returns a list of remediation exception objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.RemediationException.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.config.model.RemediationException#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.RemediationException.Builder#build()} is called
         * immediately and its result is passed to {@link #remediationExceptions(List<RemediationException>)}.
         * 
         * @param remediationExceptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.RemediationException.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediationExceptions(java.util.Collection<RemediationException>)
         */
        Builder remediationExceptions(Consumer<RemediationException.Builder>... remediationExceptions);

        /**
         * <p>
         * The <code>nextToken</code> string returned in a previous request that you use to request the next page of
         * results in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned in a previous request that you use to request the next page
         *        of results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<RemediationException> remediationExceptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRemediationExceptionsResponse model) {
            super(model);
            remediationExceptions(model.remediationExceptions);
            nextToken(model.nextToken);
        }

        public final List<RemediationException.Builder> getRemediationExceptions() {
            List<RemediationException.Builder> result = RemediationExceptionsCopier.copyToBuilder(this.remediationExceptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemediationExceptions(Collection<RemediationException.BuilderImpl> remediationExceptions) {
            this.remediationExceptions = RemediationExceptionsCopier.copyFromBuilder(remediationExceptions);
        }

        @Override
        public final Builder remediationExceptions(Collection<RemediationException> remediationExceptions) {
            this.remediationExceptions = RemediationExceptionsCopier.copy(remediationExceptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationExceptions(RemediationException... remediationExceptions) {
            remediationExceptions(Arrays.asList(remediationExceptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationExceptions(Consumer<RemediationException.Builder>... remediationExceptions) {
            remediationExceptions(Stream.of(remediationExceptions)
                    .map(c -> RemediationException.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRemediationExceptionsResponse build() {
            return new DescribeRemediationExceptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
