/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status filter object to filter results based on specific member account ID or status type for an organization
 * conformance pack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationResourceDetailedStatusFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationResourceDetailedStatusFilters.Builder, OrganizationResourceDetailedStatusFilters> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(OrganizationResourceDetailedStatusFilters::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OrganizationResourceDetailedStatusFilters::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACCOUNT_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String status;

    private OrganizationResourceDetailedStatusFilters(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The 12-digit account ID of the member account within an organization.
     * </p>
     * 
     * @return The 12-digit account ID of the member account within an organization.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Indicates deployment status for conformance pack in a member account. When management account calls
     * <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the
     * member account. When management account calls <code>PutOrganizationConformancePack</code> action for the second
     * time, conformance pack status is updated in the member account. Conformance pack status is deleted when the
     * management account deletes <code>OrganizationConformancePack</code> and disables service access for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * Config sets the state of the conformance pack to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationResourceDetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates deployment status for conformance pack in a member account. When management account calls
     *         <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created
     *         in the member account. When management account calls <code>PutOrganizationConformancePack</code> action
     *         for the second time, conformance pack status is updated in the member account. Conformance pack status is
     *         deleted when the management account deletes <code>OrganizationConformancePack</code> and disables service
     *         access for <code>config-multiaccountsetup.amazonaws.com</code>. </p>
     *         <p>
     *         Config sets the state of the conformance pack to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
     *         </p>
     *         </li>
     * @see OrganizationResourceDetailedStatus
     */
    public final OrganizationResourceDetailedStatus status() {
        return OrganizationResourceDetailedStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates deployment status for conformance pack in a member account. When management account calls
     * <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in the
     * member account. When management account calls <code>PutOrganizationConformancePack</code> action for the second
     * time, conformance pack status is updated in the member account. Conformance pack status is deleted when the
     * management account deletes <code>OrganizationConformancePack</code> and disables service access for
     * <code>config-multiaccountsetup.amazonaws.com</code>.
     * </p>
     * <p>
     * Config sets the state of the conformance pack to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationResourceDetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates deployment status for conformance pack in a member account. When management account calls
     *         <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created
     *         in the member account. When management account calls <code>PutOrganizationConformancePack</code> action
     *         for the second time, conformance pack status is updated in the member account. Conformance pack status is
     *         deleted when the management account deletes <code>OrganizationConformancePack</code> and disables service
     *         access for <code>config-multiaccountsetup.amazonaws.com</code>. </p>
     *         <p>
     *         Config sets the state of the conformance pack to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
     *         </p>
     *         </li>
     * @see OrganizationResourceDetailedStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationResourceDetailedStatusFilters)) {
            return false;
        }
        OrganizationResourceDetailedStatusFilters other = (OrganizationResourceDetailedStatusFilters) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationResourceDetailedStatusFilters").add("AccountId", accountId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationResourceDetailedStatusFilters, T> g) {
        return obj -> g.apply((OrganizationResourceDetailedStatusFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationResourceDetailedStatusFilters> {
        /**
         * <p>
         * The 12-digit account ID of the member account within an organization.
         * </p>
         * 
         * @param accountId
         *        The 12-digit account ID of the member account within an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Indicates deployment status for conformance pack in a member account. When management account calls
         * <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in
         * the member account. When management account calls <code>PutOrganizationConformancePack</code> action for the
         * second time, conformance pack status is updated in the member account. Conformance pack status is deleted
         * when the management account deletes <code>OrganizationConformancePack</code> and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * Config sets the state of the conformance pack to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Indicates deployment status for conformance pack in a member account. When management account calls
         *        <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is
         *        created in the member account. When management account calls
         *        <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is
         *        updated in the member account. Conformance pack status is deleted when the management account deletes
         *        <code>OrganizationConformancePack</code> and disables service access for
         *        <code>config-multiaccountsetup.amazonaws.com</code>. </p>
         *        <p>
         *        Config sets the state of the conformance pack to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
         *        </p>
         *        </li>
         * @see OrganizationResourceDetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationResourceDetailedStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates deployment status for conformance pack in a member account. When management account calls
         * <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is created in
         * the member account. When management account calls <code>PutOrganizationConformancePack</code> action for the
         * second time, conformance pack status is updated in the member account. Conformance pack status is deleted
         * when the management account deletes <code>OrganizationConformancePack</code> and disables service access for
         * <code>config-multiaccountsetup.amazonaws.com</code>.
         * </p>
         * <p>
         * Config sets the state of the conformance pack to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Indicates deployment status for conformance pack in a member account. When management account calls
         *        <code>PutOrganizationConformancePack</code> action for the first time, conformance pack status is
         *        created in the member account. When management account calls
         *        <code>PutOrganizationConformancePack</code> action for the second time, conformance pack status is
         *        updated in the member account. Conformance pack status is deleted when the management account deletes
         *        <code>OrganizationConformancePack</code> and disables service access for
         *        <code>config-multiaccountsetup.amazonaws.com</code>. </p>
         *        <p>
         *        Config sets the state of the conformance pack to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_SUCCESSFUL</code> when conformance pack has been created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> when conformance pack is being created in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> when conformance pack creation has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> when conformance pack deletion has failed in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_IN_PROGRESS</code> when conformance pack is being deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_SUCCESSFUL</code> when conformance pack has been deleted in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_SUCCESSFUL</code> when conformance pack has been updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> when conformance pack is being updated in the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code> when conformance pack deletion has failed in the member account.
         *        </p>
         *        </li>
         * @see OrganizationResourceDetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationResourceDetailedStatus
         */
        Builder status(OrganizationResourceDetailedStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationResourceDetailedStatusFilters model) {
            accountId(model.accountId);
            status(model.status);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrganizationResourceDetailedStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public OrganizationResourceDetailedStatusFilters build() {
            return new OrganizationResourceDetailedStatusFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
