/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelectAggregateResourceConfigResponse extends ConfigResponse implements
        ToCopyableBuilder<SelectAggregateResourceConfigResponse.Builder, SelectAggregateResourceConfigResponse> {
    private static final SdkField<List<String>> RESULTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(SelectAggregateResourceConfigResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<QueryInfo> QUERY_INFO_FIELD = SdkField.<QueryInfo> builder(MarshallingType.SDK_POJO)
            .memberName("QueryInfo").getter(getter(SelectAggregateResourceConfigResponse::queryInfo))
            .setter(setter(Builder::queryInfo)).constructor(QueryInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryInfo").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SelectAggregateResourceConfigResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD,
            QUERY_INFO_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> results;

    private final QueryInfo queryInfo;

    private final String nextToken;

    private SelectAggregateResourceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.queryInfo = builder.queryInfo;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the results for the SQL query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return Returns the results for the SQL query.
     */
    public final List<String> results() {
        return results;
    }

    /**
     * Returns the value of the QueryInfo property for this object.
     * 
     * @return The value of the QueryInfo property for this object.
     */
    public final QueryInfo queryInfo() {
        return queryInfo;
    }

    /**
     * <p>
     * The nextToken string returned in a previous request that you use to request the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The nextToken string returned in a previous request that you use to request the next page of results in a
     *         paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectAggregateResourceConfigResponse)) {
            return false;
        }
        SelectAggregateResourceConfigResponse other = (SelectAggregateResourceConfigResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && Objects.equals(queryInfo(), other.queryInfo()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelectAggregateResourceConfigResponse").add("Results", hasResults() ? results() : null)
                .add("QueryInfo", queryInfo()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "QueryInfo":
            return Optional.ofNullable(clazz.cast(queryInfo()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Results", RESULTS_FIELD);
        map.put("QueryInfo", QUERY_INFO_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelectAggregateResourceConfigResponse, T> g) {
        return obj -> g.apply((SelectAggregateResourceConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SelectAggregateResourceConfigResponse> {
        /**
         * <p>
         * Returns the results for the SQL query.
         * </p>
         * 
         * @param results
         *        Returns the results for the SQL query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<String> results);

        /**
         * <p>
         * Returns the results for the SQL query.
         * </p>
         * 
         * @param results
         *        Returns the results for the SQL query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(String... results);

        /**
         * Sets the value of the QueryInfo property for this object.
         *
         * @param queryInfo
         *        The new value for the QueryInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryInfo(QueryInfo queryInfo);

        /**
         * Sets the value of the QueryInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link QueryInfo.Builder} avoiding the need to
         * create one manually via {@link QueryInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #queryInfo(QueryInfo)}.
         * 
         * @param queryInfo
         *        a consumer that will call methods on {@link QueryInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryInfo(QueryInfo)
         */
        default Builder queryInfo(Consumer<QueryInfo.Builder> queryInfo) {
            return queryInfo(QueryInfo.builder().applyMutation(queryInfo).build());
        }

        /**
         * <p>
         * The nextToken string returned in a previous request that you use to request the next page of results in a
         * paginated response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned in a previous request that you use to request the next page of results
         *        in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<String> results = DefaultSdkAutoConstructList.getInstance();

        private QueryInfo queryInfo;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SelectAggregateResourceConfigResponse model) {
            super(model);
            results(model.results);
            queryInfo(model.queryInfo);
            nextToken(model.nextToken);
        }

        public final Collection<String> getResults() {
            if (results instanceof SdkAutoConstructList) {
                return null;
            }
            return results;
        }

        public final void setResults(Collection<String> results) {
            this.results = ResultsCopier.copy(results);
        }

        @Override
        public final Builder results(Collection<String> results) {
            this.results = ResultsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(String... results) {
            results(Arrays.asList(results));
            return this;
        }

        public final QueryInfo.Builder getQueryInfo() {
            return queryInfo != null ? queryInfo.toBuilder() : null;
        }

        public final void setQueryInfo(QueryInfo.BuilderImpl queryInfo) {
            this.queryInfo = queryInfo != null ? queryInfo.build() : null;
        }

        @Override
        public final Builder queryInfo(QueryInfo queryInfo) {
            this.queryInfo = queryInfo;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SelectAggregateResourceConfigResponse build() {
            return new SelectAggregateResourceConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
