/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the CustomPolicyDetails, the rule owner (<code>Amazon Web Services</code> for managed rules,
 * <code>CUSTOM_POLICY</code> for Custom Policy rules, and <code>CUSTOM_LAMBDA</code> for Custom Lambda rules), the rule
 * identifier, and the events that cause the evaluation of your Amazon Web Services resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Source implements SdkPojo, Serializable, ToCopyableBuilder<Source.Builder, Source> {
    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(Source::ownerAsString)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> SOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIdentifier").getter(getter(Source::sourceIdentifier)).setter(setter(Builder::sourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdentifier").build()).build();

    private static final SdkField<List<SourceDetail>> SOURCE_DETAILS_FIELD = SdkField
            .<List<SourceDetail>> builder(MarshallingType.LIST)
            .memberName("SourceDetails")
            .getter(getter(Source::sourceDetails))
            .setter(setter(Builder::sourceDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomPolicyDetails> CUSTOM_POLICY_DETAILS_FIELD = SdkField
            .<CustomPolicyDetails> builder(MarshallingType.SDK_POJO).memberName("CustomPolicyDetails")
            .getter(getter(Source::customPolicyDetails)).setter(setter(Builder::customPolicyDetails))
            .constructor(CustomPolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPolicyDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_FIELD,
            SOURCE_IDENTIFIER_FIELD, SOURCE_DETAILS_FIELD, CUSTOM_POLICY_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String owner;

    private final String sourceIdentifier;

    private final List<SourceDetail> sourceDetails;

    private final CustomPolicyDetails customPolicyDetails;

    private Source(BuilderImpl builder) {
        this.owner = builder.owner;
        this.sourceIdentifier = builder.sourceIdentifier;
        this.sourceDetails = builder.sourceDetails;
        this.customPolicyDetails = builder.customPolicyDetails;
    }

    /**
     * <p>
     * Indicates whether Amazon Web Services or the customer owns and manages the Config rule.
     * </p>
     * <p>
     * Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config
     * Managed Rules</a> in the <i>Config developer guide</i>.
     * </p>
     * <p>
     * Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or Lambda (
     * <code>CUSTOM_LAMBDA</code>). For more information, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config Custom
     * Rules </a> in the <i>Config developer guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Owner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
     *         <p>
     *         Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config
     *         Managed Rules</a> in the <i>Config developer guide</i>.
     *         </p>
     *         <p>
     *         Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or
     *         Lambda (<code>CUSTOM_LAMBDA</code>). For more information, see <a
     *         href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config
     *         Custom Rules </a> in the <i>Config developer guide</i>.
     * @see Owner
     */
    public final Owner owner() {
        return Owner.fromValue(owner);
    }

    /**
     * <p>
     * Indicates whether Amazon Web Services or the customer owns and manages the Config rule.
     * </p>
     * <p>
     * Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config
     * Managed Rules</a> in the <i>Config developer guide</i>.
     * </p>
     * <p>
     * Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or Lambda (
     * <code>CUSTOM_LAMBDA</code>). For more information, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config Custom
     * Rules </a> in the <i>Config developer guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Owner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
     *         <p>
     *         Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config
     *         Managed Rules</a> in the <i>Config developer guide</i>.
     *         </p>
     *         <p>
     *         Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or
     *         Lambda (<code>CUSTOM_LAMBDA</code>). For more information, see <a
     *         href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config
     *         Custom Rules </a> in the <i>Config developer guide</i>.
     * @see Owner
     */
    public final String ownerAsString() {
        return owner;
    }

    /**
     * <p>
     * For Config Managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code> is a
     * managed rule. To reference a managed rule, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config
     * Managed Rules</a>.
     * </p>
     * <p>
     * For Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's Lambda function,
     * such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.
     * </p>
     * <p>
     * For Config Custom Policy rules, this field will be ignored.
     * </p>
     * 
     * @return For Config Managed rules, a predefined identifier from a list. For example,
     *         <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a
     *         href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of
     *         Config Managed Rules</a>.</p>
     *         <p>
     *         For Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's Lambda
     *         function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.
     *         </p>
     *         <p>
     *         For Config Custom Policy rules, this field will be ignored.
     */
    public final String sourceIdentifier() {
        return sourceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceDetails() {
        return sourceDetails != null && !(sourceDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the source and the message types that cause Config to evaluate your Amazon Web Services resources
     * against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if the
     * trigger type is periodic.
     * </p>
     * <p>
     * If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger message
     * type are <code>ConfigurationItemChangeNotification</code> and
     * <code>OversizedConfigurationItemChangeNotification</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceDetails} method.
     * </p>
     * 
     * @return Provides the source and the message types that cause Config to evaluate your Amazon Web Services
     *         resources against a rule. It also provides the frequency with which you want Config to run evaluations
     *         for the rule if the trigger type is periodic.</p>
     *         <p>
     *         If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger
     *         message type are <code>ConfigurationItemChangeNotification</code> and
     *         <code>OversizedConfigurationItemChangeNotification</code>.
     */
    public final List<SourceDetail> sourceDetails() {
        return sourceDetails;
    }

    /**
     * <p>
     * Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set
     * to <code>CUSTOM_POLICY</code>.
     * </p>
     * 
     * @return Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner
     *         is set to <code>CUSTOM_POLICY</code>.
     */
    public final CustomPolicyDetails customPolicyDetails() {
        return customPolicyDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceDetails() ? sourceDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customPolicyDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source) obj;
        return Objects.equals(ownerAsString(), other.ownerAsString())
                && Objects.equals(sourceIdentifier(), other.sourceIdentifier()) && hasSourceDetails() == other.hasSourceDetails()
                && Objects.equals(sourceDetails(), other.sourceDetails())
                && Objects.equals(customPolicyDetails(), other.customPolicyDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Source").add("Owner", ownerAsString()).add("SourceIdentifier", sourceIdentifier())
                .add("SourceDetails", hasSourceDetails() ? sourceDetails() : null)
                .add("CustomPolicyDetails", customPolicyDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        case "SourceIdentifier":
            return Optional.ofNullable(clazz.cast(sourceIdentifier()));
        case "SourceDetails":
            return Optional.ofNullable(clazz.cast(sourceDetails()));
        case "CustomPolicyDetails":
            return Optional.ofNullable(clazz.cast(customPolicyDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Owner", OWNER_FIELD);
        map.put("SourceIdentifier", SOURCE_IDENTIFIER_FIELD);
        map.put("SourceDetails", SOURCE_DETAILS_FIELD);
        map.put("CustomPolicyDetails", CUSTOM_POLICY_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Source> {
        /**
         * <p>
         * Indicates whether Amazon Web Services or the customer owns and manages the Config rule.
         * </p>
         * <p>
         * Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a
         * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config
         * Managed Rules</a> in the <i>Config developer guide</i>.
         * </p>
         * <p>
         * Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or Lambda (
         * <code>CUSTOM_LAMBDA</code>). For more information, see <a
         * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config
         * Custom Rules </a> in the <i>Config developer guide</i>.
         * </p>
         * 
         * @param owner
         *        Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
         *        <p>
         *        Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a
         *        href
         *        ="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">
         *        Config Managed Rules</a> in the <i>Config developer guide</i>.
         *        </p>
         *        <p>
         *        Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or
         *        Lambda (<code>CUSTOM_LAMBDA</code>). For more information, see <a
         *        href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html"
         *        >Config Custom Rules </a> in the <i>Config developer guide</i>.
         * @see Owner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Owner
         */
        Builder owner(String owner);

        /**
         * <p>
         * Indicates whether Amazon Web Services or the customer owns and manages the Config rule.
         * </p>
         * <p>
         * Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a
         * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">Config
         * Managed Rules</a> in the <i>Config developer guide</i>.
         * </p>
         * <p>
         * Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or Lambda (
         * <code>CUSTOM_LAMBDA</code>). For more information, see <a
         * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html">Config
         * Custom Rules </a> in the <i>Config developer guide</i>.
         * </p>
         * 
         * @param owner
         *        Indicates whether Amazon Web Services or the customer owns and manages the Config rule.</p>
         *        <p>
         *        Config Managed Rules are predefined rules owned by Amazon Web Services. For more information, see <a
         *        href
         *        ="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html">
         *        Config Managed Rules</a> in the <i>Config developer guide</i>.
         *        </p>
         *        <p>
         *        Config Custom Rules are rules that you can develop either with Guard (<code>CUSTOM_POLICY</code>) or
         *        Lambda (<code>CUSTOM_LAMBDA</code>). For more information, see <a
         *        href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html"
         *        >Config Custom Rules </a> in the <i>Config developer guide</i>.
         * @see Owner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Owner
         */
        Builder owner(Owner owner);

        /**
         * <p>
         * For Config Managed rules, a predefined identifier from a list. For example, <code>IAM_PASSWORD_POLICY</code>
         * is a managed rule. To reference a managed rule, see <a
         * href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of
         * Config Managed Rules</a>.
         * </p>
         * <p>
         * For Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's Lambda
         * function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.
         * </p>
         * <p>
         * For Config Custom Policy rules, this field will be ignored.
         * </p>
         * 
         * @param sourceIdentifier
         *        For Config Managed rules, a predefined identifier from a list. For example,
         *        <code>IAM_PASSWORD_POLICY</code> is a managed rule. To reference a managed rule, see <a
         *        href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List
         *        of Config Managed Rules</a>.</p>
         *        <p>
         *        For Config Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's Lambda
         *        function, such as <code>arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name</code>.
         *        </p>
         *        <p>
         *        For Config Custom Policy rules, this field will be ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdentifier(String sourceIdentifier);

        /**
         * <p>
         * Provides the source and the message types that cause Config to evaluate your Amazon Web Services resources
         * against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if
         * the trigger type is periodic.
         * </p>
         * <p>
         * If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger
         * message type are <code>ConfigurationItemChangeNotification</code> and
         * <code>OversizedConfigurationItemChangeNotification</code>.
         * </p>
         * 
         * @param sourceDetails
         *        Provides the source and the message types that cause Config to evaluate your Amazon Web Services
         *        resources against a rule. It also provides the frequency with which you want Config to run evaluations
         *        for the rule if the trigger type is periodic.</p>
         *        <p>
         *        If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule
         *        trigger message type are <code>ConfigurationItemChangeNotification</code> and
         *        <code>OversizedConfigurationItemChangeNotification</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDetails(Collection<SourceDetail> sourceDetails);

        /**
         * <p>
         * Provides the source and the message types that cause Config to evaluate your Amazon Web Services resources
         * against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if
         * the trigger type is periodic.
         * </p>
         * <p>
         * If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger
         * message type are <code>ConfigurationItemChangeNotification</code> and
         * <code>OversizedConfigurationItemChangeNotification</code>.
         * </p>
         * 
         * @param sourceDetails
         *        Provides the source and the message types that cause Config to evaluate your Amazon Web Services
         *        resources against a rule. It also provides the frequency with which you want Config to run evaluations
         *        for the rule if the trigger type is periodic.</p>
         *        <p>
         *        If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule
         *        trigger message type are <code>ConfigurationItemChangeNotification</code> and
         *        <code>OversizedConfigurationItemChangeNotification</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDetails(SourceDetail... sourceDetails);

        /**
         * <p>
         * Provides the source and the message types that cause Config to evaluate your Amazon Web Services resources
         * against a rule. It also provides the frequency with which you want Config to run evaluations for the rule if
         * the trigger type is periodic.
         * </p>
         * <p>
         * If the owner is set to <code>CUSTOM_POLICY</code>, the only acceptable values for the Config rule trigger
         * message type are <code>ConfigurationItemChangeNotification</code> and
         * <code>OversizedConfigurationItemChangeNotification</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.SourceDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.config.model.SourceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.SourceDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceDetails(List<SourceDetail>)}.
         * 
         * @param sourceDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.SourceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDetails(java.util.Collection<SourceDetail>)
         */
        Builder sourceDetails(Consumer<SourceDetail.Builder>... sourceDetails);

        /**
         * <p>
         * Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is
         * set to <code>CUSTOM_POLICY</code>.
         * </p>
         * 
         * @param customPolicyDetails
         *        Provides the runtime system, policy definition, and whether debug logging is enabled. Required when
         *        owner is set to <code>CUSTOM_POLICY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPolicyDetails(CustomPolicyDetails customPolicyDetails);

        /**
         * <p>
         * Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is
         * set to <code>CUSTOM_POLICY</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPolicyDetails.Builder} avoiding the
         * need to create one manually via {@link CustomPolicyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomPolicyDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #customPolicyDetails(CustomPolicyDetails)}.
         * 
         * @param customPolicyDetails
         *        a consumer that will call methods on {@link CustomPolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPolicyDetails(CustomPolicyDetails)
         */
        default Builder customPolicyDetails(Consumer<CustomPolicyDetails.Builder> customPolicyDetails) {
            return customPolicyDetails(CustomPolicyDetails.builder().applyMutation(customPolicyDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String owner;

        private String sourceIdentifier;

        private List<SourceDetail> sourceDetails = DefaultSdkAutoConstructList.getInstance();

        private CustomPolicyDetails customPolicyDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            owner(model.owner);
            sourceIdentifier(model.sourceIdentifier);
            sourceDetails(model.sourceDetails);
            customPolicyDetails(model.customPolicyDetails);
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final String getSourceIdentifier() {
            return sourceIdentifier;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final List<SourceDetail.Builder> getSourceDetails() {
            List<SourceDetail.Builder> result = SourceDetailsCopier.copyToBuilder(this.sourceDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDetails(Collection<SourceDetail.BuilderImpl> sourceDetails) {
            this.sourceDetails = SourceDetailsCopier.copyFromBuilder(sourceDetails);
        }

        @Override
        public final Builder sourceDetails(Collection<SourceDetail> sourceDetails) {
            this.sourceDetails = SourceDetailsCopier.copy(sourceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDetails(SourceDetail... sourceDetails) {
            sourceDetails(Arrays.asList(sourceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDetails(Consumer<SourceDetail.Builder>... sourceDetails) {
            sourceDetails(Stream.of(sourceDetails).map(c -> SourceDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CustomPolicyDetails.Builder getCustomPolicyDetails() {
            return customPolicyDetails != null ? customPolicyDetails.toBuilder() : null;
        }

        public final void setCustomPolicyDetails(CustomPolicyDetails.BuilderImpl customPolicyDetails) {
            this.customPolicyDetails = customPolicyDetails != null ? customPolicyDetails.build() : null;
        }

        @Override
        public final Builder customPolicyDetails(CustomPolicyDetails customPolicyDetails) {
            this.customPolicyDetails = customPolicyDetails;
            return this;
        }

        @Override
        public Source build() {
            return new Source(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
