/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.GroupedResourceCount;
import software.amazon.awssdk.services.config.model.GroupedResourceCountListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAggregateDiscoveredResourceCountsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetAggregateDiscoveredResourceCountsResponse> {
    private static final SdkField<Long> TOTAL_DISCOVERED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalDiscoveredResources").getter(GetAggregateDiscoveredResourceCountsResponse.getter(GetAggregateDiscoveredResourceCountsResponse::totalDiscoveredResources)).setter(GetAggregateDiscoveredResourceCountsResponse.setter(Builder::totalDiscoveredResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalDiscoveredResources").build()}).build();
    private static final SdkField<String> GROUP_BY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupByKey").getter(GetAggregateDiscoveredResourceCountsResponse.getter(GetAggregateDiscoveredResourceCountsResponse::groupByKey)).setter(GetAggregateDiscoveredResourceCountsResponse.setter(Builder::groupByKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByKey").build()}).build();
    private static final SdkField<List<GroupedResourceCount>> GROUPED_RESOURCE_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupedResourceCounts").getter(GetAggregateDiscoveredResourceCountsResponse.getter(GetAggregateDiscoveredResourceCountsResponse::groupedResourceCounts)).setter(GetAggregateDiscoveredResourceCountsResponse.setter(Builder::groupedResourceCounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupedResourceCounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupedResourceCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetAggregateDiscoveredResourceCountsResponse.getter(GetAggregateDiscoveredResourceCountsResponse::nextToken)).setter(GetAggregateDiscoveredResourceCountsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_DISCOVERED_RESOURCES_FIELD, GROUP_BY_KEY_FIELD, GROUPED_RESOURCE_COUNTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAggregateDiscoveredResourceCountsResponse.memberNameToFieldInitializer();
    private final Long totalDiscoveredResources;
    private final String groupByKey;
    private final List<GroupedResourceCount> groupedResourceCounts;
    private final String nextToken;

    private GetAggregateDiscoveredResourceCountsResponse(BuilderImpl builder) {
        super(builder);
        this.totalDiscoveredResources = builder.totalDiscoveredResources;
        this.groupByKey = builder.groupByKey;
        this.groupedResourceCounts = builder.groupedResourceCounts;
        this.nextToken = builder.nextToken;
    }

    public final Long totalDiscoveredResources() {
        return this.totalDiscoveredResources;
    }

    public final String groupByKey() {
        return this.groupByKey;
    }

    public final boolean hasGroupedResourceCounts() {
        return this.groupedResourceCounts != null && !(this.groupedResourceCounts instanceof SdkAutoConstructList);
    }

    public final List<GroupedResourceCount> groupedResourceCounts() {
        return this.groupedResourceCounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.totalDiscoveredResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupedResourceCounts() ? this.groupedResourceCounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateDiscoveredResourceCountsResponse)) {
            return false;
        }
        GetAggregateDiscoveredResourceCountsResponse other = (GetAggregateDiscoveredResourceCountsResponse)((Object)obj);
        return Objects.equals(this.totalDiscoveredResources(), other.totalDiscoveredResources()) && Objects.equals(this.groupByKey(), other.groupByKey()) && this.hasGroupedResourceCounts() == other.hasGroupedResourceCounts() && Objects.equals(this.groupedResourceCounts(), other.groupedResourceCounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetAggregateDiscoveredResourceCountsResponse").add("TotalDiscoveredResources", (Object)this.totalDiscoveredResources()).add("GroupByKey", (Object)this.groupByKey()).add("GroupedResourceCounts", this.hasGroupedResourceCounts() ? this.groupedResourceCounts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalDiscoveredResources": {
                return Optional.ofNullable(clazz.cast(this.totalDiscoveredResources()));
            }
            case "GroupByKey": {
                return Optional.ofNullable(clazz.cast(this.groupByKey()));
            }
            case "GroupedResourceCounts": {
                return Optional.ofNullable(clazz.cast(this.groupedResourceCounts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TotalDiscoveredResources", TOTAL_DISCOVERED_RESOURCES_FIELD);
        map.put("GroupByKey", GROUP_BY_KEY_FIELD);
        map.put("GroupedResourceCounts", GROUPED_RESOURCE_COUNTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateDiscoveredResourceCountsResponse, T> g) {
        return obj -> g.apply((GetAggregateDiscoveredResourceCountsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private Long totalDiscoveredResources;
        private String groupByKey;
        private List<GroupedResourceCount> groupedResourceCounts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateDiscoveredResourceCountsResponse model) {
            super(model);
            this.totalDiscoveredResources(model.totalDiscoveredResources);
            this.groupByKey(model.groupByKey);
            this.groupedResourceCounts(model.groupedResourceCounts);
            this.nextToken(model.nextToken);
        }

        public final Long getTotalDiscoveredResources() {
            return this.totalDiscoveredResources;
        }

        public final void setTotalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
        }

        @Override
        public final Builder totalDiscoveredResources(Long totalDiscoveredResources) {
            this.totalDiscoveredResources = totalDiscoveredResources;
            return this;
        }

        public final String getGroupByKey() {
            return this.groupByKey;
        }

        public final void setGroupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
        }

        @Override
        public final Builder groupByKey(String groupByKey) {
            this.groupByKey = groupByKey;
            return this;
        }

        public final List<GroupedResourceCount.Builder> getGroupedResourceCounts() {
            List<GroupedResourceCount.Builder> result = GroupedResourceCountListCopier.copyToBuilder(this.groupedResourceCounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupedResourceCounts(Collection<GroupedResourceCount.BuilderImpl> groupedResourceCounts) {
            this.groupedResourceCounts = GroupedResourceCountListCopier.copyFromBuilder(groupedResourceCounts);
        }

        @Override
        public final Builder groupedResourceCounts(Collection<GroupedResourceCount> groupedResourceCounts) {
            this.groupedResourceCounts = GroupedResourceCountListCopier.copy(groupedResourceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedResourceCounts(GroupedResourceCount ... groupedResourceCounts) {
            this.groupedResourceCounts(Arrays.asList(groupedResourceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupedResourceCounts(Consumer<GroupedResourceCount.Builder> ... groupedResourceCounts) {
            this.groupedResourceCounts(Stream.of(groupedResourceCounts).map(c -> (GroupedResourceCount)((GroupedResourceCount.Builder)GroupedResourceCount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetAggregateDiscoveredResourceCountsResponse build() {
            return new GetAggregateDiscoveredResourceCountsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAggregateDiscoveredResourceCountsResponse> {
        public Builder totalDiscoveredResources(Long var1);

        public Builder groupByKey(String var1);

        public Builder groupedResourceCounts(Collection<GroupedResourceCount> var1);

        public Builder groupedResourceCounts(GroupedResourceCount ... var1);

        public Builder groupedResourceCounts(Consumer<GroupedResourceCount.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

