/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ResourceConfigurationSchemaType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDetails> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ResourceDetails.getter(ResourceDetails::resourceId)).setter(ResourceDetails.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceDetails.getter(ResourceDetails::resourceType)).setter(ResourceDetails.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceConfiguration").getter(ResourceDetails.getter(ResourceDetails::resourceConfiguration)).setter(ResourceDetails.setter(Builder::resourceConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfiguration").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_SCHEMA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceConfigurationSchemaType").getter(ResourceDetails.getter(ResourceDetails::resourceConfigurationSchemaTypeAsString)).setter(ResourceDetails.setter(Builder::resourceConfigurationSchemaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfigurationSchemaType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_CONFIGURATION_FIELD, RESOURCE_CONFIGURATION_SCHEMA_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String resourceType;
    private final String resourceConfiguration;
    private final String resourceConfigurationSchemaType;

    private ResourceDetails(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.resourceConfiguration = builder.resourceConfiguration;
        this.resourceConfigurationSchemaType = builder.resourceConfigurationSchemaType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resourceConfiguration() {
        return this.resourceConfiguration;
    }

    public final ResourceConfigurationSchemaType resourceConfigurationSchemaType() {
        return ResourceConfigurationSchemaType.fromValue(this.resourceConfigurationSchemaType);
    }

    public final String resourceConfigurationSchemaTypeAsString() {
        return this.resourceConfigurationSchemaType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationSchemaTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceConfiguration(), other.resourceConfiguration()) && Objects.equals(this.resourceConfigurationSchemaTypeAsString(), other.resourceConfigurationSchemaTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceDetails").add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceType()).add("ResourceConfiguration", (Object)this.resourceConfiguration()).add("ResourceConfigurationSchemaType", (Object)this.resourceConfigurationSchemaTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resourceConfiguration()));
            }
            case "ResourceConfigurationSchemaType": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationSchemaTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceConfiguration", RESOURCE_CONFIGURATION_FIELD);
        map.put("ResourceConfigurationSchemaType", RESOURCE_CONFIGURATION_SCHEMA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;
        private String resourceConfiguration;
        private String resourceConfigurationSchemaType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.resourceConfiguration(model.resourceConfiguration);
            this.resourceConfigurationSchemaType(model.resourceConfigurationSchemaType);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceConfiguration() {
            return this.resourceConfiguration;
        }

        public final void setResourceConfiguration(String resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration;
        }

        @Override
        public final Builder resourceConfiguration(String resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration;
            return this;
        }

        public final String getResourceConfigurationSchemaType() {
            return this.resourceConfigurationSchemaType;
        }

        public final void setResourceConfigurationSchemaType(String resourceConfigurationSchemaType) {
            this.resourceConfigurationSchemaType = resourceConfigurationSchemaType;
        }

        @Override
        public final Builder resourceConfigurationSchemaType(String resourceConfigurationSchemaType) {
            this.resourceConfigurationSchemaType = resourceConfigurationSchemaType;
            return this;
        }

        @Override
        public final Builder resourceConfigurationSchemaType(ResourceConfigurationSchemaType resourceConfigurationSchemaType) {
            this.resourceConfigurationSchemaType(resourceConfigurationSchemaType == null ? null : resourceConfigurationSchemaType.toString());
            return this;
        }

        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDetails> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceConfiguration(String var1);

        public Builder resourceConfigurationSchemaType(String var1);

        public Builder resourceConfigurationSchemaType(ResourceConfigurationSchemaType var1);
    }
}

