/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ComplianceByResource;
import software.amazon.awssdk.services.config.model.ComplianceByResourcesCopier;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComplianceByResourceResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeComplianceByResourceResponse> {
    private static final SdkField<List<ComplianceByResource>> COMPLIANCE_BY_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComplianceByResources").getter(DescribeComplianceByResourceResponse.getter(DescribeComplianceByResourceResponse::complianceByResources)).setter(DescribeComplianceByResourceResponse.setter(Builder::complianceByResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceByResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComplianceByResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeComplianceByResourceResponse.getter(DescribeComplianceByResourceResponse::nextToken)).setter(DescribeComplianceByResourceResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_BY_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeComplianceByResourceResponse.memberNameToFieldInitializer();
    private final List<ComplianceByResource> complianceByResources;
    private final String nextToken;

    private DescribeComplianceByResourceResponse(BuilderImpl builder) {
        super(builder);
        this.complianceByResources = builder.complianceByResources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComplianceByResources() {
        return this.complianceByResources != null && !(this.complianceByResources instanceof SdkAutoConstructList);
    }

    public final List<ComplianceByResource> complianceByResources() {
        return this.complianceByResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComplianceByResources() ? this.complianceByResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComplianceByResourceResponse)) {
            return false;
        }
        DescribeComplianceByResourceResponse other = (DescribeComplianceByResourceResponse)((Object)obj);
        return this.hasComplianceByResources() == other.hasComplianceByResources() && Objects.equals(this.complianceByResources(), other.complianceByResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComplianceByResourceResponse").add("ComplianceByResources", this.hasComplianceByResources() ? this.complianceByResources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceByResources": {
                return Optional.ofNullable(clazz.cast(this.complianceByResources()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ComplianceByResources", COMPLIANCE_BY_RESOURCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComplianceByResourceResponse, T> g) {
        return obj -> g.apply((DescribeComplianceByResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ComplianceByResource> complianceByResources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComplianceByResourceResponse model) {
            super(model);
            this.complianceByResources(model.complianceByResources);
            this.nextToken(model.nextToken);
        }

        public final List<ComplianceByResource.Builder> getComplianceByResources() {
            List<ComplianceByResource.Builder> result = ComplianceByResourcesCopier.copyToBuilder(this.complianceByResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComplianceByResources(Collection<ComplianceByResource.BuilderImpl> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copyFromBuilder(complianceByResources);
        }

        @Override
        public final Builder complianceByResources(Collection<ComplianceByResource> complianceByResources) {
            this.complianceByResources = ComplianceByResourcesCopier.copy(complianceByResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByResources(ComplianceByResource ... complianceByResources) {
            this.complianceByResources(Arrays.asList(complianceByResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceByResources(Consumer<ComplianceByResource.Builder> ... complianceByResources) {
            this.complianceByResources(Stream.of(complianceByResources).map(c -> (ComplianceByResource)((ComplianceByResource.Builder)ComplianceByResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeComplianceByResourceResponse build() {
            return new DescribeComplianceByResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComplianceByResourceResponse> {
        public Builder complianceByResources(Collection<ComplianceByResource> var1);

        public Builder complianceByResources(ComplianceByResource ... var1);

        public Builder complianceByResources(Consumer<ComplianceByResource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

