/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigurationRecorder;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationRecordersResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationRecordersResponse> {
    private static final SdkField<List<ConfigurationRecorder>> CONFIGURATION_RECORDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationRecorders").getter(DescribeConfigurationRecordersResponse.getter(DescribeConfigurationRecordersResponse::configurationRecorders)).setter(DescribeConfigurationRecordersResponse.setter(Builder::configurationRecorders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecorders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationRecorder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_RECORDERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConfigurationRecordersResponse.memberNameToFieldInitializer();
    private final List<ConfigurationRecorder> configurationRecorders;

    private DescribeConfigurationRecordersResponse(BuilderImpl builder) {
        super(builder);
        this.configurationRecorders = builder.configurationRecorders;
    }

    public final boolean hasConfigurationRecorders() {
        return this.configurationRecorders != null && !(this.configurationRecorders instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationRecorder> configurationRecorders() {
        return this.configurationRecorders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationRecorders() ? this.configurationRecorders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecordersResponse)) {
            return false;
        }
        DescribeConfigurationRecordersResponse other = (DescribeConfigurationRecordersResponse)((Object)obj);
        return this.hasConfigurationRecorders() == other.hasConfigurationRecorders() && Objects.equals(this.configurationRecorders(), other.configurationRecorders());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationRecordersResponse").add("ConfigurationRecorders", this.hasConfigurationRecorders() ? this.configurationRecorders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationRecorders": {
                return Optional.ofNullable(clazz.cast(this.configurationRecorders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ConfigurationRecorder>>> map = new HashMap<String, SdkField<List<ConfigurationRecorder>>>();
        map.put("ConfigurationRecorders", CONFIGURATION_RECORDERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRecordersResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationRecordersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationRecorder> configurationRecorders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecordersResponse model) {
            super(model);
            this.configurationRecorders(model.configurationRecorders);
        }

        public final List<ConfigurationRecorder.Builder> getConfigurationRecorders() {
            List<ConfigurationRecorder.Builder> result = ConfigurationRecorderListCopier.copyToBuilder(this.configurationRecorders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationRecorders(Collection<ConfigurationRecorder.BuilderImpl> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copyFromBuilder(configurationRecorders);
        }

        @Override
        public final Builder configurationRecorders(Collection<ConfigurationRecorder> configurationRecorders) {
            this.configurationRecorders = ConfigurationRecorderListCopier.copy(configurationRecorders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorders(ConfigurationRecorder ... configurationRecorders) {
            this.configurationRecorders(Arrays.asList(configurationRecorders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorders(Consumer<ConfigurationRecorder.Builder> ... configurationRecorders) {
            this.configurationRecorders(Stream.of(configurationRecorders).map(c -> (ConfigurationRecorder)((ConfigurationRecorder.Builder)ConfigurationRecorder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeConfigurationRecordersResponse build() {
            return new DescribeConfigurationRecordersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationRecordersResponse> {
        public Builder configurationRecorders(Collection<ConfigurationRecorder> var1);

        public Builder configurationRecorders(ConfigurationRecorder ... var1);

        public Builder configurationRecorders(Consumer<ConfigurationRecorder.Builder> ... var1);
    }
}

