/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of compliance based on either account ID or region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateConformancePackComplianceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateConformancePackComplianceSummary.Builder, AggregateConformancePackComplianceSummary> {
    private static final SdkField<AggregateConformancePackComplianceCount> COMPLIANCE_SUMMARY_FIELD = SdkField
            .<AggregateConformancePackComplianceCount> builder(MarshallingType.SDK_POJO).memberName("ComplianceSummary")
            .getter(getter(AggregateConformancePackComplianceSummary::complianceSummary))
            .setter(setter(Builder::complianceSummary)).constructor(AggregateConformancePackComplianceCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummary").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(AggregateConformancePackComplianceSummary::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_SUMMARY_FIELD,
            GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AggregateConformancePackComplianceCount complianceSummary;

    private final String groupName;

    private AggregateConformancePackComplianceSummary(BuilderImpl builder) {
        this.complianceSummary = builder.complianceSummary;
        this.groupName = builder.groupName;
    }

    /**
     * <p>
     * Returns an <code>AggregateConformancePackComplianceCount</code> object.
     * </p>
     * 
     * @return Returns an <code>AggregateConformancePackComplianceCount</code> object.
     */
    public final AggregateConformancePackComplianceCount complianceSummary() {
        return complianceSummary;
    }

    /**
     * <p>
     * Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.
     * </p>
     * 
     * @return Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.
     */
    public final String groupName() {
        return groupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceSummary());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateConformancePackComplianceSummary)) {
            return false;
        }
        AggregateConformancePackComplianceSummary other = (AggregateConformancePackComplianceSummary) obj;
        return Objects.equals(complianceSummary(), other.complianceSummary()) && Objects.equals(groupName(), other.groupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateConformancePackComplianceSummary").add("ComplianceSummary", complianceSummary())
                .add("GroupName", groupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceSummary":
            return Optional.ofNullable(clazz.cast(complianceSummary()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComplianceSummary", COMPLIANCE_SUMMARY_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregateConformancePackComplianceSummary, T> g) {
        return obj -> g.apply((AggregateConformancePackComplianceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateConformancePackComplianceSummary> {
        /**
         * <p>
         * Returns an <code>AggregateConformancePackComplianceCount</code> object.
         * </p>
         * 
         * @param complianceSummary
         *        Returns an <code>AggregateConformancePackComplianceCount</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceSummary(AggregateConformancePackComplianceCount complianceSummary);

        /**
         * <p>
         * Returns an <code>AggregateConformancePackComplianceCount</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AggregateConformancePackComplianceCount.Builder} avoiding the need to create one manually via
         * {@link AggregateConformancePackComplianceCount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregateConformancePackComplianceCount.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #complianceSummary(AggregateConformancePackComplianceCount)}.
         * 
         * @param complianceSummary
         *        a consumer that will call methods on {@link AggregateConformancePackComplianceCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceSummary(AggregateConformancePackComplianceCount)
         */
        default Builder complianceSummary(Consumer<AggregateConformancePackComplianceCount.Builder> complianceSummary) {
            return complianceSummary(AggregateConformancePackComplianceCount.builder().applyMutation(complianceSummary).build());
        }

        /**
         * <p>
         * Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.
         * </p>
         * 
         * @param groupName
         *        Groups the result based on Amazon Web Services account ID or Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);
    }

    static final class BuilderImpl implements Builder {
        private AggregateConformancePackComplianceCount complianceSummary;

        private String groupName;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateConformancePackComplianceSummary model) {
            complianceSummary(model.complianceSummary);
            groupName(model.groupName);
        }

        public final AggregateConformancePackComplianceCount.Builder getComplianceSummary() {
            return complianceSummary != null ? complianceSummary.toBuilder() : null;
        }

        public final void setComplianceSummary(AggregateConformancePackComplianceCount.BuilderImpl complianceSummary) {
            this.complianceSummary = complianceSummary != null ? complianceSummary.build() : null;
        }

        @Override
        public final Builder complianceSummary(AggregateConformancePackComplianceCount complianceSummary) {
            this.complianceSummary = complianceSummary;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        @Override
        public AggregateConformancePackComplianceSummary build() {
            return new AggregateConformancePackComplianceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
