/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object to filter the data you specify for an aggregator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregatorFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregatorFilters.Builder, AggregatorFilters> {
    private static final SdkField<AggregatorFilterResourceType> RESOURCE_TYPE_FIELD = SdkField
            .<AggregatorFilterResourceType> builder(MarshallingType.SDK_POJO).memberName("ResourceType")
            .getter(getter(AggregatorFilters::resourceType)).setter(setter(Builder::resourceType))
            .constructor(AggregatorFilterResourceType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<AggregatorFilterServicePrincipal> SERVICE_PRINCIPAL_FIELD = SdkField
            .<AggregatorFilterServicePrincipal> builder(MarshallingType.SDK_POJO).memberName("ServicePrincipal")
            .getter(getter(AggregatorFilters::servicePrincipal)).setter(setter(Builder::servicePrincipal))
            .constructor(AggregatorFilterServicePrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            SERVICE_PRINCIPAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AggregatorFilterResourceType resourceType;

    private final AggregatorFilterServicePrincipal servicePrincipal;

    private AggregatorFilters(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.servicePrincipal = builder.servicePrincipal;
    }

    /**
     * <p>
     * An object to filter the configuration recorders based on the resource types in scope for recording.
     * </p>
     * 
     * @return An object to filter the configuration recorders based on the resource types in scope for recording.
     */
    public final AggregatorFilterResourceType resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * An object to filter service-linked configuration recorders in an aggregator based on the linked Amazon Web
     * Services service.
     * </p>
     * 
     * @return An object to filter service-linked configuration recorders in an aggregator based on the linked Amazon
     *         Web Services service.
     */
    public final AggregatorFilterServicePrincipal servicePrincipal() {
        return servicePrincipal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatorFilters)) {
            return false;
        }
        AggregatorFilters other = (AggregatorFilters) obj;
        return Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(servicePrincipal(), other.servicePrincipal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregatorFilters").add("ResourceType", resourceType())
                .add("ServicePrincipal", servicePrincipal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ServicePrincipal":
            return Optional.ofNullable(clazz.cast(servicePrincipal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ServicePrincipal", SERVICE_PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregatorFilters, T> g) {
        return obj -> g.apply((AggregatorFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregatorFilters> {
        /**
         * <p>
         * An object to filter the configuration recorders based on the resource types in scope for recording.
         * </p>
         * 
         * @param resourceType
         *        An object to filter the configuration recorders based on the resource types in scope for recording.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(AggregatorFilterResourceType resourceType);

        /**
         * <p>
         * An object to filter the configuration recorders based on the resource types in scope for recording.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregatorFilterResourceType.Builder}
         * avoiding the need to create one manually via {@link AggregatorFilterResourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregatorFilterResourceType.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceType(AggregatorFilterResourceType)}.
         * 
         * @param resourceType
         *        a consumer that will call methods on {@link AggregatorFilterResourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceType(AggregatorFilterResourceType)
         */
        default Builder resourceType(Consumer<AggregatorFilterResourceType.Builder> resourceType) {
            return resourceType(AggregatorFilterResourceType.builder().applyMutation(resourceType).build());
        }

        /**
         * <p>
         * An object to filter service-linked configuration recorders in an aggregator based on the linked Amazon Web
         * Services service.
         * </p>
         * 
         * @param servicePrincipal
         *        An object to filter service-linked configuration recorders in an aggregator based on the linked Amazon
         *        Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipal(AggregatorFilterServicePrincipal servicePrincipal);

        /**
         * <p>
         * An object to filter service-linked configuration recorders in an aggregator based on the linked Amazon Web
         * Services service.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregatorFilterServicePrincipal.Builder}
         * avoiding the need to create one manually via {@link AggregatorFilterServicePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregatorFilterServicePrincipal.Builder#build()} is called
         * immediately and its result is passed to {@link #servicePrincipal(AggregatorFilterServicePrincipal)}.
         * 
         * @param servicePrincipal
         *        a consumer that will call methods on {@link AggregatorFilterServicePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #servicePrincipal(AggregatorFilterServicePrincipal)
         */
        default Builder servicePrincipal(Consumer<AggregatorFilterServicePrincipal.Builder> servicePrincipal) {
            return servicePrincipal(AggregatorFilterServicePrincipal.builder().applyMutation(servicePrincipal).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AggregatorFilterResourceType resourceType;

        private AggregatorFilterServicePrincipal servicePrincipal;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatorFilters model) {
            resourceType(model.resourceType);
            servicePrincipal(model.servicePrincipal);
        }

        public final AggregatorFilterResourceType.Builder getResourceType() {
            return resourceType != null ? resourceType.toBuilder() : null;
        }

        public final void setResourceType(AggregatorFilterResourceType.BuilderImpl resourceType) {
            this.resourceType = resourceType != null ? resourceType.build() : null;
        }

        @Override
        public final Builder resourceType(AggregatorFilterResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final AggregatorFilterServicePrincipal.Builder getServicePrincipal() {
            return servicePrincipal != null ? servicePrincipal.toBuilder() : null;
        }

        public final void setServicePrincipal(AggregatorFilterServicePrincipal.BuilderImpl servicePrincipal) {
            this.servicePrincipal = servicePrincipal != null ? servicePrincipal.build() : null;
        }

        @Override
        public final Builder servicePrincipal(AggregatorFilterServicePrincipal servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        @Override
        public AggregatorFilters build() {
            return new AggregatorFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
