/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether an Amazon Web Services resource or Config rule is compliant and provides the number of contributors
 * that affect the compliance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Compliance implements SdkPojo, Serializable, ToCopyableBuilder<Compliance.Builder, Compliance> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceType").getter(getter(Compliance::complianceTypeAsString))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()).build();

    private static final SdkField<ComplianceContributorCount> COMPLIANCE_CONTRIBUTOR_COUNT_FIELD = SdkField
            .<ComplianceContributorCount> builder(MarshallingType.SDK_POJO)
            .memberName("ComplianceContributorCount")
            .getter(getter(Compliance::complianceContributorCount))
            .setter(setter(Builder::complianceContributorCount))
            .constructor(ComplianceContributorCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceContributorCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD,
            COMPLIANCE_CONTRIBUTOR_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String complianceType;

    private final ComplianceContributorCount complianceContributorCount;

    private Compliance(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.complianceContributorCount = builder.complianceContributorCount;
    }

    /**
     * <p>
     * Indicates whether an Amazon Web Services resource or Config rule is compliant.
     * </p>
     * <p>
     * A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is noncompliant
     * if it does not comply with one or more of these rules.
     * </p>
     * <p>
     * A rule is compliant if all of the resources that the rule evaluates comply with it. A rule is noncompliant if any
     * of these resources do not comply.
     * </p>
     * <p>
     * Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for the Amazon
     * Web Services resource or Config rule.
     * </p>
     * <p>
     * For the <code>Compliance</code> data type, Config supports only <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. Config does not support the
     * <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether an Amazon Web Services resource or Config rule is compliant.</p>
     *         <p>
     *         A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is
     *         noncompliant if it does not comply with one or more of these rules.
     *         </p>
     *         <p>
     *         A rule is compliant if all of the resources that the rule evaluates comply with it. A rule is
     *         noncompliant if any of these resources do not comply.
     *         </p>
     *         <p>
     *         Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for the
     *         Amazon Web Services resource or Config rule.
     *         </p>
     *         <p>
     *         For the <code>Compliance</code> data type, Config supports only <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. Config does not support the
     *         <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
     * @see ComplianceType
     */
    public final ComplianceType complianceType() {
        return ComplianceType.fromValue(complianceType);
    }

    /**
     * <p>
     * Indicates whether an Amazon Web Services resource or Config rule is compliant.
     * </p>
     * <p>
     * A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is noncompliant
     * if it does not comply with one or more of these rules.
     * </p>
     * <p>
     * A rule is compliant if all of the resources that the rule evaluates comply with it. A rule is noncompliant if any
     * of these resources do not comply.
     * </p>
     * <p>
     * Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for the Amazon
     * Web Services resource or Config rule.
     * </p>
     * <p>
     * For the <code>Compliance</code> data type, Config supports only <code>COMPLIANT</code>,
     * <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. Config does not support the
     * <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceType}
     * will return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether an Amazon Web Services resource or Config rule is compliant.</p>
     *         <p>
     *         A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is
     *         noncompliant if it does not comply with one or more of these rules.
     *         </p>
     *         <p>
     *         A rule is compliant if all of the resources that the rule evaluates comply with it. A rule is
     *         noncompliant if any of these resources do not comply.
     *         </p>
     *         <p>
     *         Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for the
     *         Amazon Web Services resource or Config rule.
     *         </p>
     *         <p>
     *         For the <code>Compliance</code> data type, Config supports only <code>COMPLIANT</code>,
     *         <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. Config does not support the
     *         <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
     * @see ComplianceType
     */
    public final String complianceTypeAsString() {
        return complianceType;
    }

    /**
     * <p>
     * The number of Amazon Web Services resources or Config rules that cause a result of <code>NON_COMPLIANT</code>, up
     * to a maximum number.
     * </p>
     * 
     * @return The number of Amazon Web Services resources or Config rules that cause a result of
     *         <code>NON_COMPLIANT</code>, up to a maximum number.
     */
    public final ComplianceContributorCount complianceContributorCount() {
        return complianceContributorCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(complianceContributorCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compliance)) {
            return false;
        }
        Compliance other = (Compliance) obj;
        return Objects.equals(complianceTypeAsString(), other.complianceTypeAsString())
                && Objects.equals(complianceContributorCount(), other.complianceContributorCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Compliance").add("ComplianceType", complianceTypeAsString())
                .add("ComplianceContributorCount", complianceContributorCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceType":
            return Optional.ofNullable(clazz.cast(complianceTypeAsString()));
        case "ComplianceContributorCount":
            return Optional.ofNullable(clazz.cast(complianceContributorCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComplianceType", COMPLIANCE_TYPE_FIELD);
        map.put("ComplianceContributorCount", COMPLIANCE_CONTRIBUTOR_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Compliance, T> g) {
        return obj -> g.apply((Compliance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Compliance> {
        /**
         * <p>
         * Indicates whether an Amazon Web Services resource or Config rule is compliant.
         * </p>
         * <p>
         * A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is
         * noncompliant if it does not comply with one or more of these rules.
         * </p>
         * <p>
         * A rule is compliant if all of the resources that the rule evaluates comply with it. A rule is noncompliant if
         * any of these resources do not comply.
         * </p>
         * <p>
         * Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for the
         * Amazon Web Services resource or Config rule.
         * </p>
         * <p>
         * For the <code>Compliance</code> data type, Config supports only <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. Config does not support the
         * <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether an Amazon Web Services resource or Config rule is compliant.</p>
         *        <p>
         *        A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is
         *        noncompliant if it does not comply with one or more of these rules.
         *        </p>
         *        <p>
         *        A rule is compliant if all of the resources that the rule evaluates comply with it. A rule is
         *        noncompliant if any of these resources do not comply.
         *        </p>
         *        <p>
         *        Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for
         *        the Amazon Web Services resource or Config rule.
         *        </p>
         *        <p>
         *        For the <code>Compliance</code> data type, Config supports only <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. Config does not support the
         *        <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(String complianceType);

        /**
         * <p>
         * Indicates whether an Amazon Web Services resource or Config rule is compliant.
         * </p>
         * <p>
         * A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is
         * noncompliant if it does not comply with one or more of these rules.
         * </p>
         * <p>
         * A rule is compliant if all of the resources that the rule evaluates comply with it. A rule is noncompliant if
         * any of these resources do not comply.
         * </p>
         * <p>
         * Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for the
         * Amazon Web Services resource or Config rule.
         * </p>
         * <p>
         * For the <code>Compliance</code> data type, Config supports only <code>COMPLIANT</code>,
         * <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. Config does not support the
         * <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
         * </p>
         * 
         * @param complianceType
         *        Indicates whether an Amazon Web Services resource or Config rule is compliant.</p>
         *        <p>
         *        A resource is compliant if it complies with all of the Config rules that evaluate it. A resource is
         *        noncompliant if it does not comply with one or more of these rules.
         *        </p>
         *        <p>
         *        A rule is compliant if all of the resources that the rule evaluates comply with it. A rule is
         *        noncompliant if any of these resources do not comply.
         *        </p>
         *        <p>
         *        Config returns the <code>INSUFFICIENT_DATA</code> value when no evaluation results are available for
         *        the Amazon Web Services resource or Config rule.
         *        </p>
         *        <p>
         *        For the <code>Compliance</code> data type, Config supports only <code>COMPLIANT</code>,
         *        <code>NON_COMPLIANT</code>, and <code>INSUFFICIENT_DATA</code> values. Config does not support the
         *        <code>NOT_APPLICABLE</code> value for the <code>Compliance</code> data type.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder complianceType(ComplianceType complianceType);

        /**
         * <p>
         * The number of Amazon Web Services resources or Config rules that cause a result of <code>NON_COMPLIANT</code>
         * , up to a maximum number.
         * </p>
         * 
         * @param complianceContributorCount
         *        The number of Amazon Web Services resources or Config rules that cause a result of
         *        <code>NON_COMPLIANT</code>, up to a maximum number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceContributorCount(ComplianceContributorCount complianceContributorCount);

        /**
         * <p>
         * The number of Amazon Web Services resources or Config rules that cause a result of <code>NON_COMPLIANT</code>
         * , up to a maximum number.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComplianceContributorCount.Builder}
         * avoiding the need to create one manually via {@link ComplianceContributorCount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComplianceContributorCount.Builder#build()} is called immediately
         * and its result is passed to {@link #complianceContributorCount(ComplianceContributorCount)}.
         * 
         * @param complianceContributorCount
         *        a consumer that will call methods on {@link ComplianceContributorCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceContributorCount(ComplianceContributorCount)
         */
        default Builder complianceContributorCount(Consumer<ComplianceContributorCount.Builder> complianceContributorCount) {
            return complianceContributorCount(ComplianceContributorCount.builder().applyMutation(complianceContributorCount)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String complianceType;

        private ComplianceContributorCount complianceContributorCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Compliance model) {
            complianceType(model.complianceType);
            complianceContributorCount(model.complianceContributorCount);
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final ComplianceContributorCount.Builder getComplianceContributorCount() {
            return complianceContributorCount != null ? complianceContributorCount.toBuilder() : null;
        }

        public final void setComplianceContributorCount(ComplianceContributorCount.BuilderImpl complianceContributorCount) {
            this.complianceContributorCount = complianceContributorCount != null ? complianceContributorCount.build() : null;
        }

        @Override
        public final Builder complianceContributorCount(ComplianceContributorCount complianceContributorCount) {
            this.complianceContributorCount = complianceContributorCount;
            return this;
        }

        @Override
        public Compliance build() {
            return new Compliance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
