/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationAggregatorSourcesStatusResponse extends ConfigResponse
        implements
        ToCopyableBuilder<DescribeConfigurationAggregatorSourcesStatusResponse.Builder, DescribeConfigurationAggregatorSourcesStatusResponse> {
    private static final SdkField<List<AggregatedSourceStatus>> AGGREGATED_SOURCE_STATUS_LIST_FIELD = SdkField
            .<List<AggregatedSourceStatus>> builder(MarshallingType.LIST)
            .memberName("AggregatedSourceStatusList")
            .getter(getter(DescribeConfigurationAggregatorSourcesStatusResponse::aggregatedSourceStatusList))
            .setter(setter(Builder::aggregatedSourceStatusList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatedSourceStatusList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregatedSourceStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregatedSourceStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeConfigurationAggregatorSourcesStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGGREGATED_SOURCE_STATUS_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AggregatedSourceStatus> aggregatedSourceStatusList;

    private final String nextToken;

    private DescribeConfigurationAggregatorSourcesStatusResponse(BuilderImpl builder) {
        super(builder);
        this.aggregatedSourceStatusList = builder.aggregatedSourceStatusList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregatedSourceStatusList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAggregatedSourceStatusList() {
        return aggregatedSourceStatusList != null && !(aggregatedSourceStatusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an AggregatedSourceStatus object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregatedSourceStatusList} method.
     * </p>
     * 
     * @return Returns an AggregatedSourceStatus object.
     */
    public final List<AggregatedSourceStatus> aggregatedSourceStatusList() {
        return aggregatedSourceStatusList;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregatedSourceStatusList() ? aggregatedSourceStatusList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationAggregatorSourcesStatusResponse)) {
            return false;
        }
        DescribeConfigurationAggregatorSourcesStatusResponse other = (DescribeConfigurationAggregatorSourcesStatusResponse) obj;
        return hasAggregatedSourceStatusList() == other.hasAggregatedSourceStatusList()
                && Objects.equals(aggregatedSourceStatusList(), other.aggregatedSourceStatusList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigurationAggregatorSourcesStatusResponse")
                .add("AggregatedSourceStatusList", hasAggregatedSourceStatusList() ? aggregatedSourceStatusList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregatedSourceStatusList":
            return Optional.ofNullable(clazz.cast(aggregatedSourceStatusList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AggregatedSourceStatusList", AGGREGATED_SOURCE_STATUS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationAggregatorSourcesStatusResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationAggregatorSourcesStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationAggregatorSourcesStatusResponse> {
        /**
         * <p>
         * Returns an AggregatedSourceStatus object.
         * </p>
         * 
         * @param aggregatedSourceStatusList
         *        Returns an AggregatedSourceStatus object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedSourceStatusList(Collection<AggregatedSourceStatus> aggregatedSourceStatusList);

        /**
         * <p>
         * Returns an AggregatedSourceStatus object.
         * </p>
         * 
         * @param aggregatedSourceStatusList
         *        Returns an AggregatedSourceStatus object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedSourceStatusList(AggregatedSourceStatus... aggregatedSourceStatusList);

        /**
         * <p>
         * Returns an AggregatedSourceStatus object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.AggregatedSourceStatus.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.config.model.AggregatedSourceStatus#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.AggregatedSourceStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregatedSourceStatusList(List<AggregatedSourceStatus>)}.
         * 
         * @param aggregatedSourceStatusList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.AggregatedSourceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatedSourceStatusList(java.util.Collection<AggregatedSourceStatus>)
         */
        Builder aggregatedSourceStatusList(Consumer<AggregatedSourceStatus.Builder>... aggregatedSourceStatusList);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<AggregatedSourceStatus> aggregatedSourceStatusList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationAggregatorSourcesStatusResponse model) {
            super(model);
            aggregatedSourceStatusList(model.aggregatedSourceStatusList);
            nextToken(model.nextToken);
        }

        public final List<AggregatedSourceStatus.Builder> getAggregatedSourceStatusList() {
            List<AggregatedSourceStatus.Builder> result = AggregatedSourceStatusListCopier
                    .copyToBuilder(this.aggregatedSourceStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedSourceStatusList(Collection<AggregatedSourceStatus.BuilderImpl> aggregatedSourceStatusList) {
            this.aggregatedSourceStatusList = AggregatedSourceStatusListCopier.copyFromBuilder(aggregatedSourceStatusList);
        }

        @Override
        public final Builder aggregatedSourceStatusList(Collection<AggregatedSourceStatus> aggregatedSourceStatusList) {
            this.aggregatedSourceStatusList = AggregatedSourceStatusListCopier.copy(aggregatedSourceStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedSourceStatusList(AggregatedSourceStatus... aggregatedSourceStatusList) {
            aggregatedSourceStatusList(Arrays.asList(aggregatedSourceStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedSourceStatusList(Consumer<AggregatedSourceStatus.Builder>... aggregatedSourceStatusList) {
            aggregatedSourceStatusList(Stream.of(aggregatedSourceStatusList)
                    .map(c -> AggregatedSourceStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConfigurationAggregatorSourcesStatusResponse build() {
            return new DescribeConfigurationAggregatorSourcesStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
