/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConformancePackComplianceSummaryResponse extends ConfigResponse implements
        ToCopyableBuilder<GetConformancePackComplianceSummaryResponse.Builder, GetConformancePackComplianceSummaryResponse> {
    private static final SdkField<List<ConformancePackComplianceSummary>> CONFORMANCE_PACK_COMPLIANCE_SUMMARY_LIST_FIELD = SdkField
            .<List<ConformancePackComplianceSummary>> builder(MarshallingType.LIST)
            .memberName("ConformancePackComplianceSummaryList")
            .getter(getter(GetConformancePackComplianceSummaryResponse::conformancePackComplianceSummaryList))
            .setter(setter(Builder::conformancePackComplianceSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ConformancePackComplianceSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConformancePackComplianceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConformancePackComplianceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetConformancePackComplianceSummaryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFORMANCE_PACK_COMPLIANCE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConformancePackComplianceSummary> conformancePackComplianceSummaryList;

    private final String nextToken;

    private GetConformancePackComplianceSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.conformancePackComplianceSummaryList = builder.conformancePackComplianceSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConformancePackComplianceSummaryList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasConformancePackComplianceSummaryList() {
        return conformancePackComplianceSummaryList != null
                && !(conformancePackComplianceSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ConformancePackComplianceSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConformancePackComplianceSummaryList}
     * method.
     * </p>
     * 
     * @return A list of <code>ConformancePackComplianceSummary</code> objects.
     */
    public final List<ConformancePackComplianceSummary> conformancePackComplianceSummaryList() {
        return conformancePackComplianceSummaryList;
    }

    /**
     * <p>
     * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
     * response.
     * </p>
     * 
     * @return The nextToken string returned on a previous page that you use to get the next page of results in a
     *         paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConformancePackComplianceSummaryList() ? conformancePackComplianceSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConformancePackComplianceSummaryResponse)) {
            return false;
        }
        GetConformancePackComplianceSummaryResponse other = (GetConformancePackComplianceSummaryResponse) obj;
        return hasConformancePackComplianceSummaryList() == other.hasConformancePackComplianceSummaryList()
                && Objects.equals(conformancePackComplianceSummaryList(), other.conformancePackComplianceSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetConformancePackComplianceSummaryResponse")
                .add("ConformancePackComplianceSummaryList",
                        hasConformancePackComplianceSummaryList() ? conformancePackComplianceSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConformancePackComplianceSummaryList":
            return Optional.ofNullable(clazz.cast(conformancePackComplianceSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConformancePackComplianceSummaryList", CONFORMANCE_PACK_COMPLIANCE_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConformancePackComplianceSummaryResponse, T> g) {
        return obj -> g.apply((GetConformancePackComplianceSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConformancePackComplianceSummaryResponse> {
        /**
         * <p>
         * A list of <code>ConformancePackComplianceSummary</code> objects.
         * </p>
         * 
         * @param conformancePackComplianceSummaryList
         *        A list of <code>ConformancePackComplianceSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackComplianceSummaryList(
                Collection<ConformancePackComplianceSummary> conformancePackComplianceSummaryList);

        /**
         * <p>
         * A list of <code>ConformancePackComplianceSummary</code> objects.
         * </p>
         * 
         * @param conformancePackComplianceSummaryList
         *        A list of <code>ConformancePackComplianceSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conformancePackComplianceSummaryList(ConformancePackComplianceSummary... conformancePackComplianceSummaryList);

        /**
         * <p>
         * A list of <code>ConformancePackComplianceSummary</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.ConformancePackComplianceSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.config.model.ConformancePackComplianceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.ConformancePackComplianceSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #conformancePackComplianceSummaryList(List<ConformancePackComplianceSummary>)}.
         * 
         * @param conformancePackComplianceSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.ConformancePackComplianceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conformancePackComplianceSummaryList(java.util.Collection<ConformancePackComplianceSummary>)
         */
        Builder conformancePackComplianceSummaryList(
                Consumer<ConformancePackComplianceSummary.Builder>... conformancePackComplianceSummaryList);

        /**
         * <p>
         * The nextToken string returned on a previous page that you use to get the next page of results in a paginated
         * response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string returned on a previous page that you use to get the next page of results in a
         *        paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConformancePackComplianceSummary> conformancePackComplianceSummaryList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConformancePackComplianceSummaryResponse model) {
            super(model);
            conformancePackComplianceSummaryList(model.conformancePackComplianceSummaryList);
            nextToken(model.nextToken);
        }

        public final List<ConformancePackComplianceSummary.Builder> getConformancePackComplianceSummaryList() {
            List<ConformancePackComplianceSummary.Builder> result = ConformancePackComplianceSummaryListCopier
                    .copyToBuilder(this.conformancePackComplianceSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConformancePackComplianceSummaryList(
                Collection<ConformancePackComplianceSummary.BuilderImpl> conformancePackComplianceSummaryList) {
            this.conformancePackComplianceSummaryList = ConformancePackComplianceSummaryListCopier
                    .copyFromBuilder(conformancePackComplianceSummaryList);
        }

        @Override
        public final Builder conformancePackComplianceSummaryList(
                Collection<ConformancePackComplianceSummary> conformancePackComplianceSummaryList) {
            this.conformancePackComplianceSummaryList = ConformancePackComplianceSummaryListCopier
                    .copy(conformancePackComplianceSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackComplianceSummaryList(
                ConformancePackComplianceSummary... conformancePackComplianceSummaryList) {
            conformancePackComplianceSummaryList(Arrays.asList(conformancePackComplianceSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conformancePackComplianceSummaryList(
                Consumer<ConformancePackComplianceSummary.Builder>... conformancePackComplianceSummaryList) {
            conformancePackComplianceSummaryList(Stream.of(conformancePackComplianceSummaryList)
                    .map(c -> ConformancePackComplianceSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetConformancePackComplianceSummaryResponse build() {
            return new GetConformancePackComplianceSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
